<?php 
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
add_theme_support('wc-product-gallery-zoom');
add_theme_support('woocommerce');

add_action('init','change_woocommerce_action');
function change_woocommerce_action() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
    remove_action( 'woocommerce_shop_loop_item_title','woocommerce_template_loop_product_title', 10 );
    remove_action( 'woocommerce_after_shop_loop_item','woocommerce_template_loop_add_to_cart', 10 );
    remove_action( 'woocommerce_before_single_product_summary' , 'woocommerce_show_product_sale_flash', 10 );
    remove_action( 'woocommerce_after_single_product_summary' , 'woocommerce_output_product_data_tabs', 10 );
    remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );
    remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );  
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );   
}


add_action( 'woocommerce_single_product_summary', 'jws_woo_check_stock', 11 ); 
function jws_woo_check_stock() {
      $stock_status = get_post_meta( get_the_ID(), '_stock_status', true );
        
      if ( 'instock' == $stock_status) {        
            echo '<p class="stock in-stock">'.esc_html__('In Stock','idealauto').'</p>';  
      } else {
            echo '<p class="stock out-of-stock">'.esc_html__('Out of Stock','idealauto').'</p>';      
      }
}


function jws_product_nav_single() {
$prev_post = get_previous_post(); $next_post = get_next_post(); 
?>
<nav class="navigation post-navigation" role="navigation">
    			<?php 
                        if(!empty($prev_post)){    
                            $image_id = get_post_thumbnail_id($prev_post->ID);
                            $img = jws_getImageBySize(array('attach_id' => $image_id, 'thumb_size' => '160x160', 'class' => 'attachment-large wp-post-image'));
                            $img = (!empty($img['thumbnail'])) ? ''.$img['thumbnail'] : '';
                            echo '<div class="left">
                                   <div class="product-inner"> 
                                       '.$img.'
                                        <h5 class="title">
                                              <a href="'.get_the_permalink($prev_post->ID).'">'.get_the_title($prev_post->ID).'</a>
                                        </h5>
                                      
                                   </div>
                                   <a href="'.get_the_permalink($prev_post->ID).'"><span class="jws-icon-arrow-left"></span></a>
                            </div>'; 
                      
                            }else {
                                $first = new WP_Query('post_type=product&posts_per_page=1&order=DESC'); $first->the_post(); 
                                $image_id = get_post_thumbnail_id($first->ID);
                                $img = jws_getImageBySize(array('attach_id' => $image_id, 'thumb_size' => '160x160', 'class' => 'attachment-large wp-post-image'));
                                $img = (!empty($img['thumbnail'])) ? ''.$img['thumbnail'] : '';
                                echo '<div class="left">
                                    <div class="product-inner"> 
                                       '.$img.'
                                        <h5 class="title">
                                              <a href="'.get_the_permalink($first->ID).'">'.get_the_title($first->ID).'</a>
                                        </h5>
                                   </div>
                                   <a href="'.get_the_permalink($first->ID).'"><span class="jws-icon-arrow-left"></span></a>
                                </div>';  
                        
                                 wp_reset_postdata();   
                            }
                            if(!empty($next_post)){
                                  $image_id = get_post_thumbnail_id($next_post->ID);
                   
                                  $img = jws_getImageBySize(array('attach_id' => $image_id, 'thumb_size' => '160x160', 'class' => 'attachment-large wp-post-image'));
                                  $img = (!empty($img['thumbnail'])) ? ''.$img['thumbnail'] : '';  
                                   echo '<div class="right">
                                            <div class="product-inner"> 
                                                    '.$img.' 
                                                   <h5 class="title">
                                                       <a href="'.get_the_permalink($next_post->ID).'">'.get_the_title($next_post->ID).'</a>
                                                   </h5>
                                           </div> 
                                           <a href="'.get_the_permalink($next_post->ID).'"><span class="jws-icon-arrow-right"></span></a>
                                   </div>';   
                            }else {
                                $last  = new WP_Query('post_type=product&posts_per_page=1&order=ASC'); $last->the_post();
                                $image_id = get_post_thumbnail_id($last->ID);
                                $img = jws_getImageBySize(array('attach_id' => $image_id, 'thumb_size' => '160x160', 'class' => 'attachment-large wp-post-image'));
                                $img = (!empty($img['thumbnail'])) ? ''.$img['thumbnail'] : '';
                                 echo '<div class="right">
                                            <div class="product-inner"> 
                                               '.$img.'
                                               <h5 class="title">
                                                   <a href="'.get_the_permalink($last->ID).'">'.get_the_title($last->ID).'</a>
                                               </h5>
                                            </div> 
                                           <a href="'.get_the_permalink($last->ID).'"><span class="jws-icon-arrow-right"></span></a>
                                   </div>';
                                   wp_reset_postdata(); 
                            }
                 ?>
</nav><!-- .navigation -->
<?php     
}



function jws_woo_brand_single() {
     if (defined('idealautocore'))  echo '<div class="product-brand">'.get_the_term_list( get_the_ID(), 'product_brand', '', ', ' ).'</div>';
}

add_action('woocommerce_single_product_summary','jws_woo_brand_single',1);



function abChangeProductsTitle() {
            echo '<h5 class="woocommerce-loop-product__title"><a href="'.get_the_permalink().'">' . get_the_title() . '</a></h5>';
}
add_action('woocommerce_shop_loop_item_title', 'abChangeProductsTitle', 10 );

add_action( 'woocommerce_before_shop_loop_item_title', 'jws_product_label', 10 ); 

add_action( 'woocommerce_before_shop_loop_item_title', 'jws_product_thumbnail_gallery', 15 ); 

function jws_product_thumbnail_gallery() {
    

    global $product;
    if ( version_compare( WC_VERSION, '3.0.0', '<' ) ) {
    	$attachment_ids = $product->get_gallery_image_ids();
    } else {
    	$attachment_ids = $product->get_gallery_image_ids();
    }
    if ( isset( $attachment_ids[0] ) ) {

		$attachment_id = $attachment_ids[0];

		$title = get_the_title();
		$link  = get_the_permalink();
        $size_img = 'shop_catalog';
		$image = wp_get_attachment_image( $attachment_id, $size_img );

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="%s" class="gallery" title="%s">%s</a>', $link, $title, $image ), $attachment_id, get_the_ID() );
	}
 
    
}
    		


/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'jws_new_loop_shop_per_page', 20);

function jws_new_loop_shop_per_page($cols)
{
    global $jws_option;
    // $cols contains the current number of products per page based on the value stored on Options -> Reading
    // Return the number of products you wanna show per page.
    $cols = (isset($jws_option['product_per_page']) && !empty($jws_option['product_per_page'][0])) ? $jws_option['product_per_page'][0] : 9;
    if(isset($_GET['number']) && $_GET['number']) {  
      $cols = $_GET['number'];  
    }
    return $cols;
}

// Add Shipping tabs
   
add_filter( 'woocommerce_product_tabs', 'woo_new_product_tab' );  
function woo_new_product_tab( $tabs ) {
    global $jws_option;
    $feature_cat = (isset($jws_option['select_rent_features']) && !empty($jws_option['select_rent_features'])) ? $jws_option['select_rent_features'] : '';    	
    // Adds the new tab
    if(isset($feature_cat) && !empty($feature_cat)) {
      $feature = get_the_terms( get_the_ID(), 'pa_'.$feature_cat );  
    }else {
       $feature = ''; 
    }
    
    $specification = get_post_meta( get_the_ID(), 'specification', true );
    
    if(!empty($feature) && !is_wp_error($feature)) { 
        $tabs['feature_tab'] = array(
        		'title' 	=> esc_html__( 'Features', 'idealauto' ),
        		'priority' 	=> 1,
        		'callback' 	=> 'jws_woo_new_product_feature_tab'
        );
    }
    if(!empty($specification) && !is_wp_error($specification)) { 
       $tabs['specification_tab'] = array(
    		'title' 	=> esc_html__( 'Specification', 'idealauto' ),
    		'priority' 	=> 2,
    		'callback' 	=> 'jws_woo_new_product_specification_tab'
       );  
    }
   
    return $tabs;    
}
function jws_woo_new_product_feature_tab() {
 
        wc_get_template( 'single-product/tabs/features.php' );
 
}
function jws_woo_new_product_specification_tab() {
    wc_get_template( 'single-product/tabs/specifical.php' );
}

function jws_button_product_grid() {
    ?>
        <ul class="ct_ul_ol">
            <li><?php jws_add_to_wishlist_btn(); ?></li>
            <li>
                <a data-product_id="<?php echo get_the_ID(); ?>" class="quickview-button"> <i class="jws-icon-icon_zoom-in_alt"></i><span><?php echo esc_html__('Quick view','idealauto') ?></span></a>
            </li>
            <li><?php jws_add_to_compare_btn(); ?></li>
        </ul>
    <?php
}

if ( ! function_exists( 'jws_product_quickview_button' ) ) {
	/**
	 * Add wishlist Button to Product Image
	 */
	function jws_product_quickview_button() {

		?>
		<div class="quickview-icon">
			<button data-product_id="<?php echo get_the_ID(); ?>" class="quickview-button is-outline circle icon">
				<span class="lnr lnr-eye"></span>
                <div class="quickview-popup">
				    <?php echo esc_html__( 'Quick View', 'idealauto' ); ?>
			    </div>
			</button>
		</div>
		<?php
	}
}
   
if( ! function_exists( 'jws_ajax_load_product_quickview' ) ) {
    	function jws_ajax_load_product_quickview($id = false) {
    		if( isset($_GET['id']) ) {
    			$id = (int) $_GET['id'];
    		}
    
    
    		global $post, $product;
    
    
    		$args = array( 'post__in' => array($id), 'post_type' => 'product' );
    
    		$quick_posts = get_posts( $args );
    
    	
    
    		foreach( $quick_posts as $post ) :
    			setup_postdata($post);
    			$product = wc_get_product($post);
                wc_get_template_part( 'quickview/content', 'quickview' );
    		endforeach; 
    
    		wp_reset_postdata(); 
    
    		die();
    	}
    
        
        // Note: Keep default AJAX actions in case WooCommerce endpoint URL is unavailable
        add_action('wp_ajax_jws_ajax_load_product_quickview', 'jws_ajax_load_product_quickview');
        add_action('wp_ajax_nopriv_jws_ajax_load_product_quickview', 'jws_ajax_load_product_quickview');
    
} 
add_action('wp_logout','logout_redirect');

function logout_redirect(){

    wp_redirect( home_url('/') );
    
    exit;

}

if( ! function_exists( 'jws_product_label' ) ) {
	function jws_product_label() {
		global $product;

		$output = array();


		if ( $product->is_on_sale() ) {

			$percentage = '';

			if ( $product->get_type() == 'variable' ) {

				$available_variations = $product->get_variation_prices();
				$max_percentage = 0;

				foreach( $available_variations['regular_price'] as $key => $regular_price ) {
					$sale_price = $available_variations['sale_price'][$key];

					if ( $sale_price < $regular_price ) {
						$percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );

						if ( $percentage > $max_percentage ) {
							$max_percentage = $percentage;
						}
					}
				}

				$percentage = $max_percentage;
			} elseif ( ( $product->get_type() == 'simple' || $product->get_type() == 'external' ) ) {
				$percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
			}

			if ( $percentage ) {
				$output[] = '<span class="onsale jws_pr_label">-' . $percentage . '%' . '</span>';
			}else{
				$output[] = '<span class="onsale jws_pr_label">' . esc_html__( 'Sale', 'idealauto' ) . '</span>';
			}
		}
		
		if( !$product->is_in_stock() && $product->get_type() != 'variable' ){
			$output[] = '<span class="out-of-stock jws_pr_label">' . esc_html__( 'Sold', 'idealauto' ) . '</span>';
		}

		if ( $product->is_featured()) {
			$output[] = '<span class="featured jws_pr_label">' . esc_html__( 'Hot', 'idealauto' ) . '</span>';
		}
		
		if ( get_post_meta( get_the_ID(), 'jws_new_label', true )) {
			$output[] = '<span class="new jws_pr_label">' . esc_html__( 'New', 'idealauto' ) . '</span>';
		}
		
		
		if ( $output ) {
			echo '<div class="jws_pr_labels">' . implode( '', $output ) . '</div>';
		}
	}
}
if( ! function_exists( 'jws_product_share' ) ) {
	function jws_product_share() { ?>
	   
       <div class="product-share">
    
            <button><span class="jws-icon-008-share"></span></button>
          
            <div class="addthis_inline_share_toolbox" data-url="<?php the_permalink(); ?>" data-title="<?php the_title_attribute(); ?>">
                <div class="post-share-inner">
                
                    <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fab fa-facebook"></i></a>
            
            		<a target="_blank" href="//plus.google.com/share?url=<?php the_permalink(); ?>"><i class="fab fa-google"></i></a>
            
            		<a  target="_blank" href="//twitter.com/share?url=<?php the_permalink(); ?>"><i class="fab fa-twitter"></i></a>

                    <a  target="_blank" href="//www.linkedin.com/shareArticle?mini=true&title=<?php echo get_the_title(); ?>&url=<?php  the_permalink(); ?>"><i class="fab fa-linkedin"></i></a>
                    
                </div>
           </div>     
       </div>
       
    <?php }
}    

add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args', 20 );
  function jk_related_products_args( $args ) {
	$args['posts_per_page'] = 100; // 4 related products
	return $args;
}

add_action( 'updated_users_subscriptions_for_order', 'wc_subs_suspend_on_cod' );
function wc_subs_suspend_on_cod( $order ) {
    if ( class_exists( 'Subscriptio' ) || class_exists( 'RP_SUB' ) ) { 
          if ( ! is_object( $order ) ) {
                $order = new WC_Order( $order );
            }
        
            foreach ( WC_Subscriptions_Order::get_recurring_items( $order ) as $order_item ) {
        
                $subscription_key = WC_Subscriptions_Manager::get_subscription_key( $order->id, WC_Subscriptions_Order::get_items_product_id( $order_item ) );
                $payment_gateways = WC()->payment_gateways->payment_gateways();
                $payment_gateway  = isset( $payment_gateways[ $order->recurring_payment_method ] ) ? $payment_gateways[ $order->recurring_payment_method ] : '';
        
                if ( $payment_gateway->id == 'cod' && $order->get_status() != 'completed' ) {
                    WC_Subscriptions_Manager::put_subscription_on_hold( $order->user_id, $subscription_key );
                }
            } 
    }
}

/**
 * Add meta for add car and image limit
 */
add_action( 'woocommerce_product_options_general_product_data', 'jws_woocommerce_product_options_general_product_data', 999 );

if ( ! function_exists( 'jws_woocommerce_product_options_general_product_data' ) ) {
	/**
	 * Woocommerce product options general product data
	 */
	function jws_woocommerce_product_options_general_product_data() {
		global $post;
		$post_id = $post->ID;

		// Load product object.
		$product = wc_get_product( $post_id );

		if ( class_exists( 'Subscriptio' ) || class_exists( 'RP_SUB' ) ) {
			woocommerce_wp_text_input(
				array(
					'id'                => 'jws_car_quota',
					'placeholder'       => esc_html__( 'e.g. 100', 'idealauto' ),
					'label'             => esc_html__( 'Cars Quota', 'idealauto' ),
					'desc_tip'          => 'true',
					'type'              => 'number',
					'custom_attributes' => array(
						'step' => 'any',
						'min'  => '0',
					),
				)
			);
			woocommerce_wp_text_input(
				array(
					'id'                => 'jws_car_images_quota',
					'placeholder'       => esc_html__( 'e.g. 100', 'idealauto' ),
					'label'             => esc_html__( 'Cars Images Quota', 'idealauto' ),
					'desc_tip'          => 'true',
					'type'              => 'number',
					'custom_attributes' => array(
						'step' => 'any',
						'min'  => '0',
					),
				)
			);
		}
	}
}

add_action( 'woocommerce_process_product_meta', 'jws_woocommerce_process_product_meta' );

if ( ! function_exists( 'jws_woocommerce_process_product_meta' ) ) {
	/**
	 * Save meta.
	 *
	 * @param string $post_id .
	 */
	function jws_woocommerce_process_product_meta( $post_id ) {
		if ( isset( $_POST['jws_car_quota'] ) ) {
			$jws_car_quota = $_POST['jws_car_quota'];
			update_post_meta( $post_id, 'jws_car_quota', $jws_car_quota );
		}
		if ( isset( $_POST['jws_car_images_quota'] ) ) {
			$jws_car_images_quota = $_POST['jws_car_images_quota'];
			update_post_meta( $post_id, 'jws_car_images_quota', $jws_car_images_quota );
		}
	}
}

add_action( 'woocommerce_product_query', 'prefix_custom_pre_get_posts_query' );
/**
 * Hide Product Cateories from targetted pages in WooCommerce
 * @link https://gist.github.com/stuartduff/bd149e81d80291a16d4d3968e68eb9f8#file-wc-exclude-product-category-from-shop-page-php
 *
 */
function prefix_custom_pre_get_posts_query( $q ) {
	
	if( is_shop() || is_page('awards') ) { // set conditions here

	    $tax_query = (array) $q->get( 'tax_query' );
	
	    $tax_query[] = array(
	           'taxonomy' => 'product_cat',
	           'field'    => 'slug',
	           'terms'    => array( 'cat1', 'cat2' ), // set product categories here
	           'operator' => 'NOT IN'
	    );
	
	
	    $q->set( 'tax_query', $tax_query );
	}
}

if (!function_exists('jws_shop_page_link')) {
    function jws_shop_page_link($keep_query = false, $taxonomy = '')
    {
        // Base Link decided by current page
        if (defined('SHOP_IS_ON_FRONT')) {
            $link = home_url();
        } elseif (is_post_type_archive('product') || is_page(wc_get_page_id('shop'))) {
            $link = get_post_type_archive_link('product');

        } elseif (is_product_category()) {
            $link = get_term_link(get_query_var('product_cat'), 'product_cat');
        } elseif (is_product_tag()) {
            $link = get_term_link(get_query_var('product_tag'), 'product_tag');
        } else {
            $link = get_term_link(get_query_var('term'), get_query_var('taxonomy'));
        }

        if ($keep_query) {

            
            
            $link_array_slug = array(
                'min_price','max_price' ,'orderby','car_type','seats','features','lay_style','transmission','make','brand','category','product_pp','rating','coupon','end_date','start_date','dropin','dropoff','age'
                
            );
            
            
            foreach($link_array_slug as $get_slug) {
                if (isset($_GET[$get_slug])) {
                    $link = add_query_arg($get_slug, $_GET[$get_slug], $link);
                } 
            }
            
             // All current filters
            if ($_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes()) {

                foreach ($_chosen_attributes as $name => $data) {
                    if ($name === $taxonomy) {
                        continue;
                    }

                    $filter_name = sanitize_title(str_replace('pa_', '', $name));
                    if (!empty($data['terms'])) {
                        $link = add_query_arg('filter_' . $filter_name, implode(',', $data['terms']), $link);

                    }
                    if ('or' == $data['query_type']) {
                        $link = add_query_arg('query_type_' . $filter_name, 'or', $link);

                    }
                }
            }

            /**
             * Search Arg.
             * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
             */
            if (get_search_query()) {
                $link = add_query_arg('s', rawurlencode(wp_specialchars_decode(get_search_query())), $link);
            }

            
        }

        return $link;
    }
}

function custom_pre_get_posts_query( $q ) {

    $tax_query = (array) $q->get( 'tax_query' );
    $meta_query = (array) $q->get( 'meta_query' );
  
    if(isset($_GET['product_brand']) && $_GET['product_brand'] != '') {
        $array = explode("," , $_GET['product_brand']);
        $tax_query[] = array(
               	'taxonomy' => 'product_brand',
    			'field' => 'slug',
    			'terms' => $array
                
        );
    }

	//booking filter location
	if ( isset($_GET['dropin']) && $_GET['dropin'] != 'none') {
	   $meta_query[] = array(
       
            array(
    				'key'     => '_rental_dropin_locations2',
    				'value'   => sanitize_text_field( $_GET['dropin'] ),
    				'compare' => 'LIKE',
    		)
       ) ;
		
	}
    
    //booking filter location
	if (  isset($_GET['dropoff']) && $_GET['dropoff'] != 'none') {
	   $meta_query[] = array(
         
            array(
    				'key'     => '_rental_dropoff_locations2',
    				'value'   => sanitize_text_field( $_GET['dropoff'] ),
    				'compare' => 'LIKE',
    		)
       ) ;
		
	}
    
	if ( isset( $_GET['price_filter'] ) ) {
		$price = sanitize_text_field( urldecode( $_GET['price_filter'] ) );

		$price = explode( ',', $price );

		$meta_query[] = array(
			'relation' => 'AND',
			array(
				'key' => '_base_cost',
				'value' => (int) $price[0],
				'compare' => '>=',
				'type' => 'NUMERIC'
			),
			array(
				'key' => '_base_cost',
				'value' => (int) $price[1],
				'compare' => '<=',
				'type' => 'NUMERIC'
			)
		);
	}
    
    global $jws_option;

    if(isset($jws_option['exclude-product-in-shop']) && !empty($jws_option['exclude-product-in-shop'])) {
        $result = array_map('intval', array_filter($jws_option['exclude-product-in-shop'], 'is_numeric'));
    
       
           $q->set('post__not_in' , $result); // use integers
    
    }
    
        
	if(isset($_GET['rating']) && $_GET['rating'] != '') { 
	 
        global $wpdb;
		$post_ids = array();

          $rating = $_GET['rating'];
		if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '3.6.0' ) >= 0 ) {
			$query = sprintf(
				"SELECT product_id FROM {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup WHERE wc_product_meta_lookup.average_rating >= %s",
				esc_sql( floatval( $rating ) )
			);
		} else {
			$query = sprintf(
				"SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_wc_average_rating' AND meta_value >= %s",
				esc_sql( floatval( $rating ) )
			);
		}
		$post_ids = $wpdb->get_col( $query );
		if ( is_array( $post_ids ) ) {
			$post_ids = array_map( 'intval', $post_ids );
		}
        if(isset($jws_option['exclude-product-in-shop']) && !empty($jws_option['exclude-product-in-shop'])) { 
          $post_ids = array_diff($post_ids, $jws_option['exclude-product-in-shop']); 
            
        }

        $q->set('post__in' , $post_ids); // use integers
        
        
    }
    
     
    if(isset($_GET['product_pp']) && $_GET['product_pp'] != '') { 
        
        $q->set('posts_per_page' , $_GET['product_pp']); // use integers
    }
    
        



    $q->set( 'tax_query', $tax_query );
    $q->set( 'meta_query', $meta_query );

   
}
add_action( 'woocommerce_product_query', 'custom_pre_get_posts_query' );

function wc_get_rating_html_compare( $rating ) { 
    if ( $rating > 0 ) { 
        $rating_html = '<div class="star-rating" title="' . sprintf( esc_attr__( 'Rated %s out of 5','idealauto' ), $rating ) . '">'; 
        $rating_html .= '<span style="width:' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . esc_html__( 'out of 5','idealauto' ) . '</span>'; 
        $rating_html .= '</div>'; 
    } else { 
        $rating_html = ''; 
    } 
    return $rating_html; 
} 

//Ajax add to compare
function jws_ajax_add_to_garage()
{

    $response['status'] = 'no_status';
    if(empty( $_POST['gara_id'] ) ) {
      $response['response'] = '<div class="garage-notes">'.esc_html__( 'Please select all field.', 'idealauto' ).'</div>';  
    }
    if ( count(explode("-",$_POST['gara_id'])) < 4 ) {
        $_COOKIE['jws_my_garage'] = array();
    }
    if ( !empty( $_POST['post_action'] ) and $_POST['post_action'] == 'remove' ) {
        if ( !empty( $_POST['gara_id'] ) ) {
            $new_name = $_POST['gara_id'];
        
            setcookie( 'jws_my_garage[' . $new_name . ']', '', time() - 3600, '/' );
            unset( $_COOKIE['jws_my_garage'][$new_name] );

            $response['status'] = 'success';
            $response['response'] = get_the_title( $_POST['post_id'] ) . ' ' . esc_html__( 'was removed from compare', 'idealauto' );
        }
    } else {
        if ( !empty( $_POST['gara_id'] ) && count(explode("-",$_POST['gara_id'])) >= 4 ) {
            $new_name = $_POST['gara_id'];
            $newurl = str_replace(' ', '&', $_POST['gara_url']);
            if ( !in_array( $newurl, $_COOKIE['jws_my_garage'] ) ) {
                    setcookie( 'jws_my_garage[' . $new_name . ']', $newurl, time() + ( 86400 * 30 ), '/' );
                    $_COOKIE['jws_my_garage'][$new_name] = $newurl;
                    $response['status'] = 'success';
                    $response['response'] =  '<div class="garage-notes">'.str_replace('-', ' ', $new_name) . ' - ' . esc_html__( 'Added to garage', 'idealauto' ).'</div>';
               
            } else {
                $response['status'] = 'warning';
                $response['response'] = '<div class="garage-notes">'.str_replace('-', ' ', $new_name) . ' ' . esc_html__( 'has been added', 'idealauto' ).'</div>';
            }
        }
    }
    
    $response['garage_html'] = garage_added();
   

    wp_send_json( $response );
    exit;
}
add_action( 'wp_ajax_jws_ajax_add_to_garage', 'jws_ajax_add_to_garage' );
add_action( 'wp_ajax_nopriv_jws_ajax_add_to_garage', 'jws_ajax_add_to_garage' );
function garage_added() {
   $gara = ''; 
   if (isset($_COOKIE['jws_my_garage'])) { 
        foreach ($_COOKIE['jws_my_garage'] as $name => $value) {
            $value = htmlspecialchars($value);
            $gara .= '<li><a href="'.get_permalink( wc_get_page_id( 'shop' ) ).'?garage'.$value.'">'.str_replace('-', ' ', $name).'</a><span class="jws-icon-icon_close-1 remove-garage" data-id="'.$name.'"></span></li>';
        }         
   }
   return $gara;   
}

function woocommerce_group_taxonomy() {
    

		$labels = array(
    				'name' => esc_html__( 'Product brand', 'idealauto' ),
    				'singular_name' => esc_html__( 'Product brand', 'idealauto' ),
    				'menu_name' => esc_html_x( 'Brand', 'Admin menu name', 'idealauto' ),
    				'search_items' => esc_html__( 'Search Product brand', 'idealauto' ),
    				'all_items' => esc_html__( 'All Product brand', 'idealauto' ),
    				'parent_item' => esc_html__( 'Parent Product brand', 'idealauto' ),
    				'parent_item_colon' => esc_html__( 'Parent Product Category:', 'idealauto' ),
    				'edit_item' => esc_html__( 'Edit Product brand', 'idealauto' ),
    				'update_item' => esc_html__( 'Update Product brand', 'idealauto' ),
    				'add_new_item' => esc_html__( 'Add New Product brand', 'idealauto' ),
    				'new_item_name' => esc_html__( 'New Product Category Name', 'idealauto' )
    	);
	
        $args = array(
    			'hierarchical' => false,
    			'update_count_callback' => '_wc_term_recount',
    			'label' => esc_html__( 'Product Brand', 'idealauto' ),
    			'labels' => $labels,
    			'show_ui' => true,
    			'query_var' => true,
    			'capabilities' => array(
    				'manbrand_terms' => 'manbrand_product_terms',
    				'edit_terms' => 'edit_product_terms',
    				'delete_terms' => 'delete_product_terms',
    				'assign_terms' => 'assign_product_terms',
    			),
    			'rewrite' => array(
    				'slug' => empty( $permalinks['product_brand_base'] ) ? esc_html_x( 'product-brand', 'slug', 'idealauto' ) : $permalinks['product_brand_base'],
    				'with_front' => false,
    				'hierarchical' => true,
    			),
		);
        
        
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'product_brand', array( 'product' ), $args  );
        }

}


add_action( 'init', 'woocommerce_group_taxonomy' );

add_action( 'admin_init', 'jws_remove_metabox_product' , 100);
if ( ! function_exists( 'jws_remove_metabox_product' ) ) {
	/**
	 * Remove metabox.
	 */
	function jws_remove_metabox_product() {
		remove_meta_box( 'tagsdiv-product_features', 'product', 'side' );
        remove_meta_box( 'tagsdiv-product_group', 'product', 'side' );
        remove_meta_box( 'tagsdiv-product_brand', 'product', 'side' );
	}
}
