<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * Override this template by copying it to yourtheme/woocommerce/content-single-product.php
 *
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version    4.6.4
 */


if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
if(!function_exists('jws_run_rent_woocommerce_Plugin')) {
    echo '<h3>'.esc_html__('You please turn on plugin jws woocommerce rent.','idealauto').'</h3>';
    return;
}
wp_enqueue_style('lightgallery'); 
wp_enqueue_script('lightgallery-all');

global $product,$jws_option;
$attachment_ids = $product->get_gallery_image_ids();
if(!empty($attachment_ids)) :
?>

<div class="rent-gallery">
<div class="swiper-wrapper">
<?php
foreach( $attachment_ids as $attachment_id ) 
{
  $full_url = wp_get_attachment_image_src( $attachment_id, 'full' )[0];  
  echo '<div class="slider-item swiper-slide">';  
        echo '<div class="overlay"></div>';
        echo '<div  style="background-image:url('.$full_url.')" class="image"></div>';
  echo '</div>';  
}
?>
</div>
 <!-- Add Pagination -->
 <div class="container">
<div class="swiper-pagination"></div>
</div>
<!-- Add Arrows -->
<div class="swiper-button-next"><i class="jws-icon-arrow_carrot-right"></i></div>
<div class="swiper-button-prev"><i class="jws-icon-arrow_carrot-left"></i></div>
</div>

<?php endif; ?>

<div class="container">
    <?php
        /**
         * Hook: woocommerce_before_single_product.
         *
         * @hooked wc_print_notices - 10
         */
        do_action( 'woocommerce_before_single_product' );
     ?>
    <div class="row">
        <div class="col-xl-8 col-12 rent-container">
            <?php $content = get_the_terms( get_the_ID(), 'product_cat' ); ?>
            <?php if(!empty($content)) : ?>
                <div class="rent-cat">
                <?php 
                     if(!empty($content)) {   
                         foreach ($content  as $term  ) {
                            echo '<span>'.$term->name.'</span>';
                        }   
                    } 
                ?>
                </div>
            <?php endif; ?>
            <h1 class="product-title"><?php the_title(); ?></h1>
            <?php 
                 $body_cat = (isset($jws_option['select_rent_body']) && !empty($jws_option['select_rent_body'])) ? $jws_option['select_rent_body'] : '';
          
            
            $cartype = get_the_terms( get_the_ID(), 'pa_'.$body_cat ); ?>
            <?php if(!empty($cartype)) : ?>
                <div class="rent-cartype">
                <?php 
                     if(!empty($cartype)) {  
                         foreach ($cartype  as $term  ) {
                            echo '<span>'.$term->name.'</span>';
                        }   
                    } 
                ?>
                </div>
            <?php endif; ?>
            <?php
                $seats = get_post_meta( get_the_ID(), '_rental_car_seats', true ); 
                $fuel = get_post_meta( get_the_ID(), '_rental_car_fuel', true );
                $transmission = get_post_meta( get_the_ID(), '_rental_car_transmission', true );
                $doors = get_post_meta( get_the_ID(), '_rental_car_doors', true );
             ?>
             <div class="product-attr">
                <?php if(!empty($seats)) : ?>
                    <span class="item">
                        <img class="seat" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/rent/seat.svg">
                        <?php echo esc_attr($seats); ?>
                   </span>
                <?php endif; ?>
                <?php if(!empty($transmission)) : ?>
                    <span class="item">
                        <img class="transmission" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/rent/transmission.svg">
                        <?php echo esc_attr($transmission); ?>
                   </span>
                <?php endif; ?>
                <?php if(!empty($doors)) : ?>
                    <span class="item">
                        <img class="door" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/rent/door.svg">
                        <?php echo esc_attr($doors); ?>
                   </span>
                <?php endif; ?>
                <?php if(!empty($fuel)) : ?>
                    <span class="item">
                        <img class="fuel" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/rent/fuel.svg">
                        <?php echo esc_attr($fuel); ?>
                   </span>
                <?php endif; ?>
            </div>
           
            <div class="rent-description">
                <?php $thecontent = get_the_content(); if(!empty( $thecontent )): ?>
                  <label><?php echo esc_html__('DESCRIPTION','idealauto'); ?></label>
                <?php endif; ?>
                <?php the_content(); ?>
            </div>
           
            <?php woocommerce_output_product_data_tabs(); ?>
            <?php  jws_wpd_wc_add_product_reviews(); ?>
        </div>
        <div class="col-xl-4 col-12">
            <?php wc_get_template( 'single-product/add-to-cart/rent.php' ); ?>
        </div>
    </div>
</div>
<?php wc_get_template( 'single-product/layout/map.php' ); ?>
<div class="container"><?php 	do_action( 'woocommerce_after_single_product_summary' ); ?> </div>  
<?php do_action( 'woocommerce_after_single_product' ); ?>