<?php
/**
 * Result Count
 *
 * Shows text: Showing x - x of x results.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/result-count.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $jws_option , $wp;
 
if ( '' === get_option( 'permalink_structure' ) ) {
	$form_action = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
} else {
	$form_action = preg_replace( '%\/page/[0-9]+%', '', home_url( trailingslashit( $wp->request ) ) );
}         
?>
<div class="shop-nav-top">
<div class="shop-top-filters-left">
    <a class="toggle-shop-sidebar" href="javascript:void(0)">
       <i class="jws-icon-005-list"></i>
    </a>
    <span class="selected-box select-per-page">
        <span><?php echo esc_html__('Show on page','idealauto'); ?></span>
        <form method="get" action="<?php echo esc_url( $form_action ); ?>">
    		<select name="product_pp" id="pgs_product_pp">
    			<?php
                $per_page_array = (isset($jws_option['product_per_page']) && !empty($jws_option['product_per_page'][0])) ? $jws_option['product_per_page'] : array('9','12','18','24');
            
         
                $cars_pp_selected = ( isset( $_GET['product_pp'] ) && ! empty( $_GET['product_pp'] ) ) ? $_GET['product_pp'] : $per_page;
                foreach ($per_page_array as & $value) {
                    ?>
    				<option value="<?php echo esc_html( $value ); ?>" <?php selected( $cars_pp_selected, $value ); ?>><?php echo esc_html( $value ).esc_html(' items','idealauto'); ?></option>
    				<?php
                }
    
    			?>
    		</select>
            <?php  echo wc_query_string_form_fields( null, array('product_pp'), '', true ); ?>
        </form>
    </span>
</div>