<?php
/**
 * Loop Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
$rent_price = get_post_meta( get_the_ID(), "_base_cost", true );
if ( $product->is_type( 'jws_rental' ) ) { ?> 
    <span class="price" data-html="<?php echo esc_attr('From','idealauto'); ?>">
        <span class="woocommerce-Price-amount"><?php echo ''.jws_get_formatted_price(); ?></span>
        <span class="day">/ <?php echo esc_html__('day','idealauto'); ?></span>
    </span>
<?php }else{

     if ( $price_html = $product->get_price_html() ) : ?>
    	<span class="price" data-html="<?php echo esc_attr('From','idealauto'); ?>">
            <?php echo ''.$price_html; ?>
        </span>
    <?php endif;
}