<?php
/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 */

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
<div class="woocommerce-form-coupon-toggle">
	<?php wc_print_notice( apply_filters( 'woocommerce_checkout_coupon_message', esc_html__( 'Have a coupon?', 'idealauto' ) . ' <a href="#" class="showcoupon">' . esc_html__( 'Click here to enter your code', 'idealauto' ) . '</a>' ), 'notice' ); ?>
</div>

<form class="checkout_coupon woocommerce-form-coupon" method="post" style="display:none">
<div class="form-inner">
	<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'idealauto' ); ?></p>

	<p class="form-row form-row-first">
		<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'idealauto' ); ?>" id="coupon_code" value="<?php echo isset($_COOKIE['coupon_code']) ? $_COOKIE['coupon_code'] : ''; ?>" />
	</p>

	<p class="form-row form-row-last">
		<button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'idealauto' ); ?>"><?php esc_html_e( 'Apply coupon', 'idealauto' ); ?></button>
	</p>

	<div class="clear"></div>
</div>
</form>

</div>
