<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage idealauto
 * @since 1.0.0
 */

get_header();
wp_enqueue_script( 'stick-content', JWS_URI_PATH. '/assets/js/sticky_content.js', array(), '', true );
global $jws_option; 
if (isset($jws_option['service_position_sidebar']) && $jws_option['service_position_sidebar'] == 'no_sidebar') {  
    $content_col = 'post_content col-xl-12 col-lg-12 col-12';
    $sidebar_col = 'post_sidebar main-sidebar col-xl-12 col-lg-12 col-12'; 
    $class = ' no_sidebar';    
}else{
    $content_col = 'post_content col-xl-9 col-lg-12 col-12';
    $sidebar_col = 'post_sidebar main-sidebar col-xl-3 col-lg-12 col-12'; 
    $class = ' has_sidebar'; 
}

?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
            <div class="container <?php echo esc_attr($class); ?>">
                <div class="row">
                    <?php if(isset($jws_option['service_position_sidebar']) && $jws_option['service_position_sidebar'] == 'left') { ?>
                        <div class="<?php echo esc_attr($sidebar_col); ?>">
                            <div class="jws_sticky_move">
                                <?php
                                    if (isset($jws_option['select-sidebar-service-single']) && !empty($jws_option['select-sidebar-service-single'])) { 
                                                 echo do_shortcode('[hf_template id="' . $jws_option['select-sidebar-service-single'] . '"]'); 
                                    }	
        		                 ?>
                             </div>
                        </div>
                    <?php  } ?>
                    <div class="<?php echo esc_attr($content_col); ?>">
                        <?php
                			/* Start the Loop */
                			while ( have_posts() ) :
                				the_post();
                				get_template_part( 'template-parts/content/service/single/entry' );
                			endwhile; // End of the loop.
            			?>
                    </div>
                    <?php if(isset($jws_option['service_position_sidebar']) && $jws_option['service_position_sidebar'] == 'right') { ?>
                        <div class="<?php echo esc_attr($sidebar_col); ?>">
                            <div class="jws_sticky_move">
                                <?php
                                    if (isset($jws_option['select-sidebar-service-single']) && !empty($jws_option['select-sidebar-service-single'])) { 
                                                 echo do_shortcode('[hf_template id="' . $jws_option['select-sidebar-service-single'] . '"]'); 
                                    }	
        		                 ?>
                             </div>
                        </div>
                    <?php  } ?>
                </div>
                <?php 
                    if((isset($jws_option['select-related-blog']) && !empty($jws_option['select-related-blog'])) && ($layout != 'layout3' && $layout != 'layout5' && $layout != 'layout6' && $layout != 'layout7' && $layout != 'layout8')) { 
                         $related = get_posts( array( 'category__in' => wp_get_post_categories($post->ID), 'numberposts' => 100,'post_type' => 'post', 'post__not_in' => array($post->ID) ) );
                         if(isset($related[0])) : ?>
                         <div class="post_related">
                            <?php echo do_shortcode('[hf_template id="' . $jws_option['select-related-blog'] . '"]'); ?>
                         </div>
                <?php endif; }  ?>
            </div>
		</main><!-- #main -->
	</div><!-- #primary -->
<?php
get_footer();