<?php 
class jws_PRICE_FILTER_class extends WP_Widget {

	function __construct() {
		$args = array(
			'name'        => esc_html__( 'Rent Price filter', 'idealauto' ),
			'description' => esc_html__( 'It displays Filter price', 'idealauto' ),
			'classname'   => 'widget-filter-price'
		);
		parent::__construct( '', '', $args );

	}

	/**
	 * method to display in the admin
	 *
	 * @param $instance
	 */
	function form( $instance ) {
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'       => esc_html__( 'PRICE', 'idealauto' ), // Legacy.
				'text_button' => esc_html__( 'Filter', 'idealauto' ), // Legacy.

			)
		);

		extract( $instance );

		?>
		<p>
			<label
				for="<?php echo esc_attr( esc_attr( $this->get_field_id( 'title' ) ) ); ?>"> <?php esc_html_e( 'Title:',
					'idealauto' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( esc_attr( $this->get_field_id( 'title' ) ) ); ?>"
			       name="<?php echo esc_attr( esc_attr( $this->get_field_name( 'title' ) ) ); ?>" type="text"
			       value="<?php if ( isset( $title ) ) {
				       echo esc_attr( $title );
			       } ?>">
		</p>
		<p>
			<label
				for="<?php echo esc_attr( esc_attr( $this->get_field_id( 'text_button' ) ) ); ?>"> <?php esc_html_e( 'text_button:',
					'idealauto' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( esc_attr( $this->get_field_id( 'text_button' ) ) ); ?>"
			       name="<?php echo esc_attr( esc_attr( $this->get_field_name( 'text_button' ) ) ); ?>" type="text"
			       value="<?php if ( isset( $text_button ) ) {
				       echo esc_attr( $text_button );
			       } ?>">
		</p>
		<?php
	}

	/**
	 * frontend for the site
	 *
	 * @param $args
	 * @param $instance
	 */
	function widget( $args, $instance ) {
		//default values
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'       => esc_html__( 'PRICE', 'idealauto' ), // Legacy.
				'text_button' => esc_html__( 'Filter', 'idealauto' ), // Legacy.

			)
		);


		extract( $args );
		extract( $instance );
       
		// Create a filter to the other plug-ins can change them
		$title         = sanitize_text_field( apply_filters( 'widget_title', $title ) );
		$before_widget = str_ireplace( 'class="widget"', 'class="widget widget-tag-cloud"', $before_widget );
		echo ''.$before_widget . "" ;
		echo ''.$before_title  . esc_attr( $title ) . ''. $after_title ;
        $meta_values = get_meta_values( '_base_cost', 'product' );  

        if(empty($meta_values)) {
            return '';
        }
        $min_price = getMin($meta_values);
        $max_price = getMax($meta_values);
        if($min_price == '') {
            echo esc_html__('There are some products that do not include price car rental. please check again','idealauto');
        }else{
          	?>

        		<div class="">
        			<form action="<?php echo esc_url( get_permalink( wc_get_page_id( ( 'shop' ) ) ) ); ?>"
        			      method="get">
        				<?php
        
        				if ( isset( $_GET['price_filter'] ) ) {
        					$price = sanitize_text_field( urldecode( $_GET['price_filter'] ) );
        
        					$price = explode( ',', $price );
        					?>
        				    <span class="price-numner">    	
                                <span  class="slider-result" data-min="<?php echo esc_attr($min_price); ?>"
        						data-max="<?php echo esc_attr($max_price); ?>"
        						data-value_min="<?php echo esc_attr( $price[0] ); ?>"
        						data-value_max="<?php echo esc_attr( $price[1] ); ?>">
                                    <?php echo esc_html($price[0].$price[1]); ?>
                                </span>
                                <span>/<?php echo esc_html__('day','idealauto'); ?></span>
                            </span>    
        					<?php
        				} else {
        					?>
                            <span class="price-numner">
                                <span  class="slider-result" 	data-min="<?php echo esc_attr($min_price); ?>"
        						data-max="<?php echo esc_attr($max_price); ?>"
        						data-value_min="<?php echo esc_attr($min_price); ?>"
        						data-value_max="<?php echo esc_attr($max_price); ?>">
                                    <?php echo esc_html($min_price.$max_price); ?>
                                </span>
                                <span>/<?php echo esc_html__('day','idealauto'); ?></span>
                            </span>    
        					<?php
        				}
        				?>
                        <div id="slider-rent-range"></div>
        				<input name="price_filter" type="hidden" id="amout_rating" value="">
                        <?php echo wc_query_string_form_fields( null, array( 'price_filter', 'paged' ), '', true ); ?>
        			</form>
        		</div>
    
    		<?php  }

		echo wp_kses_post( $after_widget );
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}
}

function get_meta_values( $meta_key,  $post_type = 'post' ) {

    $posts = get_posts(
        array(
            'post_type' => $post_type,
            'meta_key' => $meta_key,
            'posts_per_page' => -1,
            'tax_query' => array(
            array(
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'jws_rental', 
                ),
            ),
        )
    );

    $meta_values = array();
    foreach( $posts as $post ) {
        $meta_values[] = get_post_meta( $post->ID, $meta_key, true );
    }

    return $meta_values;

}


function getMax($array)  
{ 
   $n = count($array);  
   $max = $array[0]; 
   for ($i = 1; $i < $n; $i++)  
       if ($max < $array[$i]) 
           $max = $array[$i]; 
    return $max;        
} 
  
// Returns maximum in array 
function getMin($array)  
{ 
   $n = count($array);  
   $min = $array[0]; 
   for ($i = 1; $i < $n; $i++)  
       if ($min > $array[$i]) 
           $min = $array[$i]; 
    return $min;        
} 


if(function_exists('insert_widgets')) {
    insert_widgets( 'jws_PRICE_FILTER_class' );
}