<?php 
/**
 * Adds Cardealer Helpert Widget dealer Filters.
 *
 * @package car-dealer-helper/functions
 * @version 1.0.0
 */

/**
 * Cardealer Helpert Widget dealer Filters.
 */
class My_Garage extends WP_Widget {

    
   function __construct() {
		$args = array(
			'name'        => esc_html__( 'Jws My Garage', 'idealauto' ),
			'description' => esc_html__( 'Add My Garage.', 'idealauto' ),
			'classname'   => 'my-garage'
		);

        parent::__construct( 'my-garage', __( 'Jws My Garage','idealauto' ), $args );

	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		global $jws_option;

		$widget_id = ! isset( $args['widget_id'] ) ? 1 : $args['widget_id'];
		echo ''.$args['before_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE

		if ( ! empty( $instance['title'] ) ) {
			echo ''.$args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . '' . $args['after_title']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
		}

        ?>

        <div class="jws-my-garage">
            <a class="javascript:void(0)"><?php echo esc_html__('My garage', 'idealauto'); ?></a>
        </div>

        <?php

		echo ''.$args['after_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
		public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );



		return $instance;
	}
	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
	
        
        // Defaults.
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'   => '',
			
			)
		);
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'idealauto' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
		</p>

		<?php
	}
}

if(function_exists('insert_widgets')) {
    insert_widgets( 'My_Garage' );
}