<?php 
/**
 * Adds Cardealer Helpert Widget dealer Filters.
 *
 * @package car-dealer-helper/functions
 * @version 1.0.0
 */

/**
 * Cardealer Helpert Widget dealer Filters.
 */
class Jws_Helper_Widget_dealer_Filters extends WP_Widget {

    
   function __construct() {
		$args = array(
			'name'        => esc_html__( 'Dealer filter', 'idealauto' ),
			'description' => esc_html__( 'Add dealer filters widget in dealer list page widget area.', 'idealauto' ),
			'classname'   => 'dealer_filters'
		);
		parent::__construct( 'dealer_filters', esc_html__( 'Dealer filter', 'idealauto' ) , $args );

	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) { 
		global $jws_option;

		$widget_id = ! isset( $args['widget_id'] ) ? 1 : $args['widget_id'];
		echo ''.$args['before_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE

		if ( ! empty( $instance['title'] ) ) {
			echo ''.$args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . '' . $args['after_title']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
		}
        $layout  = empty( $instance['layout'] ) ? 'layout1' : $instance['layout'];
    
        if($layout == 'layout1') {
          $olumns = 'col-xl-3 col-lg-3 col-12';  
        }else{
          $olumns = 'col-xl-12 col-lg-12 col-12';   
        }
        
        ?>
        <div class="form-search-dealer widget-dealer-list <?php echo esc_attr($layout); ?>">
         <form action="http://idealauto.jwsuperthemes.com/dealer-list/" method="get">

              <div class="row">
                <div class="<?php echo esc_attr($olumns); ?>">
                    <?php 
                        $taxonomies = get_terms( array(
                            'taxonomy' => 'car_make',
                            'hide_empty' => true,
                        ) );
                         
                        if ( !empty($taxonomies) ) :
                           $selected = ( isset( $_GET['make_dealer'] ) ) ? esc_html( $_GET['make_dealer'] ) : '';
                            $output = '<select class="item-dealer-filters" data-id="make_dealer" name="make_dealer">';
                            $output .= '<option value="" > '.esc_html__( 'Any Make', 'idealauto' ).'</option>';
                            foreach( $taxonomies as $category ) {
                                $active = $selected == $category->term_id
                                        				? 'selected '
                                        				: '';
                                $output.= '<option '.$active.' value="'. esc_attr( $category->term_id ) .'">
                                    '. esc_html( $category->name ) .'</option>';
            
                                }
                                $output.='</select>';
                                echo ''.$output;
                         endif;
                    ?>
                </div>
          
             <div class="<?php echo esc_attr($olumns); ?>">
                 <select class="item-dealer-filters" data-id="dealer_radius" name="dealer_radius">
                    <?php 
                        $distance = $jws_option['dealer_distance'];
                       $selected = ( isset( $_GET['dealer_radius'] ) ) ? esc_html( $_GET['dealer_radius'] ) : '';
				    
                        if(!empty($distance)) {
                            echo '<option value="" > '.esc_html__( 'Distance', 'idealauto' ).'</option>';
                            foreach( $distance  as $distance_item ) {
                            $active = $selected == $distance_item
                                				? 'selected '
                                				: '';
                            echo '<option '.$active.' value="'. esc_attr($distance_item ) .'">
                                '. esc_html( $distance_item ) .' km</option>';
                            }   
                        }  
                    ?>
              </select>
             </div> 
             <div class="<?php echo esc_attr($olumns); ?>">
                  <?php 
                    $address_value = (isset($_GET['address']) && !empty($_GET['address'])) ?  $address_value = $_GET['address'] : '';
                  ?>      
                  <input class="item-dealer-filters" id="pac-input" data-id="address"  type="text"  placeholder="<?php echo esc_attr__('ZIP code, City or State','idealauto'); ?>" name="address" value="<?php echo esc_attr($address_value); ?>">
             </div>    
            <div class="<?php echo esc_attr($olumns); ?>">
                <?php if($layout == 'layout2') {
                    ?>
                        <a href="javascript:void(0)" id="reset-filter-dealer" class="filter-dealer"><?php echo esc_html__('Reset','idealauto'); ?></a>  
                    <?php
                }else{
                     ?>
                        <button id="filter-dealer" class="filter-dealer"><?php echo esc_html__('Search','idealauto'); ?></button>  
                    <?php
                } ?>
                 
            </div>
            <input class="item-dealer-filters dealer-lat" data-id="lat" type="hidden" name="lat" value="<?php echo ''.(isset($_GET['lat']) && !empty($_GET['lat'])) ? $_GET['lat'] : ''; ?>"/>
            <input class="item-dealer-filters dealer-lng" data-id="lng" type="hidden" name="lng" value="<?php echo ''.(isset($_GET['lng']) && !empty($_GET['lng'])) ?  $_GET['lng'] : ''; ?>"/>
        </div>  
              
          </form>
        </div>
        <script>
        ( function( $ ) {
        "use strict";
        jQuery(document).ready(function($){ 
            
            var input = document.getElementById('pac-input');
            if(typeof google !== "undefined") {
            var autocomplete = new google.maps.places.Autocomplete(input);
             google.maps.event.addListener(autocomplete, 'place_changed', function () {
                var place = autocomplete.getPlace();
                var lat = place.geometry.location.lat();
                var lng = place.geometry.location.lng();
                if(typeof lat != "undefined") {
                    $('.dealer-lat').val(lat);
                }
                if(typeof lat != "undefined") {
                    $('.dealer-lng').val(lng);
                }
            });
            }
         });
    
        } )( jQuery );    
        </script>
        <?php

		echo ''.$args['after_widget']; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
		public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		if ( in_array( $new_instance['layout'], array( 'layout1', 'layout2'), true ) ) {
			$instance['layout'] = $new_instance['layout'];
		} else {
			$instance['layout'] = 'layout1';
		}


		return $instance;
	}
	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
	
        
        // Defaults.
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'layout'  => 'layout1',
				'title'   => '',
			
			)
		);
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'idealauto' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
		</p>
        <p>
          <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>"><?php esc_html_e( 'Layout:', 'idealauto' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>" class="widefat">
				<option value="layout1"<?php selected( $instance['layout'], 'layout1' ); ?>><?php esc_html_e( 'layout 1', 'idealauto' ); ?></option>
				<option value="layout2"<?php selected( $instance['layout'], 'layout2' ); ?>><?php esc_html_e( 'layout 2', 'idealauto' ); ?></option>
			</select>
		</p>
        </p>
		<?php
	}
}

if(function_exists('insert_widgets')) {
    insert_widgets( 'Jws_Helper_Widget_dealer_Filters' );
}