<?php
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class My_Garage extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_my_garage';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws My Garage', 'idealauto' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-heart-o';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}

     /**
	 * Retrieve the list of scripts the image carousel widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 0.0.1
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	//public function get_script_depends() {

	//}
    
	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls() {
	   
		$this->start_controls_section(
			'section_setting_content',
			[
				'label' => esc_html__( 'Setting', 'idealauto' ),
			]
		);
        
        $this->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'idealauto' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'fab fa-wordpress',
                		'library' => 'fa-brands',
					],
				]
		);
        $this->add_control(
			'my_garage_text',
			[
				'label' => esc_html__( 'My Garage Text', 'idealauto' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'My garage', 'idealauto' ),
			]
		);
        $this->add_responsive_control(
			'alignment',
			[
				'label' => esc_html__( 'Alignment', 'idealauto' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'idealauto' ),
						'icon' => 'fa fa-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'idealauto' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .my-garage-wrap' => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .my-garage-list' => '{{VALUE}}:0',
				],
			]
		);
		$this->end_controls_section();

	}
    
    protected function list_category() { 
        
        $attribute_array      = array();
    	$std_attribute        = '';
    	$attribute_taxonomies = wc_get_attribute_taxonomies();
    	if ( ! empty( $attribute_taxonomies ) ) {
    		foreach ( $attribute_taxonomies as $tax ) {
    			if ( taxonomy_exists( wc_attribute_taxonomy_name( $tax->attribute_name ) ) ) {
    				$attribute_array[ $tax->attribute_name ] = $tax->attribute_name;
    			}
    		}
    		$std_attribute = current( $attribute_array );
    	}
      
    }

    

	protected function render() {
	    $settings = $this->get_settings();

        ?>
        <div class="my-garage-wrap">
            <a class="my-garage-toggle" href="javascript:void(0)">
                <?php  
                if ( isset($settings['icon']) && !empty($settings['icon']['value']) ) {
					\Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
				}    
                echo esc_html($settings['my_garage_text']); ?>
            </a>
            <div class="my-garage-list">
              <ul class="ct_ul_ol vehicles-added">
                <?php 
                    if (isset($_COOKIE['jws_my_garage'])) { 
                        foreach ($_COOKIE['jws_my_garage'] as $name => $value) {
                
                            $value = htmlspecialchars($value);
                            echo '<li><a href="'.get_permalink( wc_get_page_id( 'shop' ) ).'?garage'.$value.'">'.str_replace('-', ' ', $name).'</a><span class="jws-icon-icon_close-1 remove-garage" data-id="'.$name.'"></span></li>';
                        }         
                   } ?>
              </ul>  
              <a class="add-vehicle-garage" href="javascript:void(0)">
                <?php echo esc_html__('Add Vehicle','idealauto'); ?>
              </a>
              <ul class="ct_ul_ol notes">
                <li><?php echo esc_html__('Store vehicles in your garage','idealauto'); ?></li>
                <li><?php echo esc_html__('Get product recommendations','idealauto'); ?></li>
                <li><?php echo esc_html__('Easily find parts & accessories','idealauto'); ?></li>
              </ul>  
            </div>
            <div class="search-my-vehicles">
                   <div class="overlay"></div>                 
                   <form class="jws-my-garage" method="get">
                        <span class="jws-icon-icon_close-1 close-form-add-garage"></span>
                    	<div class="cdhl-vehicle-filters row">
                			<?php

                                $array = array('make','model','years');
                                foreach($array as $value) {
                        
                                    $terms = get_terms( 'pa_'.$value, array( 'hide_empty' => '1' ) );
                                    $taxonomy_label       = wc_attribute_label( 'pa_'.$value );
                          
                                    
                                        ?>
                                        <div class="col-xl-3"><label><?php echo esc_html__('Select ','idealauto').esc_html($taxonomy_label) ?></label>
                                            <select id="filter_pa_<?php echo esc_attr($value); ?>" data-url="<?php echo 'filter_' . esc_attr( $value ); ?>" data-id="<?php echo 'pa_' . esc_attr( $value ); ?>" class="product-filter-select" tabindex="-1" aria-hidden="true">
                                                <option value="">--<?php echo esc_html__('Any ','idealauto').$taxonomy_label; ?>--</option>
                                                <?php 
                                                	foreach ( $terms as $term ) {

                                        				$count         = isset( $term_counts[ $term->term_id ] ) ? $term_counts[ $term->term_id ] : 0;
                                        
                                        				// Only show options with count > 0.
                                        				if ( 0 < $count ) {
                                        					$found = true;
                                        				} 
                                        
                                        				echo '<option value="' . esc_attr( urldecode( $term->slug ) ) . '">' . esc_html( $term->name ) . '</option>';  
                                                   
                                        			
                                        			}
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <?php  

                                }
                   			
                			?>
                            <div class="col-xl-3"><button class="product-submit-btn" type="submit"><?php echo esc_attr__( 'Add','idealauto' ); ?></button></div>
                          
                		</div>
                        <div class="garage-notes-wap"></div>
                </form>
            </div>
        </div>    
        <?php
	}

	protected function content_template() {}

}