<?php 

$grid_class = 'category-tab-item col-xl-' . $settings['columns'] . ' col-lg-' . $settings['columns_tablet'] . ' col-' . $settings['columns_mobile'] .'';

$filter_arr = array(
    'filter_categories_for_asset' => $settings['filter_categories_for_asset'],    
    'columns' => $grid_class,
);

?>
<div class="idealautoduct-category-tabs" data-args='<?php echo json_encode($filter_arr); ?>'>
<ul class="idealautoduct-cat-filter ct_ul_ol">
    <?php
        if($settings['default_category'] && isset(get_term_by('slug',$settings['default_category'], 'product_cat')->name)){
            echo '<li><a href="'.get_term_link($settings['default_category'], 'product_cat').'" class="ajax-load active" title="'. get_term_by('slug',$settings['default_category'], 'product_cat')->name .'" data-type="product_cat" data-value="'.$settings['default_category'].'" ><span>' . get_term_by('slug',$settings['default_category'], 'product_cat')->name . '</span></a></li>';
        }elseif($settings['default_category'] == 'all') {
            echo '<li><a href="#" class="ajax-load active" data-type="product_cat" title="'. $settings['title'].'" data-value="all" ><span>' . $settings['title'] . '</span></a></li>';
        }
        if($settings['filter_categories']){
            foreach ($settings['filter_categories'] as $product_cat_slug) {
                $product_cat = get_term_by('slug', $product_cat_slug, 'product_cat');
                $selected = '';
                if(isset($product_cat->slug)){
                    if (isset($settings['wc_attr']['product_cat']) && $settings['wc_attr']['product_cat'] == $product_cat->slug) {
                        $selected = 'jws-selected';
                    }
             
                    $ajax_load = ' ajax-load';
                  
                    echo '<li><a href="' . esc_url(get_term_link($product_cat->slug, 'product_cat')) . '"
                    class="' . esc_attr($selected) . $ajax_load . '" 
                    data-type="product_cat" data-value="' . esc_attr($product_cat->slug) . '" 
                    title="' . esc_attr($product_cat->name) . '"><span>' . esc_html($product_cat->name) . '</span></a></li>';
                }
                
            } 
        }
    ?>
</ul>

<div class="category-content row">

<?php
    if(!empty($settings['default_category'])) {
        if($settings['default_category'] == 'all'){
             if($settings['filter_categories_for_asset']){
                foreach ($settings['filter_categories_for_asset'] as $product_cat_slug) {
                    $product_cat = get_term_by('slug', $product_cat_slug, 'product_cat');
                    
                    
                    ?>
                    
                    <div class="<?php echo esc_attr($grid_class); ?>">
                        <a href="<?php echo get_term_link( $product_cat->term_id, 'product_cat' );  ?>">
                            <?php echo wp_get_attachment_image( get_term_meta( $product_cat->term_id, 'thumbnail_id', 1 ), 'full' ); ?>
                            <h4><?php echo esc_html($product_cat->name); ?></h4>
                        </a>
                    </div>
                    
                    <?php
               
                 
                    
                } 
            }     
        }else{
            $term = get_queried_object();
        
            $category = get_term_by( 'slug', $settings['default_category'], 'product_cat' );
        
            $id = $category->term_id;
            
            $children = get_categories(
              array(
                'taxonomy' => 'product_cat',
                'parent' =>$id
              )
            );
        
            if ( $children ) { 
                foreach( $children as $product_cat )
                {
                    ?>
                    
                    <div class="category-tab-item col-xl-20 col-lg-20 col-12">
                        <a href="<?php echo get_term_link( $product_cat->term_id, 'product_cat' );  ?>">
                            <?php echo wp_get_attachment_image( get_term_meta( $product_cat->term_id, 'thumbnail_id', 1 ), 'full' ); ?>
                            <h4><?php echo esc_html($product_cat->name); ?></h4>
                        </a>
                    </div>
                    
                    <?php
                }
            }  
        }
        
    } 
?>
</div> 
</div>