<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Core\Schemes;

/**
 * Elementor icon list widget.
 *
 * Elementor widget that displays a bullet list with any chosen icons and texts.
 *
 * @since 1.0.0
 */
class Car_single_Images extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve icon list widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'car_single_images';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon list widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Car Image Detail', 'idealauto' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon list widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-bullet-list';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return ['car', 'images' ];
	}

	/**
	 * Register icon list widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_car_imnages',
			[
				'label' => esc_html__( 'Setting', 'idealauto' ),
			]
		);
        $this->end_controls_section();
	}

	/**
	 * Render icon list widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        <div class="single-inventory layout1">
            <?php $layout = (isset($_GET['car_layout']) && $_GET['car_layout'] == 'layout2') ? $_GET['car_layout'] : 'layout1'; $car_id = get_the_ID();
            
            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                $args = array( 'post_type' => 'cars');
                $loop =  new \WP_Query( $args );
                while ( $loop->have_posts() ) : $loop->the_post();
                  $car_id = get_the_ID();
                endwhile;
            } 
             
if($layout == 'layout1') { ?>
    <div class="car-single-images">
        
        <div class="images-wap">
        <?php  jws_inventory_label(); ?>
            <?php
                
                    $video_link = get_post_meta( $car_id , 'video_link',  true );
                    echo (!empty($video_link)) ? '<div class="car-video-popup-wap"><a href="'.esc_url($video_link).'" class="car-video-popup"> <i class="jws-icon-play"></i>'.esc_html__('Watch video','idealauto').'</a></div>' : '';
                
            ?>
            <div class="jws-car-favorite" data-id="<?php echo get_the_ID(); ?>" data-toggle="tooltip" data-original-title="<?php echo esc_attr__('Add to favorites','idealauto'); ?>">
    			<i class="jws-icon-icon_heart_alt"></i>
    		</div>
            <div class="images-slider">
                <?php
                    
            			$car_images = get_post_meta( $car_id , 'car_images', true );
   
            			$url        = array();
            			if ( ! empty( $car_images ) ) {
            				foreach ( $car_images as $car_image ) {
                                $img = jws_getImageBySize(array('attach_id' => $car_image, 'thumb_size' => 'jws-car-single-size', 'class' => 'attachment-large wp-post-image'));
                                $imagefull = wp_get_attachment_image_src($car_image, 'full');
                                echo '<div class="slider-item slick-slide" data-src="'.$imagefull[0].'">'.$img['thumbnail'].'</div>';
            				}
            			}
            	
                ?>
            </div>
        </div>
        <div class="thumbnail-slider">
            <?php
               
        			$car_images = get_post_meta( $car_id , 'car_images',  true );
        			$url        = array();
        			if ( ! empty( $car_images ) ) {
        				foreach ( $car_images as $car_image ) {
                            $img = jws_getImageBySize(array('attach_id' => $car_image, 'thumb_size' => 'jws-car-single-size', 'class' => 'attachment-large wp-post-image'));
                            echo '<div class="slider-item slick-slide">'.$img['thumbnail'].'</div>';
        				}
        			}
        	
            ?>
        </div>
    </div>
<?php } else { ?>
     <div class="car-single-images">
        <div class="images-wap">
            <?php
               
                    $video_link = get_post_meta( $car_id , 'video_link',  true );
                    echo (!empty($video_link)) ? '<div class="car-video-popup-wap"><a href="'.esc_url($video_link).'" class="car-video-popup"> <i class="jws-icon-play"></i>'.esc_html__('Watch video','idealauto').'</a></div>' : '';
               
            ?>
            <div class="jws-car-favorite" data-id="<?php echo get_the_ID(); ?>" data-toggle="tooltip" data-original-title="<?php echo esc_attr__('Add to favorites','idealauto'); ?>">
    			<i class="jws-icon-icon_heart_alt"></i>
    		</div>
            <div class="images-slider" data-slick='{"slidesToShow":3 ,"slidesToScroll": 1, "infinite" : false, "responsive":[{"breakpoint": 1024,"settings":{"slidesToShow": 2}},{"breakpoint": 767,"settings":{"slidesToShow": 2}},{"breakpoint": 530,"settings":{"slidesToShow": 1}}]}'>
                <?php
                    
            			$car_images = get_post_meta( $car_id , 'car_images',  true );
            			$url        = array();
            			if ( ! empty( $car_images ) ) {
            				foreach ( $car_images as $car_image ) {
                                $img = jws_getImageBySize(array('attach_id' => $car_image, 'thumb_size' => 'jws-car-single-size2', 'class' => 'attachment-large wp-post-image'));
                                $imagefull = wp_get_attachment_image_src($car_image, 'full');
                                echo '<div class="slider-item col-xl-4 col-lg-6 col-12 slick-slide" data-src="'.$imagefull[0].'">'.$img['thumbnail'].'</div>';
            				}
            			}
            		
                ?>
            </div>
        </div>
    </div>
<?php } ?> </div> <?php

	}

	/**
	 * Render icon list widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {

	}

}
