<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_car_search extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_car_search';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Car Search', 'idealauto' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-site-search';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_search_setting',
			[
				'label' => esc_html__( 'Toggle', 'idealauto' ),
			]
		);
        $this->add_control(
			'layouts',
			[
				'label'     => esc_html__( 'Layout', 'idealauto' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'layout1',
				'options'   => [
					'layout1'   => esc_html__( 'Layout 1', 'idealauto' ),
					'layout2'   => esc_html__( 'Layout 2', 'idealauto' ),
				],
                
			]
		);
        $this->add_control(
				'category_filter',
				[
					'label'     => esc_html__( 'Select Categories', 'idealauto' ),
					'type'      => Controls_Manager::SELECT2,
					'multiple'  => true,
					'default'   => '',
					'options'   => $this->jws_get_cars_taxonomy(),
				]
		);
		$this->end_controls_section();
  
		$this->start_controls_section(
			'toggle_style',
			[
				'label' => esc_html__( 'Toggle Style', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
				'align',
				[
					'label' 		=> esc_html__( 'Align', 'idealauto' ),
					'type' 			=> Controls_Manager::CHOOSE,
					'default' 		=> 'left',
					'options' 		=> [
						'left'    		=> [
							'title' 	=> esc_html__( 'Left', 'idealauto' ),
							'icon' 		=> 'eicon-h-align-left',
						],
						'center' 		=> [
							'title' 	=> esc_html__( 'Center', 'idealauto' ),
							'icon' 		=> 'eicon-h-align-center',
						],
						'right' 		=> [
							'title' 	=> esc_html__( 'Right', 'idealauto' ),
							'icon' 		=> 'eicon-h-align-right',
						],
					],
                    'selectors' => [
							'{{WRAPPER}} .jws_search > button' => 'text-align: {{VALUE}};',
					],
					'frontend_available' => true,
				]
		);
         $this->add_control(
					'icon_color',
					[
						'label' 	=> esc_html__( 'Icon Color', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} .jws_search > button' => 'color: {{VALUE}};',
						],
					]
		);

        $this->add_control(
				'icon_size',
				[
					'label' 		=> esc_html__( 'Icon Size', 'idealauto' ),
					'type' 			=> Controls_Manager::SLIDER,
					'range' 		=> [
						'px' 		=> [
							'min' => 1,
							'max' => 100,
							'step' => 1,
						],
					],
					'selectors' 	=> [
						'{{WRAPPER}} .jws_search > button' => 'font-size: {{SIZE}}px;',
					],
				]
		);
        $this->end_controls_section();
        $this->start_controls_section(
			'popup_style',
			[
				'label' => esc_html__( 'Popup Style', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background Overlay', 'idealauto' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .jws_search_overlay',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'form_style',
			[
				'label' => esc_html__( 'Form Style', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
       $this->add_control(
					'form_background',
					[
						'label' 	=> esc_html__( 'Background', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form' => 'background: {{VALUE}};',
						],
					]
		);
         $this->add_responsive_control(
					'form_radius',
					[
						'label' 		=> esc_html__( 'Border Radius', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'form_border',
				'label' => esc_html__( 'Border', 'idealauto' ),
				'selector' => '{{WRAPPER}} form.search-form',
			]
		);
         $this->add_responsive_control(
					'form_padding',
					[
						'label' 		=> esc_html__( 'Padding', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
        $this->add_responsive_control(
			'form_height',
			[
				'label'     => esc_html__( 'Min Height', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} form.search-form' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__( 'Button Style', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'label' => esc_html__( 'Typography', 'idealauto' ),
				'selector' => '{{WRAPPER}} form.search-form button',
			]
		);
        $this->add_control(
					'button_color',
					[
						'label' 	=> esc_html__( 'Color', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form button' => 'color: {{VALUE}};',
						],
					]
		);
        $this->add_control(
					'button_color_hover',
					[
						'label' 	=> esc_html__( 'Color Hover', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form button:hover' => 'color: {{VALUE}};',
						],
					]
		);
       $this->add_control(
					'button_background',
					[
						'label' 	=> esc_html__( 'Background', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form button' => 'background: {{VALUE}};',
						],
					]
		);
        $this->add_control(
					'button_background_hover',
					[
						'label' 	=> esc_html__( 'Background Hover', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form button:hover' => 'background: {{VALUE}};',
						],
					]
		);
         $this->add_responsive_control(
					'button_radius',
					[
						'label' 		=> esc_html__( 'Border Radius', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
         $this->add_responsive_control(
					'button_padding',
					[
						'label' 		=> esc_html__( 'Padding', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
        $this->add_responsive_control(
			'button_width',
			[
				'label'     => esc_html__( 'Min Width', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} form.search-form button' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'input_style',
			[
				'label' => esc_html__( 'Input Style', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'input_typography',
				'label' => esc_html__( 'Typography', 'idealauto' ),
				'selector' => '{{WRAPPER}} form.search-form input',
			]
		);
        $this->add_control(
					'input_color',
					[
						'label' 	=> esc_html__( 'Color', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form input , {{WRAPPER}} form.search-form input::placeholder' => 'color: {{VALUE}};',
						],
					]
		);
       $this->add_control(
					'input_background',
					[
						'label' 	=> esc_html__( 'Background', 'idealauto' ),
						'type' 		=> Controls_Manager::COLOR,
						'default' 	=> '',
						'selectors' => [
							'{{WRAPPER}} form.search-form input' => 'background: {{VALUE}};',
						],
					]
		);
         $this->add_responsive_control(
					'input_radius',
					[
						'label' 		=> esc_html__( 'Border Radius', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
         $this->add_responsive_control(
					'input_padding',
					[
						'label' 		=> esc_html__( 'Padding', 'idealauto' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', 'em', '%' ],
						'selectors' 	=> [
							'{{WRAPPER}} form.search-form input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],

						'separator' => 'before',
					]
		);
        
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $this->add_render_attribute( [
			'search-wrapper' => [
				'class' => 'jws-cars-search row',
                'data-empty-lbl' => esc_html__( '--Select--', 'idealauto' ),
			],
		] );
     
   
	if ( empty( $settings['category_filter']  ) ) {
		return;
	}
	$carsfilters = $settings['category_filter'];
    $uid = uniqid();
	ob_start();
    $step = 100;
	?>
	<div <?php echo ''.$this->get_render_attribute_string( 'search-wrapper' ); ?>>
    <div class="col-xl-8 col-lg-12 col-12">
			<div class="row sort-filters-box">
				<?php
		
				$t = 0;
				$j = 1;
				foreach ( $carsfilters as $filters ) :
          
					$tax_terms     = $this->jws_get_terms( array( 'taxonomy' => $filters ) );
                 
					$taxonomy_name = get_taxonomy( $filters );
                    if(!$taxonomy_name) return false;
					$label         = $taxonomy_name->labels->menu_name;
					?>
					<div class="col-xl-4 col-lg-4 col-12">
						<span class="car-label"><?php esc_html_e( 'Select', 'idealauto' ); ?> <?php echo esc_html( $label ); ?></span>
						<div class="selected-box">
							<select data-tax="<?php echo '--'.esc_html__('Any ','idealauto').esc_html( $label ) . '--'; ?>" data-uid="<?php echo esc_attr( $uid ); ?>" id="sort_<?php echo esc_attr( $filters ); ?>" data-id="<?php echo esc_attr( $filters ); ?>" class="custom-filters-box">
								<option value="">--<?php echo esc_html__( 'Any ', 'idealauto' ).esc_html($label); ?>--</option>
								<?php
								foreach ( $tax_terms as $key => $term ) :
									if ( 'car_mileage' === (string) $taxonomy_name->name ) {
										$mileage_array = jws_get_mileage_array();
										if ( 1 === (int) $j ) {
											foreach ( $mileage_array as $mileage ) {
												?>
												<option value="<?php echo esc_attr( $mileage ); ?>">&lt; <?php echo esc_html( $mileage ); ?></option>
												<?php
											}
										}
										$j++;
									} else {
										?>
										<option value="<?php echo esc_attr( $term ); ?>"><?php echo esc_html( $key ); ?></option>
										<?php
									}
								endforeach;
								?>
							</select>
						</div>
					</div>
					<?php
					$t++;
				endforeach;
				?>
			</div>
		</div>
		<div class="col-lg-4 col-md-4 col-sm-4">
			<?php
			// Find min and max price in current result set.
            $prices        = ( function_exists( 'jws_get_car_filtered_price' ) ) ? jws_get_car_filtered_price() : '';
    
			$min           = floor( $prices->min_price );
			$max           = ceil( $prices->max_price );
		
			$pgs_min_price = isset( $_GET['min_price'] ) ? esc_attr( $_GET['min_price'] ) : $min;
			$pgs_max_price = isset( $_GET['max_price'] ) ? esc_attr( $_GET['max_price'] ) : $max;
		      ?>
			<div class="price_slider_wrapper">                		
				<div class="price-slide">
					<div class="price">
						<?php if ( $min > 0 || $max > 0 ) { ?>
						<input type="hidden" id="pgs_min_price" name="min_price" value="<?php echo esc_attr( $pgs_min_price ); ?>" data-min="<?php echo esc_attr( $min ); ?>"/>
						<input type="hidden" id="pgs_max_price" name="max_price" value="<?php echo esc_attr( $pgs_max_price ); ?>" data-max="<?php echo esc_attr( $max ); ?>" data-step="<?php echo esc_attr( $step ); ?>"/>

						<label for="dealer-slider-amount"><?php echo esc_html__( 'Price Range', 'idealauto' ); ?></label>
						<input type="text" id="dealer-slider-amount" readonly class="amount" value="" />
						<div id="slider-range" data-cfb="yes"></div>
						<?php } ?>								
						<a class="button cfb-submit-btn" href="javascript:void(0);"><?php echo esc_html__( 'Search Inventory','idealauto' ); ?></a>
					</div>
				</div>
			</div>

		</div>		

		<div class="filter-loader"></div>
	</div>
		<?php


	 }
     
     
     /**
     * Get terms.
     *
     * @param array $args .
     * @param array $args2 .
     */
   protected function jws_get_terms( $args = array(), $args2 = '' ) {
    	$return_data = array();
    
    	if ( ! empty( $args2 ) ) {
    		$result = get_terms( $args, $args2 );
    	} else {
    		$args['hide_empty'] = true;
    		$result             = get_terms( $args );
    	}
    
    	if ( is_wp_error( $result ) ) {
    		return $return_data;
    	}
    
    	if ( ! is_array( $result ) || empty( $result ) ) {
    		return $return_data;
    	}
    
    	foreach ( $result as $term_data ) {
    		if ( is_object( $term_data ) && isset( $term_data->name, $term_data->term_id ) ) {
    			$return_data[ $term_data->name ] = $term_data->slug;
    		}
    	}
    	return $return_data;
    }
    
    protected  function jws_get_cars_taxonomy() {
    	$taxonomies = get_object_taxonomies( 'cars' );
    
    	$vehicle_cat_key = array_search( 'vehicle_cat', $taxonomies, true );
    	if ( false !== $vehicle_cat_key ) {
    		unset( $taxonomies[ $vehicle_cat_key ] );
    	}
    
    	$car_features_options_key = array_search( 'car_features_options', $taxonomies, true );
    	if ( false !== $car_features_options_key ) {
    		unset( $taxonomies[ $car_features_options_key ] );
    	}
    
    	$car_vehicle_review_stamps_key = array_search( 'car_vehicle_review_stamps', $taxonomies, true );
    	if ( false !== $car_vehicle_review_stamps_key ) {
    		unset( $taxonomies[ $car_vehicle_review_stamps_key ] );
    	}
    	$taxonomy_array = array();
    	foreach ( $taxonomies as $taxonomy ) {
    		$tax_obj                           = get_taxonomy( $taxonomy );
    		 $taxonomy_array[ $tax_obj->name ] = $taxonomy;
    	}
    	return $taxonomy_array;
    }



	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}