<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_Car_Body extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_car_body';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws Car Body', 'idealauto' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-flow';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}
 

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
	    $this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'idealauto' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


        $this->add_responsive_control(
				'car_body_columns',
				[
					'label'          => esc_html__( 'Columns', 'idealauto' ),
					'type'           => Controls_Manager::SELECT,
					'default'        => '12',
					'options'        => [
						'12' => '1',
						'6' => '2',
						'4' => '3',
						'3' => '4',
						'20' => '5',
						'2' => '6',
					],
				]
		);
        
         $this->add_responsive_control(
			'height',
			[
				'label' => __( 'Min Height', 'idealauto' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .car-body' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();   
	    $this->start_controls_section(
			'setting_section_list',
			[
				'label' => esc_html__( 'car_body List', 'idealauto' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);   
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'idealauto' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
				'text1',
				[
					'label'     => esc_html__( 'Text 1', 'idealauto' ),
					'type'      => Controls_Manager::TEXT,
					'default'   => 'text 1',
				]
		);

        $repeater->add_control(
			'link_url',
			[
				'label' => esc_html__( 'Link', 'idealauto' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'idealauto' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
				],
			]
		);
        
         $repeater->add_responsive_control(
            'max-width', [
                'label' => esc_html__('Image Max Width', 'idealauto'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%','px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],

                'selectors' => [
                    "{{WRAPPER}} {{CURRENT_ITEM}} img" => 'max-width: {{SIZE}}{{UNIT}}',
                ],

            ]
        );
        
        
        $this->add_control(
			'list',
			[
				'label' => esc_html__( 'Menu List', 'idealauto' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'text1' => esc_html__( 'Name #1', 'idealauto' ),
					],
				],
				'title_field' => '{{{ text1 }}}',
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-car-body-item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .row' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .jws-car-body-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
  
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
	   
		$settings = $this->get_settings_for_display();
      
        $image_size = (!empty($settings['car_body_dimension']['width']) || !empty($settings['car_body_dimension']['height'])) ? $settings['car_body_dimension']['width'].'x'.$settings['car_body_dimension']['height'] : 'full';
        
          $class_column = 'jws-car-body-item';
          $class_column .= ' col-xl-'.$settings['car_body_columns'].'';
          $class_column .= (!empty($settings['car_body_columns_tablet'])) ? ' col-lg-'.$settings['car_body_columns_tablet'].'' : ' col-lg-'.$settings['car_body_columns'].'' ;
          $class_column .= (!empty($settings['car_body_columns_mobile'])) ? ' col-'.$settings['car_body_columns_mobile'].'' :  ' col-'.$settings['car_body_columns'].''; 
          $class_row = 'row'; 
         

          

         ?>
         <div class="jws-car-body-element">
            <div class="<?php echo esc_attr($class_row); ?>">
                <?php $i = 1; $n = 0; foreach (  $settings['list'] as $index => $item ) {
                   $link_key = 'link' . $index;   
                   if($item['link_url']['is_external']) $this->add_render_attribute( $link_key, 'rel',  'nofollow' );
                   if($item['link_url']['nofollow']) $this->add_render_attribute( $link_key, 'target',  '_blank' );  
                   $this->add_render_attribute( $link_key, 'href',  $item['link_url']['url'] ); 
                  
                    ?>
                     <div class="<?php echo esc_attr($class_column).' elementor-repeater-item-'.esc_attr($item['_id']); ?>">
                        
                        <div class="car-body">
                            <a <?php echo ''.$this->get_render_attribute_string($link_key); ?>>
                                <?php
                                        if (function_exists('jws_getImageBySize')) {
                                             $attach_id = $item['image']['id'];
                                             $img = jws_getImageBySize(array('attach_id' => $attach_id, 'thumb_size' => 'full' , 'class' => 'image-car-body'));
                                             echo (!empty($img['thumbnail'])) ? ''.$img['thumbnail'] : '';
                                    
                                      }
                                 ?>
                                <h4><?php echo esc_html($item['text1']); ?></h4>
                            </a>
                        </div>
                        
                    </div>
                <?php $n++; } ?>
            </div>
         </div>   
        <?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}