<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_Car_add_car extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_car_add_car';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws add car', 'idealauto' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-plus';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}
 

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

	    $this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'idealauto' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_control(
			'layouts',
			[
				'label'     => esc_html__( 'Layout', 'idealauto' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => [
					'default'   => esc_html__( 'Default', 'idealauto' ),
					'no-text'   => esc_html__( 'No Text', 'idealauto' ),
				],
                
			]
		);
  
        $this->end_controls_section();
   
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
	    global $jws_option;    
		$settings = $this->get_settings_for_display();
        
        $this->add_render_attribute( 'main_add_car', 'class', 'car-add_car-action' );
        $this->add_render_attribute( 'main_add_car', 'class', $settings['layouts'] ); 
        
        ?>

        <div <?php echo ''.$this->get_render_attribute_string( 'main_add_car' ); ?>>
            <a href="<?php if(isset($jws_option['select-page-submit']) && !empty($jws_option['select-page-submit'])) echo get_page_link($jws_option['select-page-submit']); ?>">
                <span class="car-add-icon">
                    <span class="jws-icon-car"></span>
                    <span class="jws-icon-plus-circle"></span>
                </span>
                <span class="car-add-text"><?php echo esc_html__('Add your item','idealauto'); ?></span>
            </a>
        </div>

        <?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}