<?php
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Jws_Car_Account extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'jws_car_account';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Jws car account', 'idealauto' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-user-circle-o';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'jws-elements' ];
	}
 

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
	   
   
       
	    $this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'idealauto' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Font Custom', 'idealauto' ),
                'name'          => 'account_ty',
                'selector'      => '{{WRAPPER}} .car-account-action > a',
            ]
        );
        $this->add_control(
			'ac_link',
			[
				'label' => esc_html__( 'Link', 'idealauto' ),
				'type' => Controls_Manager::URL,
				'placeholder' => esc_html__( 'Login / Register Url', 'idealauto' ),
                'dynamic'		=> [ 'active' => true ],
		
			]
		);
        $this->end_controls_section();

        
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
	    global $jws_option;    
		$settings = $this->get_settings_for_display();
        $url = $settings['ac_link']['url'];
        $target = $settings['ac_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['ac_link']['nofollow'] ? ' rel="nofollow"' : '';  
        
        ?>
            <div class="car-account-action">
                    <?php 
                        if(is_user_logged_in()): 
                        $user = wp_get_current_user();
                        if ( !is_wp_error( $user ) ) {
                        $link = get_author_posts_url( $user->data->ID );
                        } else {
                            $link = '';
                        }
                        $my_offers = 0;
                        $user_cars = (function_exists('jws_user_listings_query')) ? jws_user_listings_query($user->data->ID, "any", -1, false, 0,false, true) : null;
                		if($user_cars != null && !empty($user_cars->post_count)) {
                			$my_offers = $user_cars->post_count;
                		}
                        $my_fav = get_the_author_meta('jws_user_favourites', $user->ID);

                		if(!empty($my_fav)) {
                			$my_fav = count(array_filter(explode(',', $my_fav)));
                		} else {
                			$my_fav = 0;
                		}
                        $jws_user_avatar = get_user_meta( $user->ID, 'dealer-avatar', true );
                       
                    ?>
                    <a href="javascript:void(0)">
                        <?php 
                            if ( isset( $jws_user_avatar ) && ! empty( $jws_user_avatar ) ) {
                			     $img = jws_getImageBySize(array('attach_id' => $jws_user_avatar, 'thumb_size' => 'thumbnail', 'class' => 'dealer-image'));
                                 echo ''.$img['thumbnail'];
                			} else {
                			     echo '<img class="dealer-image " src="'.get_template_directory_uri() . '/assets/image/image-default.png" width="80" height="80" alt="car-image-default" title="car-image-default">';
                			}
                        ?>
                    </a>
                    <div class="account-menu-dropdown">
                        <ul class="account-list ct_ul_ol">
                      
                            <li class="account-setting">
                        		<div class="name">
                        			<a href="<?php echo esc_url($link); ?>"><i class="jws-icon-003-user"></i><span><?php echo esc_attr(jws_display_user_name($user->ID)); ?></span></a>
                        		</div>
                                <a href="<?php echo esc_attr($link.'edit-profile'); ?>" class="settings">
        			                 <span class="jws-icon-002-settings"></span>
                        		</a>
                    		</li>
                			<li>
                                <a class="hover" href="<?php echo esc_url($link); ?>"><i class="jws-icon-004-car"></i><?php esc_html_e('My items', 'idealauto'); ?> (<span><?php echo esc_attr($my_offers); ?></span>)</a>
                            </li>
                			<li class="jws-my-favourites">
                                <a class="hover" href="<?php echo esc_attr($link.'favorites'); ?>"><i class="jws-icon-icon_heart_alt"></i><?php esc_html_e('Favorites', 'idealauto'); ?> (<span><?php echo esc_attr($my_fav); ?></span>)</a>
                            </li>
                		    <li>
                                <a class="hover" href="<?php echo esc_url(wp_logout_url(home_url())); ?>" class="logout">
                        			<i class="jws-icon-logout"></i><?php esc_html_e('Logout', 'idealauto'); ?>
                        		</a>
                            </li>  
                        </ul>
                	
                    </div>
                <?php else : ?>
                    <a href="javascript:void(0)">
                        <i class="jws-icon-user"></i>
                    </a>
                    <div class="account-menu-dropdown">
                        <ul class="account-list no-user ct_ul_ol">
                            <li>
                                <a class="hover_2" href="<?php echo esc_url($url); ?>" <?php echo esc_attr($target.$nofollow); ?>><?php esc_html_e('Login', 'idealauto'); ?></a>
                            </li>
                            <li>
                                <a class="hover_2" href="<?php echo esc_url(add_query_arg(array('signup'=> 'true'), $url)); ?>" <?php echo esc_attr($target.$nofollow); ?>><?php esc_html_e('Sign Up', 'idealauto'); ?></a>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>
           
        </div>
        <?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function content_template() {}
}