<?php
/**
 * View template for Clever Product Advanced.
 *
 * @package jws\Templates
 * @copyright 2018 CleverSoft. All rights reserved.
 */

$product_ex_ids = $product_inc_ids = $default_asset = $filter_arr = $jws_json_config = '';
if($settings['product_ex_ids'] && is_array($settings['product_ex_ids'])){
    $product_ex_ids = $settings['product_ex_ids'];
}
if($settings['product_inc_ids'] && is_array($settings['product_inc_ids'])){
    $product_inc_ids = $settings['product_inc_ids'];
}
if ( is_front_page() ) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;   
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1; 
}


$wc_attr = array(
    'post_type'         => 'cars',
    'posts_per_page'    => $settings['posts_per_page'],
    'paged'             => $paged,
    'orderby'           => $settings['orderby'],
    'order'             => $settings['order'],
    'post_status'       => 'publish'
);

if(!empty($product_ex_ids)) {
  $wc_attr['post__not_in'] = $product_ex_ids;   
}

if(!empty($product_inc_ids)) {
  $wc_attr['post__in'] = $product_inc_ids; 
}



$wc_attr['car_cat']=array();
$wc_attr['car_condition']=array();
if($settings['tabs_filter'] == 'cate'){
    if($settings['default_category'] != '' && $settings['default_category'] != 'all'){
        $wc_attr['car_cat'] = $settings['default_category'];
    }
    else{
        if($settings['filter_categories']){
            $wc_attr['car_cat'] = implode(',', $settings['filter_categories']);
        }
    }

}elseif($settings['tabs_filter'] == 'condi'){
    if($settings['default_condition'] != '' && $settings['default_condition'] != 'all'){
        $wc_attr['car_condition'] = $settings['default_condition'];
    }
    else{
        if($settings['filter_conditions']){
            $wc_attr['car_condition'] = implode(',', $settings['filter_conditions']);
        }
    }
    if($settings['filter_categories_for_condi'] != '' && $settings['filter_categories_for_condi'] != 'all'){
        $wc_attr['car_cat'] = implode(',', $settings['filter_categories_for_condi']);
    }  
}

$asset = $settings['asset'];
if($asset != 'none') {
	$wc_attr['meta_query'][] = array(
		'key'     => 'car_asset_type',
		'value'   => $settings['asset'],
		'compare' => 'LIKE',
	);
}



$settings['wc_attr'] = $wc_attr; 

$jws_wrap_class         = "jws-car-wrap append-class jws-wrap";
$jws_json_config = '';
$settings['columns_tablet'] = isset($settings['columns_tablet']) && !empty($settings['columns_tablet']) ? $settings['columns_tablet'] : $settings['columns'];
$settings['columns_mobile'] = isset($settings['columns_mobile']) && !empty($settings['columns_mobile']) ? $settings['columns_mobile'] : $settings['columns'];
    
if($settings['layout'] == 'grid'){
   $class                  = 'grid-layout row';
   $grid_class = 'car-item '.$settings['display'].' col-xl-' . $settings['columns'] . ' col-lg-' . $settings['columns_tablet'] . ' col-' . $settings['columns_mobile'] .'';
}else {
    $grid_class = 'car-item slick-slide '.$settings['display'].'';
}
if($settings['layout'] == 'carousel'){
    
    $settings['slides_to_show_tablet'] = isset($settings['slides_to_show_tablet']) ? $settings['slides_to_show_tablet'] : $settings['slides_to_show'];
    $settings['slides_to_show_mobile'] = isset($settings['slides_to_show_mobile']) ? $settings['slides_to_show_mobile'] : $settings['slides_to_show'];
    
    $class                  = 'slider-layout carousel';
    $jws_wrap_class        .= ' ' . $settings['nav_position'];
    $jws_wrap_class        .= ' jws-car-carousel';
    $jws_wrap_class .= '  jws-grid-lg-' . $settings['slides_to_show']['size'] . '-cols jws-grid-md-' . $settings['slides_to_show_tablet']['size'] . '-cols jws-grid-' . $settings['slides_to_show_mobile']['size'] . '-cols';

    $settings['autoplay'] ? $settings['autoplay'] : $settings['autoplay'] = 'false';
   
    $settings['show_pag'] ? $settings['show_pag'] : $settings['show_pag'] = 'false';
    
    $settings['show_nav'] ? $settings['show_nav'] : $settings['show_nav'] = 'false';
    $settings['speed']?$settings['speed']:$settings['speed']=3000;

    $jws_json_config = '{
        "slides_to_show" : ' . $settings['slides_to_show']['size'] . ',
        "slides_to_show_tablet" : ' . $settings['slides_to_show_tablet']['size'] . ',
        "slides_to_show_mobile" : ' . $settings['slides_to_show_mobile']['size'] . ',

        "speed": ' . $settings['speed'] . ',
        "scroll": ' . $settings['scroll'] . ',

        "autoplay": ' . $settings['autoplay'] . ',
        
        "show_pag": ' . $settings['show_pag'] . ',
        
        "show_nav": ' . $settings['show_nav'] . ',
        "wrap": "div.car-wap"
    }';
}
$filter_arr = array(
    'product_ex_ids'           => $settings['product_ex_ids'],
    'product_inc_ids'           => $settings['product_inc_ids'],
    'orderby'               => $settings['orderby'],
    'order'                 => $settings['order'],
    'posts_per_page'        => $settings['posts_per_page'],
    'filter_categories'     => $wc_attr['car_cat'],
    'filter_conditions'     => $wc_attr['car_condition'],
    'display' => $settings['display'],
    'layout' => $settings['layout'],
    'columns' => $settings['columns'],
    'columns_tablet' => $settings['columns_tablet'],
    'columns_mobile' => $settings['columns_mobile']
);

$product_query = new WP_Query($settings['wc_attr']);

?>
<div class="<?php echo esc_attr($jws_wrap_class) ?> " 
    data-args='<?php echo json_encode($filter_arr); ?>'
    data-url="<?php echo esc_url(admin_url('admin-ajax.php')); ?>"
    data-jws-config='<?php echo esc_attr($jws_json_config) ?>'>

    <div class="jws-head-filter has-tabs">

        <?php if($settings['tabs_filter'] == 'cate') { ?>
            <ul class="jws-ajax-load filter-cate ct_ul_ol">
                <?php
                
                if($settings['default_category'] && isset(get_term_by('slug',$settings['default_category'], 'car_cat')->name)){
                    echo '<li><a href="'.get_term_link($settings['default_category'], 'car_cat').'" class="ajax-load active" data-type="car_cat" data-value="'.$settings['default_category'].'" >' . get_term_by('slug',$settings['default_category'], 'car_cat')->name . '</a></li>';
                }
                if($settings['filter_categories']){
                    foreach ($settings['filter_categories'] as $car_cat_slug) {
                        $car_cat = get_term_by('slug', $car_cat_slug, 'car_cat');
                        $selected = '';
                        if(isset($car_cat->slug)){
                            if (isset($settings['wc_attr']['car_cat']) && $settings['wc_attr']['car_cat'] == $car_cat->slug) {
                                $selected = 'jws-selected';
                            }
                            $ajax_load = 'redirect';
                            if($settings['ajax_load']=='yes'){
                                $ajax_load = ' ajax-load';
                            }
                            echo '<li><a href="' . esc_url(get_term_link($car_cat->slug, 'car_cat')) . '"
                            class="' . esc_attr($selected) . $ajax_load . '" 
                            data-type="car_cat" data-value="' . esc_attr($car_cat->slug) . '" 
                            title="' . esc_attr($car_cat->name) . '">' . esc_html($car_cat->name) . '</a></li>';
                        }
                        
                    } 
                }
                ?>
            </ul>
        <?php } ?>
        <?php if($settings['tabs_filter'] == 'condi') { ?>
             <ul class="jws-ajax-load filter-condition ct_ul_ol">
                <?php
                if($settings['default_condition'] && $settings['default_condition'] == 'all'){
                    echo '<li><a href="#" class="ajax-load active" data-type="car_condition" data-value="" >'.esc_html__('All','idealauto').'</a></li>';
                }
                if($settings['default_condition'] && isset(get_term_by('slug',$settings['default_condition'], 'car_condition')->name)){
                    echo '<li><a href="'.get_term_link($settings['default_condition'], 'car_condition').'" class="ajax-load active" data-type="car_condition" data-value="'.$settings['default_condition'].'" >' . get_term_by('slug',$settings['default_condition'], 'car_condition')->name . '</a></li>';
                }
                if($settings['filter_conditions']){
                    foreach ($settings['filter_conditions'] as $condition_slug) {
                        $condition = get_term_by('slug', $condition_slug, 'car_condition');
                        $selected = '';
                        if(isset($condition->slug)){
                            if (isset($settings['wc_attr']['car_condition']) && $settings['wc_attr']['car_condition'] == $condition->slug) {
                                $selected = 'jws-selected';
                            }
                            $ajax_load = 'redirect';
                            if($settings['ajax_load']=='yes'){
                                $ajax_load = ' ajax-load';
                            }
                            echo '<li><a href="' . esc_url(get_term_link($condition->slug, 'car_condition')) . '"
                            class="' . esc_attr($selected) . $ajax_load . '" 
                            data-type="car_condition" data-value="' . esc_attr($condition->slug) . '" 
                            title="' . esc_attr($condition->name) . '">' . esc_html($condition->name) . '</a></li>';
                        }
                        
                    } 
                }
                ?>
            </ul>
        <?php } ?>
</div>
<div class="car-wap <?php echo esc_attr($class) ?>">

    <?php 
        while ($product_query->have_posts()) : $product_query->the_post();
             echo '<div class="'.esc_attr($grid_class).'">';    
             get_template_part( 'template-parts/content/cars/'.$settings['display'].'' );
             echo '</div>';
        endwhile;
    ?>

</div>
<?php if($settings['pagination'] != 'none' && $settings['tabs_filter'] == 'none' && $settings['layout'] == 'grid') : ?>
  <?php
  $zoo_pag_type = $settings['pagination'];
  ?>
  <?php if($zoo_pag_type == 'ajaxload' || $zoo_pag_type == 'infinity'):
        wp_enqueue_script('infinite-scroll');
  ?>
    <div class="pagination-ajax">
    <?php endif; ?>
    <?php
    //jws_pagination(3, $product_query, '', '<i class="zoo-icon-long-arrow-left"></i> ' . esc_html__('', 'idealauto'), esc_html__('', 'idealauto') . ' <i class="zoo-icon-long-arrow-right"></i>');
    ?>
    <?php if($zoo_pag_type == 'ajaxload' || $zoo_pag_type == 'infinity') : ?>

        <div class="scroller-status">
            <div class="infinite-scroll-request">
                <div class="pagination-loading"><span class="loading"><?php echo esc_html__('LOADING...','idealauto') ?></span></div>
            </div>
            <p class="infinite-scroll-last"><?php echo esc_html__('All items loaded','idealauto'); ?></p>
            <p class="infinite-scroll-error"><?php echo esc_html__('No more page','idealauto'); ?></p>
        </div>
        <?php if ($zoo_pag_type == 'ajaxload') { ?>
            <p class="view-more-button"><span><?php echo esc_html__('Load More','idealauto') ?></span></p>
        <?php } ?>
    </div>
<?php endif; ?>
<?php endif; ?>
<?php
wp_reset_postdata();
?>
</div>