<?php
namespace Elementor;
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
} 
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;

    final class JWS_AdvenCar extends Widget_Base
    {
        /**
         * @return string
         */
        function get_name()
        {
            return 'jws-car-advanced';
        }

        /**
         * @return string
         */
        function get_title()
        {
            return esc_html__('jws Car Advanced', 'idealauto');
        }
        /**
         * @return string
         */
        function get_icon()
        {
            return 'cs-font jws-icon-cart-3';
        }
        /**
         * @return array
         */
        public function get_categories()
        {
            return ['jws-woocommerce-elements'];
        }
        /**
         * Register controls
         */
        protected function register_controls()
        {
            $this->start_controls_section(
                'section_setting', [
                'label' => esc_html__('Setting', 'idealauto')
            ]);


            $this->add_control('layout', [
                'label' => esc_html__('Layout', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => esc_html__('Grid', 'idealauto'),
                    'carousel' => esc_html__('Carousel', 'idealauto'),
                ],
            ]);
            
            $this->add_control('display', [
                'label' => esc_html__('Display', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => esc_html__('Grid 1', 'idealauto'),
                    'grid2' => esc_html__('Grid 2', 'idealauto'),
                    'grid3' => esc_html__('Grid 3', 'idealauto'),
                ],
            ]);

            $this->add_control('tabs_filter', [
                'label' => esc_html__('Filter', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'idealauto'),
                    'cate' => esc_html__('Category', 'idealauto'),
                    'condi' => esc_html__('Condition', 'idealauto'),
                ],

            ]);

            $this->end_controls_section();

            $this->start_controls_section(
                'section_options', [
                'label' => esc_html__('Options', 'idealauto')
            ]);
            //Cate
            $this->add_control('filter_categories', [
                'label' => esc_html__('Categories', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_categories_for_jws('car_cat', 2),
                'condition' => [
                    'tabs_filter' => ['none', 'cate'],
                ],
            ]);
            $this->add_control('default_category', [
                'label' => esc_html__('Default categories', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $this->get_categories_for_jws('car_cat'),
                'condition' => [
                    'tabs_filter' => 'cate',
                ],
            ]);
            //Condition
            $this->add_control('filter_conditions', [
                'label' => esc_html__('Conditions', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_categories_for_jws('car_condition', 2),
                'condition' => [
                    'tabs_filter' => ['condi'],
                ],
            ]);
            $this->add_control('default_condition', [
                'label' => esc_html__('Default conditions', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $this->get_categories_for_jws('car_condition'),
                'condition' => [
                    'tabs_filter' => 'condi',
                ],
            ]);
            $this->add_control( 'ajax_load', [
                'label'   => __( 'Ajax Load', 'idealauto' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition'     => [
                    'tabs_filter' => array('condi','cate'),
                ],
            ] );
            $this->add_control('filter_categories_for_condi', [
                'label' => esc_html__('Categories', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => true,
                'options' => $this->get_categories_for_jws('car_cat', 2),
                'condition' => [
                    'tabs_filter' => 'condi',
                ],
            ]);
            // Filter default
            $this->add_control('product_inc_ids', [
                'label' => esc_html__('Include product IDs', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_list_posts('cars'),
            ]);
            $this->add_control('product_ex_ids', [
                'label' => esc_html__('Exclude product IDs', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_list_posts('cars'),
            ]);
            
            $this->add_control('orderby', [
                'label' => esc_html__('Order by', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => $this->get_woo_order_by_for_jws(),
            ]);
            $this->add_control('order', [
                'label' => esc_html__('Order', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => $this->get_woo_order_for_jws(),
            ]);
            $this->add_control('asset', [
                'label' => esc_html__('Asset', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
				'options' => [
					'none'  => __( 'None', 'idealauto' ),
					'featured' => __( 'Featured', 'idealauto' ),
				],
            ]);
            $this->add_control('posts_per_page', [
                'label' => esc_html__('Products per pages', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]);
            // Grid
            $this->add_responsive_control('columns', [
                'label' => esc_html__('Columns for row', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '12' => esc_html__('1', 'idealauto'),
                    '2' => esc_html__('6', 'idealauto'),
                    '3' => esc_html__('4', 'idealauto'),
                    '4' => esc_html__('3', 'idealauto'),
                    '20' => esc_html__('5', 'idealauto'),
                    '6' => esc_html__('2', 'idealauto'),
                ],

            ]);

            $this->add_control('pagination', [
                'label' => esc_html__('Pagination', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'idealauto'),
                    'numeric' => esc_html__('Numeric', 'idealauto'),
                    'ajaxload' => esc_html__('Ajax Load More', 'idealauto'),
                    'infinity' => esc_html__('Infinity Scroll', 'idealauto'),
                ],
                'condition' => [
                    'layout' => 'grid',
                    'tabs_filter' => 'none',
                ],
            ]);
            // Carousel
            $this->add_responsive_control('slides_to_show', [
                'label' => esc_html__('Slides to Show', 'idealauto'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                    ]
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'desktop_default' => [
                    'size' => 4,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 3,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 2,
                    'unit' => 'px',
                ],
                'condition' => [
                    'layout' => 'carousel',
                ],

            ]);

            $this->add_control('speed', [
                'label' => esc_html__('Carousel: Speed to Scroll', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5000,
                'condition' => [
                    'layout' => 'carousel',
                ],

            ]);
            $this->add_control('scroll', [
                'label' => esc_html__('Carousel: Slide to Scroll', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('autoplay', [
                'label' => esc_html__('Carousel: Auto Play', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'idealauto'),
                'label_off' => esc_html__('Hide', 'idealauto'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('show_pag', [
                'label' => esc_html__('Carousel: Pagination', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'idealauto'),
                'label_off' => esc_html__('Hide', 'idealauto'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_responsive_control('show_nav', [
                'label' => esc_html__('Carousel: Navigation', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'idealauto'),
                'label_off' => esc_html__('Hide', 'idealauto'),
                'return_value' => 'true',
                'default' => 'true',
                'condition' => [
                    'layout' => 'carousel',
                ],
            ]);
            $this->add_control('nav_position', [
                'label' => esc_html__('Carousel: Navigation position', 'idealauto'),
                'description' => esc_html__('', 'idealauto'),
                'type' => Controls_Manager::SELECT,
                'default' => 'middle-nav',
                'options' => [
                    'top-nav' => esc_html__('Top', 'idealauto'),
                    'middle-nav' => esc_html__('Middle', 'idealauto'),
                ],
                'condition' => [
                    'show_nav' => 'true',
                    'layout' => 'carousel',
                ],

            ]);

            $this->end_controls_section();
                $this->start_controls_section(
			'box_style',
			[
				'label' => esc_html__( 'Box', 'idealauto' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_responsive_control(
			'column_gap',
			[
				'label'     => esc_html__( 'Columns Gap', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .car-item' => 'padding-right: calc( {{SIZE}}{{UNIT}}/2 ); padding-left: calc( {{SIZE}}{{UNIT}}/2 );',
					'{{WRAPPER}} .row' => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 );',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'     => esc_html__( 'Rows Gap', 'idealauto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .car-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
            $this->start_controls_section(
                'normal_style_settings', [
                'label' => esc_html__('Heading style', 'idealauto'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

            $this->add_control('title_color', [
                'label' => esc_html__('Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-title' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .jws-title',
                    
                ]
            );
            $this->add_control('title_background', [
                'label' => esc_html__('Background', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-title' => 'background: {{VALUE}};'
                ]
            ]);


            $this->end_controls_section();
            $this->start_controls_section(
                'filter_style_settings', [
                'label' => esc_html__('Filter style', 'idealauto'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);
            $this->add_responsive_control(
                'filter_align',
                [
                    'label' => esc_html__('Align', 'idealauto'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'idealauto'),
                            'icon' => 'fa fa-align-left',
                        ], 'center' => [
                            'title' => esc_html__('Center', 'idealauto'),
                            'icon' => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'idealauto'),
                            'icon' => 'fa fa-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .jws-head-filter' => 'text-align: {{VALUE}};'
                    ]
                ]
            );
            $this->add_control('filter_color', [
                'label' => esc_html__('Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter a' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('filter_active_color', [
                'label' => esc_html__('Active Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter a.active, {{WRAPPER}} .jws-head-filter a:hover' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'filter_typography',
                    'selector' => '{{WRAPPER}} .jws-head-filter a',
                    
                ]
            );

            $this->add_responsive_control('filter_space', [
                'label' => esc_html__('Space', 'idealauto'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
            $this->add_responsive_control('filter_padding', [
                'label' => esc_html__('Padding', 'idealauto'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .jws-head-filter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
            $this->end_controls_section();
            $this->start_controls_section(
                'carousel_style_settings', [
                'label' => esc_html__('Carousel style', 'idealauto'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);
            $this->add_control('arrow_style', [
                'label' => esc_html__('Arrow', 'idealauto'),
                'type' => Controls_Manager::HEADING,
            ]);
            $this->add_control('arrow_color', [
                'label' => esc_html__('Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('arrow_hover_color', [
                'label' => esc_html__('Hover Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn:hover' => 'color: {{VALUE}};'
                ]
            ]);
            $this->add_control('arrow_size', [
                'label' => esc_html__('Size', 'idealauto'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel .jws-carousel-btn' => 'padding-left: {{SIZE}}{{UNIT}};',
                ],
            ]);
            $this->add_control('dotted_style', [
                'label' => esc_html__('Dotted', 'idealauto'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]);
            $this->add_control('dotted_color', [
                'label' => esc_html__('Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'background: {{VALUE}};'
                ]
            ]);
            $this->add_control('dotted_hover_color', [
                'label' => esc_html__('Hover & Active Color', 'idealauto'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li:hover, {{WRAPPER}} .jws-carousel ul.slick-dots li.slick-active' => 'background: {{VALUE}};'
                ]
            ]);
            $this->add_control('dotted_size', [
                'label' => esc_html__('Size', 'idealauto'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li.slick-active' => 'width: calc({{SIZE}}{{UNIT}} * 3);',
                ],
            ]);
            $this->add_control('dotted_radius', [
                'label' => esc_html__('Border radius', 'idealauto'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jws-carousel ul.slick-dots li' => 'border-radius: {{SIZE}}{{UNIT}};'
                ],
            ]);
            $this->end_controls_section();
        }

        /**
         * Load style
         */
        public function get_style_depends()
        {
            return ['lightgallery'];
        }

        /**
         * Retrieve the list of scripts the image carousel widget depended on.
         *
         * Used to set scripts dependencies required to run the widget.
         *
         * @since 1.3.0
         * @access public
         *
         * @return array Widget scripts dependencies.
         */
        public function get_script_depends()
        {
            return ['lightgallery-all'];
        }
              protected function get_categories_for_jws($taxonomy, $select = 1)
        {
            $data = array();
    
            $query = new \WP_Term_Query(array(
                'hide_empty' => true,
                'taxonomy'   => $taxonomy,
            ));
            if ($select == 1) {
                $data['all'] = 'All';
            }
    
            if (! empty($query->terms)) {
                foreach ($query->terms as $cat) {
                    $data[ $cat->slug ] = $cat->name;
                }
            }
    
            return $data;
        }
        protected function get_woo_asset_type_for_jws($select = 1)
        {
        if ($select == 1) {
            $asset_type = array(
                'all'          => esc_html__('All', 'idealauto'),
                'latest'       => esc_html__('New Arrivals', 'idealauto'),
                'featured'     => esc_html__('Featured', 'idealauto'),
                'onsale'       => esc_html__('On sale', 'idealauto'),
                'deal'         => esc_html__('Deal', 'idealauto'),
                'best-selling' => esc_html__('Best Seller', 'idealauto'),
                'toprate'      => esc_html__('Top Rate', 'idealauto'),
            );
        } else {
            $asset_type = array(
                'latest'       => esc_html__('New Arrivals', 'idealauto'),
                'featured'     => esc_html__('Featured', 'idealauto'),
                'onsale'       => esc_html__('On sale', 'idealauto'),
                'deal'         => esc_html__('Deal', 'idealauto'),
                'best-selling' => esc_html__('Best Seller', 'idealauto'),
                'toprate'      => esc_html__('Top Rate', 'idealauto'),
            );
        }

        return $asset_type;
        }
        protected function get_list_posts($post_type = 'post')
        {
            $args = array(
                'post_type'        => $post_type,
                'suppress_filters' => true,
                'posts_per_page'   => 300,
                'no_found_rows'    => true,
            );
    
            $the_query = new \WP_Query($args);
            $results   = [];
    
            if (is_array($the_query->posts) && count($the_query->posts)) {
                foreach ($the_query->posts as $post) {
                    $results[ $post->ID ] = sanitize_text_field($post->post_title);
                }
            }
    
            return $results;
        }
            /**
     * Get oder by
     *
     * @return array oder_by
     */
    protected function get_woo_order_by_for_jws()
    {
        $order_by = array(
            'date'       => esc_html__('Date', 'idealauto'),
            'menu_order' => esc_html__('Menu order', 'idealauto'),
            'title'      => esc_html__('Title', 'idealauto'),
            'rand'       => esc_html__('Random', 'idealauto'),
        );

        return $order_by;
    }

    /**
     * Get oder
     *
     * @return array order
     */
    protected function get_woo_order_for_jws()
    {
        $order = array(
            'desc' => esc_html__('DESC', 'idealauto'),
            'asc'  => esc_html__('ASC', 'idealauto'),
        );

        return $order;
    }
        /**
         * Render
         */
        protected function render()
        {
            // default settings
            $settings = array_merge([
  
                'tabs_filter' => 'cate',
                'filter_categories' => '',
                'default_category' => '',
                'filter_conditions' => '',
                'default_condition' => '',
                'asset_type' => 'all',
                'filter_assets' => '',
                'default_asset' => '',
                'product_ids' => '',
                'orderby' => 'date',
                'order' => 'desc',
                'posts_per_page' => 6,
                'columns' => '',
                'pagination' => '',
                'slides_to_show' => 4,
                'speed' => 5000,
                'scroll' => 1,
                'autoplay' => 'true',
                'show_pag' => 'true',
                'show_nav' => 'true',
                'nav_position' => 'middle-nav',
               

            ], $this->get_settings_for_display());

            $this->add_inline_editing_attributes('title');

            $this->add_render_attribute('title', 'class', 'jws-title');

            include 'content.php';
        }
    }
