<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
if ( ! function_exists( 'jws_set_final_price' ) ) {
	/**
	 * Set cars final price based on regualer and sale price
	 *
	 * @param string $post_id .
	 */
	function jws_set_final_price( $post_id ) {

		// Set final price.
		if ( 'cars' === (string) get_post_type( $post_id ) ) {
			$final_price = 0;
			$sale_price  = get_post_meta( $post_id, 'sale_price', true );

			if ( $sale_price ) {
				$final_price = $sale_price;
			} else {
				$regular_price = get_post_meta( $post_id, 'regular_price', true );
				if ( $regular_price ) {
					$final_price = $regular_price;
				}
			}
		
            update_post_meta($post_id, 'final_price', $final_price);
		}


	}
}
add_action( 'save_post', 'jws_set_final_price' );

if ( ! function_exists( 'jws_car_price_html' ) ) {
	/**
	 * CAR Price formating
	 *
	 * @param string $class .
	 * @param string $id .
	 * @param string $tax_label .
	 * @param string $echo .
	 */
	function jws_car_price_html( $class = '', $id = null, $tax_label = true, $echo = true ) {
		global $jws_option, $post;
		$currency_code = ( isset( $jws_option['cars-currency-symbol'] ) && ! empty( $jws_option['cars-currency-symbol'] ) ) ? $jws_option['cars-currency-symbol'] : '';
		if ( function_exists( 'jws_get_currency_symbols' ) ) {
			$currency_symbol = jws_get_currency_symbols( $currency_code );
		} else {
			$currency_symbol = '$';
		}

		$symbol_position          = ( isset( $jws_option['cars-currency-symbol-placement'] ) && ! empty( $jws_option['cars-currency-symbol-placement'] ) ) ? $jws_option['cars-currency-symbol-placement'] : '';
		$seperator                = ( isset( $jws_option['cars-disable-currency-separators'] ) && ! empty( $jws_option['cars-disable-currency-separators'] ) ) ? $jws_option['cars-disable-currency-separators'] : '';
		$seperator_symbol         = ( isset( $jws_option['cars-thousand-separator'] ) && ! empty( $jws_option['cars-thousand-separator'] ) ) ? $jws_option['cars-thousand-separator'] : '';
		$decimal_separator_symbol = ( isset( $jws_option['cars-decimal-separator'] ) && ! empty( $jws_option['cars-decimal-separator'] ) ) ? $jws_option['cars-decimal-separator'] : '.';

		$decimal_places = ( ! empty( $jws_option['cars-number-decimals'] ) && is_numeric( $jws_option['cars-number-decimals'] ) ) ? $jws_option['cars-number-decimals'] : 0;

		$price_html    = '';
		$regular_price = 0;
		$sale_price    = 0;
		$car_id        = ( isset( $id ) && null !== $id ) ? $id : $post->ID;
		$regular_price =  get_post_meta( $car_id, 'regular_price', $single = true );
		$sale_price    =  get_post_meta( $car_id, 'sale_price', $single = true );

		if ( ( $regular_price > 0 ) || ( $sale_price > 0 ) ) {
		    

          
          
			$price_html = '<div class="price car-price ' . esc_attr( $class ) . '">';

			if ( 3 === (int) $symbol_position ) {
				$currency_symbol = $currency_symbol . ' ';
			} elseif ( 4 === (int) $symbol_position ) {
				$currency_symbol = ' ' . $currency_symbol;
			}

			if ( ! empty( $regular_price ) && ( $regular_price > 0 ) ) {
				$regular_price = ( isset( $seperator ) && 1 === (int) $seperator ) ? number_format( $regular_price, $decimal_places, $decimal_separator_symbol, $seperator_symbol ) : get_post_meta( $car_id, 'regular_price', $single = true );
				if ( $sale_price > 0 ) {
					$price_html .= ( 1 === (int) $symbol_position || 3 === (int) $symbol_position ) ? '<span class="old-price"> ' . esc_html( $currency_symbol . $regular_price ) . '</span>' : '<span class="old-price"> ' . esc_html( $regular_price . $currency_symbol ) . '</span>';
				} else {
					$price_html .= ( 1 === (int) $symbol_position || 3 === (int) $symbol_position ) ? '<span class="new-price"> ' . esc_html( $currency_symbol . $regular_price ) . '</span>' : '<span class="new-price"> ' . esc_html( $regular_price . $currency_symbol ) . '</span>';
				}
			}
			if ( $sale_price > 0 ) {
				$sale_price  = ( isset( $seperator ) && 1 === (int) $seperator ) ? number_format( $sale_price, $decimal_places, $decimal_separator_symbol, $seperator_symbol ) : get_post_meta( $car_id, 'sale_price', $single = true );
				$price_html .= ( 1 === (int) $symbol_position || 3 === (int) $symbol_position ) ? '<span class="new-price"> ' . esc_html( $currency_symbol . $sale_price ) . '</span>' : '<span class="new-price"> ' . esc_html( $sale_price . $currency_symbol ) . '</span>';
			}
			if ( is_single() && true === $tax_label ) {
				$tax_label_content = get_post_meta( $car_id, 'tax_label', $single = true );
				if ( ! empty( $tax_label_content ) ) {
					$price_html .= '<p class="tax">' . get_post_meta( $car_id, 'tax_label', $single = true ) . '</p>';
				}
			}

			$price_html .= '</div>';
		}

		// options to add in filter.
		$options = array(
			'class'                     => $class,
			'id'                        => $car_id,
			'tax_label'                 => $tax_label,
			'currency_symbol'           => $currency_symbol,
			'symbol_position'           => $symbol_position,
			'seperator'                 => $seperator,
			'thousand_seperator_symbol' => $seperator_symbol,
			'decimal_separator_symbol'  => $decimal_separator_symbol,
			'decimal_places'            => $decimal_places,
			'currency_code'             => $currency_code,
		);
		/**
		 * Filters the HTML layout of the vehicle price.
		 *
		 * @since 1.0
		 *
		 * @param string    $price_html HTML layout of the vehicle price.
		 * @param array     $options    Array of price elements used to build price HTML.
		 * @visible         true
		 */
		$price_html = apply_filters( 'jws_vehicle_price_html_body', $price_html, $options );

		/**
		 * Filters the HTML layout of the vehicle price.
		 *
		 * @since 1.0
		 *
		 * @param string      $price_html HTML layout of the vehicle price.
		 * @param int         $car_id      Vehicle ID.
		 * @visible           true
		 */
		if ( $echo ) {
			echo wp_kses(
				apply_filters( 'jws_car_price_html', $price_html, $car_id ),
				array(
					'div'  => array(
						'class' => true,
					),
					'span' => array(
						'class' => true,
					),
                    'p' => array(
						'class' => true,
					),
                    'img' => array(
						'class' => true,
					),
				)
			);
		} else {
			return apply_filters( 'jws_car_price_html', $price_html, $car_id );
		}
	}
}
if ( ! function_exists( 'jws_get_cars_currency_symbol' ) ) {
	/**
	 * Get currenc currency symbol
	 */
	function jws_get_cars_currency_symbol() {
		global $jws_option;
		$currency_symbol = '';
		if ( function_exists( 'jws_get_currency_symbols' ) ) {
			$currency_code   = isset( $jws_option['cars-currency-symbol'] ) ? $jws_option['cars-currency-symbol'] : '';
			$currency_symbol = jws_get_currency_symbols( $currency_code );
		} else {
			$currency_code   = isset( $jws_option['cars-currency-symbol'] ) ? $jws_option['cars-currency-symbol'] : '';
			$currency_symbol = $currency_code;
		}
		return $currency_symbol;
	}
}

if ( ! function_exists( 'jws_get_cars_currency_placement' ) ) {
	/**
	 * Get currenc currency placement
	 */
	function jws_get_cars_currency_placement() {
		global $jws_option;

		$currency_placement = isset( $jws_option['cars-currency-symbol-placement'] ) ? $jws_option['cars-currency-symbol-placement'] : '';
		$placement          = 'right';
		switch ( $currency_placement ) {
			case 1:
				$placement = 'left';
				break;
			case 3:
				$placement = 'left-with-space';
				break;
			case 4:
				$placement = 'right-with-space';
				break;
			default:
				$placement = 'right';
		}
		return $placement;
	}
}
if ( ! function_exists( 'jws_get_cars_status' ) ) {
	/**
	 * Get cars status
	 *
	 * @param string $car_id .
	 * @param string $echo .
	 */
	function jws_get_cars_status( $car_id = null, $echo = false ) {

		if ( ! $car_id ) {
			return false;
		}

		$html       = '';
		$car_status = '';

	
		$car_status = get_post_meta( $car_id , 'car_status',  true );
		if ( isset( $car_status ) && ! empty( $car_status ) ) {
			if ( 'sold' === $car_status ) {
				$html = '<span class="label car-status ' . $car_status . '">' . esc_html__( 'SOLD', 'idealauto' ) . '</span>';
			}
		}


		/**
		 * Filters the HTML of the vehicle status(SOLD/UNSOLD).
		 *
		 * @since 1.0
		 *
		 * @param string      $html  HTML of the vehicle status badge.
		 * @param int         $car_id Vehicle ID.
		 * @visible           true
		 */

		$html = apply_filters( 'jws_get_cars_status', $html, $car_id );
		if ( $echo ) {
			echo wp_kses(
				$html,
				array(
					'span' => array(
						'class' => true,
					),
				)
			);
		} else {
			return $html;
		}
	}
}

if ( ! function_exists( 'jws_car_price_msrp_html' ) ) { 
    function jws_car_price_msrp_html($class = '', $id = null,  $echo = true ) {
        global $jws_option, $post;
		$currency_code = ( isset( $jws_option['cars-currency-symbol'] ) && ! empty( $jws_option['cars-currency-symbol'] ) ) ? $jws_option['cars-currency-symbol'] : '';
      
		if ( function_exists( 'jws_get_currency_symbols' ) ) {
			$currency_symbol = jws_get_currency_symbols( $currency_code );
		} else {
			$currency_symbol = '$';
		}

		$symbol_position          = ( isset( $jws_option['cars-currency-symbol-placement'] ) && ! empty( $jws_option['cars-currency-symbol-placement'] ) ) ? $jws_option['cars-currency-symbol-placement'] : '';
		$seperator                = ( isset( $jws_option['cars-disable-currency-separators'] ) && ! empty( $jws_option['cars-disable-currency-separators'] ) ) ? $jws_option['cars-disable-currency-separators'] : '';
		$seperator_symbol         = ( isset( $jws_option['cars-thousand-separator'] ) && ! empty( $jws_option['cars-thousand-separator'] ) ) ? $jws_option['cars-thousand-separator'] : '';
		$decimal_separator_symbol = ( isset( $jws_option['cars-decimal-separator'] ) && ! empty( $jws_option['cars-decimal-separator'] ) ) ? $jws_option['cars-decimal-separator'] : '.';

		$decimal_places = ( ! empty( $jws_option['cars-number-decimals'] ) && is_numeric( $jws_option['cars-number-decimals'] ) ) ? $jws_option['cars-number-decimals'] : 0;

		$price_html    = '';
		$regular_price = 0;
		$sale_price    = 0;
		$car_id        = ( isset( $id ) && null !== $id ) ? $id : $post->ID;
		$msrp_price = get_post_meta( $car_id, 'msrp_price', $single = true );


		if ( ( $msrp_price > 0 ) ) {
			$price_html = '<div class="price-msrp ' . esc_attr( $class ) . '">';
			if ( 3 === (int) $symbol_position ) {
				$currency_symbol = $currency_symbol . ' ';
			} elseif ( 4 === (int) $symbol_position ) {
				$currency_symbol = ' ' . $currency_symbol;
			}

			if ( ! empty( $msrp_price ) && ( $msrp_price > 0 ) ) {
				$msrp_price = ( isset( $seperator ) && 1 === (int) $seperator ) ? number_format( $msrp_price, $decimal_places, $decimal_separator_symbol, $seperator_symbol ) : get_post_meta( $car_id, 'msrp_price', $single = true );
		
					$price_html .= ( 1 === (int) $symbol_position || 3 === (int) $symbol_position ) ? esc_html('MSRP: ','idealauto').esc_html( $currency_symbol . $msrp_price )  : esc_html('MSRP: ','idealauto').esc_html( $msrp_price . $currency_symbol );
		
			}


			$price_html .= '</div>';
		}

		// options to add in filter.
		$options = array(
			'class'                     => $class,
			'id'                        => $car_id,
			'currency_symbol'           => $currency_symbol,
			'symbol_position'           => $symbol_position,
			'seperator'                 => $seperator,
			'thousand_seperator_symbol' => $seperator_symbol,
			'decimal_separator_symbol'  => $decimal_separator_symbol,
			'decimal_places'            => $decimal_places,
			'currency_code'             => $currency_code,
		);
		/**
		 * Filters the HTML layout of the vehicle price.
		 *
		 * @since 1.0
		 *
		 * @param string    $price_html HTML layout of the vehicle price.
		 * @param array     $options    Array of price elements used to build price HTML.
		 * @visible         true
		 */
		$price_html = apply_filters( 'jws_vehicle_price_msrp_html_body', $price_html, $options );

		/**
		 * Filters the HTML layout of the vehicle price.
		 *
		 * @since 1.0
		 *
		 * @param string      $price_html HTML layout of the vehicle price.
		 * @param int         $car_id      Vehicle ID.
		 * @visible           true
		 */
		if ( $echo ) {
			echo wp_kses(
				apply_filters( 'jws_car_price_msrp_html', $price_html, $car_id ),
				array(
					'div'  => array(
						'class' => true,
					),
					'span' => array(
						'class' => true,
					),
				)
			);
		} else {
			return apply_filters( 'jws_car_price_msrp_html', $price_html, $car_id );
		}  
    }
}


if ( ! function_exists( 'jws_get_cars_list_attribute_grid' ) ) {
	/**
	 * Display cars few features list in card catalog view on hover overlay
	 */
	function jws_get_cars_list_attribute_grid($label,$id) { 
	            
                if(!empty($id)) {
                    $id = $id;
                }else {
                    $id = get_the_ID();
                }
                    
                $custom_attr = jws_theme_get_option('cars_grid_attr'); 
          
	            $fuel        = get_the_terms( $id, 'car_fuel_type' );
    			$mileage      = get_the_terms( $id, 'car_mileage' );
                $engine       = get_the_terms( $id, 'car_engine' );
                $body       = get_the_terms( $id, 'car_body_style' );
       
                
    			$car_mileage      = '';
                $car_fuel = '';
                $car_engine  = '';
                $car_body = '';
                $label_fuel = $label_mileage = $label_engine = $label_car_type = '';
                
                if($label == 'yes') {
                    $label_fuel = '<span class="label">'.esc_html__('FUEL TYPE','idealauto').'</span>';
                    $label_mileage = '<span class="label">'.esc_html__('MILEAGE','idealauto').'</span>';
                    $label_engine = '<span class="label">'.esc_html__('ENGINE','idealauto').'</span>';
                    $label_car_type = '<span class="label">'.esc_html__('CAR TYPE','idealauto').'</span>';    
                }
                

                if ( ! is_wp_error( $fuel ) && isset( $fuel[0]->name ) ) {
    				$car_fuel = $fuel[0]->name;
    			}
                if ( ! is_wp_error( $engine ) && isset( $engine[0]->name ) ) {
    				$car_engine = $engine[0]->name;
    			}
    			if ( ! is_wp_error( $mileage ) && isset( $mileage[0]->name ) ) {
    				$car_mileage = $mileage[0]->name;
    			}
                if ( ! is_wp_error( $body ) && isset( $body[0]->name ) ) {
    				$car_body = $body[0]->name;
    			}
                
                ob_start();  
                
                echo '<div class="car-list"><ul class="ct_ul_ol">';
                if(jws_theme_get_option('cars_grid_attr_enable')  && !empty($custom_attr['car_field'])) {
                    
                    foreach($custom_attr['car_field'] as $key => $value) {
               
                       $value_attr = get_the_terms( $id,$value );
      
                       if ( ! is_wp_error( $value_attr ) && isset( $value_attr[0]->name ) )  {
                           $label_value = $value_attr[0]->name;
                       }else {
                           $label_value = '';
                       }
                       
                       ?>
                       
                       <li ><img src="<?php echo esc_url($custom_attr['icon'][$key]['url']); ?>" alt="img_attr">
                            <span class="attr-text">  
                                <?php 
                                if($label == 'yes') { 
                                 echo '<span class="label">'.$custom_attr['label'][$key].'</span>';  
                                }
                                echo $label_value; 
                                
                                ?>
                            </span>
                        </li>
                        
                        <?php
                        
                    }
                    
                }else {
                    
                   if ( ! empty( $car_fuel ) ) {
                    ?>
    				    <li><i class="jws-icon-007-fuel"></i><span class="attr-text"><?php echo $label_fuel.esc_html( $car_fuel ); ?></span></li>
        			<?php
                    }
                    if ( $car_mileage != '' ) {
                        ?>
        				<li><i class="jws-icon-001-road-perspective"></i><span class="attr-text"><?php echo $label_mileage. esc_html( $car_mileage ); ?></span></li>
        			    <?php 
                    }
                    
                    if ( ! empty( $car_engine ) ) {
                        ?>
        				<li><i class="jws-icon-002-engine"></i><span class="attr-text"><?php echo $label_engine.esc_html( $car_engine ); ?></span></li>
        			    <?php 
                    }
                    if ( ! empty( $car_body ) ) {
                         ?>
        				<li><i class="jws-icon-car2"></i><span class="attr-text"><?php echo $label_car_type. esc_html( $car_body ); ?></span></li>
        			    <?php 
                    } 
                    
                }

    		    ?>  
    			</ul></div>
                <?php
                $attributs = ob_get_clean(); 
                echo apply_filters( 'jws_get_cars_list_attribute_grid', $attributs ); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}
}    



if ( ! function_exists( 'jws_get_vehicle_review_stamps' ) ) {
	/**
	 * Display vehicle review stamps
	 *
	 * @param string $id .
	 * @param string $echo .
	 */
	function jws_get_vehicle_review_stamps( $id = null, $echo = false ) {
	    $link            = '';
		$html            = '';
		if ( null !== $id ) {
	
                $vehicle_review_stamps = get_terms( array( 
                    'taxonomy' => 'car_vehicle_review_stamps',
                    'orderby' => 'post_date',
                    'order'      => 'ASC',
                    'hide_empty' => false
                ) );
                	
                foreach($vehicle_review_stamps as $key => $value) { 
                    
                    
                        $check = get_post_meta( $id , 'review_stamps_check_'.$value->slug,  true );
                        $url = get_post_meta( $id , 'review_stamps_link_'.$value->slug,  true );
                      
                        if ( ! empty( $value->term_id ) ) {
        					$image = get_term_meta( $value->term_id, 'image' );
        					if ( isset( $image ) && ! empty( $image ) ) {
        						$image_url = wp_get_attachment_url( $image[0] );

        						if ( ! empty( $image_url ) ) {
                					   if($check) {
                                        if ( '' !== $url ) {
            								$link .= '<a href="' . esc_url( $url ) . '" target="_blank"><img src="' . esc_url( $image_url ) . '" alt="carfax"/></a>';
            
            							} else {
            								$link .= '<img src="' . esc_url( $image_url ) . '" alt="carfax"/>';
            
            							}
                                    }
        						}
        					}
        				}
  
                } 
                
		}
        
        $link = apply_filters( 'jws_vrs_link_html', $link, $id );
        if ( '' !== $link ) {
			$html  = '<div class="car-vehicle-review-stamps">';
			$html .= $link;
			$html .= '</div>';
		}
        echo apply_filters( 'jws_get_vehicle_review_stamps', $html ); // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotE
	}
}

/**
	 * Get filtered min price for current list.
	 *
	 * @return int
	 */
if ( ! function_exists( 'jws_get_car_filtered_price' ) ) {     
	function jws_get_car_filtered_price() {
		global $wpdb,$jws_option;

		// @codingStandardsIgnoreStart

		// Current site prefix.
		$end_condition = '';
		$tbprefix      = $wpdb->prefix;
		$sql           = 'SELECT ';
		$sql          .= ' min( FLOOR( price_meta.meta_value ) ) as min_price,';
		$sql          .= ' max( CEILING( price_meta.meta_value ) ) as max_price';
		$sql          .= ' FROM ' . $tbprefix . 'posts';

		$sql .= ' LEFT JOIN ' . $tbprefix . 'postmeta as price_meta ON ' . $tbprefix . 'posts.ID = price_meta.post_id';
		if ( is_tax( 'car_cat' ) ) {
			global $wp_query;
			$term_id       = get_term_by( 'slug', $wp_query->query_vars['car_cat'], 'car_cat' );
			$end_condition = ' AND ' . $tbprefix . 'term_relationships.term_taxonomy_id=' . $term_id->term_taxonomy_id;
			$sql          .= ' LEFT JOIN ' . $tbprefix . 'term_relationships ON (' . $tbprefix . 'posts.ID = ' . $tbprefix . 'term_relationships.object_id)';
		}
		$sql .= ' INNER JOIN ' . $tbprefix . 'postmeta ON (' . $tbprefix . 'posts.ID = ' . $tbprefix . 'postmeta.post_id )';
		$sql .= ' WHERE ' . $tbprefix . "posts.post_type IN ('cars')";
		$sql .= ' AND ' . $tbprefix . "posts.post_status = 'publish'";
		$sql .= " AND price_meta.meta_key IN ('final_price')$end_condition";
	

		$price_arr = $wpdb->get_row( $sql ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

		// code for price step theme option.
	
			$min_difference        = 100 - ( $price_arr->min_price % 100 );
			$price_arr->min_price += $min_difference - 100; // Round up min price.
			$max_difference        = 100 - ( $price_arr->max_price % 100 );
			$price_arr->max_price += $max_difference; // Round up max price.
	

		return apply_filters( 'cd_vehicle_filtered_price', $price_arr );

		// @codingStandardsIgnoreEnd
	}
}



add_action( 'wp_ajax_jws_cars_filter_query', 'jws_cars_filter_query' );
add_action( 'wp_ajax_nopriv_jws_cars_filter_query', 'jws_cars_filter_query' );
if ( ! function_exists( 'jws_cars_filter_query' ) ) {
	/**
	 * Filter query
	 */
	function jws_cars_filter_query() {

		$nonce = isset( $_REQUEST['query_nonce'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['query_nonce'] ) ) : '';
	
			$attributs = jws_get_all_filters_with_ajax();
			echo wp_json_encode( $attributs );
	

		exit();
	}
}


if ( ! function_exists( 'jws_get_all_filters_with_ajax' ) && is_admin() ) {
	/**
	 * Filter with ajax
	 */
	function jws_get_all_filters_with_ajax() {
		$taxonomys = jws_get_filters_taxonomy();

		// @codingStandardsIgnoreStart
		if ( isset( $_REQUEST['selected_attr'] ) && ! empty( $_REQUEST['selected_attr'] ) ) {
			$taxonomys = explode( ',', $_REQUEST['selected_attr'] );
		}
		// @codingStandardsIgnoreEnd

		$result_filter   = array();
		$pagination_html = '';
		$data_html       = '';
		$data_order      = 'asc';
		$args            = jws_make_filter_wp_query( $_POST );

		if ( isset( $_POST['cars_order'] ) && ! empty( $_POST['cars_order'] ) ) {
			$data_order = sanitize_text_field( wp_unslash( $_POST['cars_order'] ) );
		}
		$paged = isset( $_POST['paged'] ) ? (int) $_POST['paged'] : 1;
  
        if($_POST['is_author'] == 'yes' && !isset($_POST['page'])) {
    
            $args['author']        = $_POST['author_id'];
   
        }
        if($_POST['is_user'] == 'yes' && !isset($_POST['page'])) {
   
            $args['post_status']  = array('publish', 'pending' , 'draft');

        }
        
        if(isset($_POST['page']) && $_POST['page'] == 'favourite') {
           
           $car_id = get_the_author_meta( 'jws_user_favourites', $_POST['author_id'] );  
           $args['post__in']  =  array_unique(explode(',',$car_id)); 
           
        }
        $query = new WP_Query( $args );

        
		/**
		 * Get data html
		 * */
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) :
				$query->the_post();
				ob_start();
                if(isset($_POST['is_user']) && $_POST['is_user'] == 'yes') {  
                  get_template_part( 'template-parts/content/cars/content', 'cars-private' ); 
                }elseif((isset($_POST['is_author']) && $_POST['is_author'] == 'yes') && (isset($_POST['is_user']) && $_POST['is_user'] != 'yes')){
                  get_template_part( 'template-parts/content/cars/content', 'cars-favourites' );  
                }else {
                  get_template_part( 'template-parts/content/cars/content', 'cars' );   
                }

				
				$datahtml   = ob_get_clean();
              
				$data_html .= $datahtml;
			endwhile;
			wp_reset_postdata();

			$pagination_html = jws_cars_pagination( false, $query, $paged );
		} else {
			$data_html = '<div class="col-xl-12"><h4 class="alert alert-warning">'.esc_html__( 'No result were found matching your selection.', 'idealauto' ).'</h4><a href id="reset_filters">'.esc_html__('Reset Filter','idealauto').'</a></div>';
		}

		if ( ! isset( $_POST['cfb'] ) ) {
			$attributs = '<div class="listing_sort">';
		}
		if ( isset( $_POST['cfb'] ) && 'yes' === $_POST['cfb'] ) {
			$attributs = '';
		}

		$args['fields']        = 'ids';
		$args['no_found_rows'] = true;
		$filter_query_args     = array_replace( $args, array( 'posts_per_page' => -1 ) );
		$tax_query_arry        = jws_set_tex_query_array( $taxonomys, $_POST );
		$filter_query          = new WP_Query( $filter_query_args );
		$tot_result            = $filter_query->post_count;
        

        
		if ( $filter_query->have_posts() ) {

			foreach ( $taxonomys as $tax ) {
				if (( isset( $tax_query_arry ) && ! empty( $tax_query_arry ) )) {
					$tax_args = array(
						'orderby' => 'name',
						'order'   => 'ASC',
						'fields'  => 'all',
					);
					$terms    = wp_get_object_terms( $filter_query->posts, $tax, $tax_args );

					foreach ( $terms as $tdata ) {

						if ( $tdata->taxonomy === $tax ) {
							$result_filter[ $tax ][] = array(
								'post_id'  => get_the_ID(),
								'term_id'  => $tdata->term_id,
								'slug'     => $tdata->slug,
								'name'     => $tdata->name,
								'taxonomy' => $tdata->taxonomy,
							);
                            $check_resul_filter[ $tax ][] = array(
                                $tdata->slug => $tdata->name,
			
							);
						}
					}
				}else {
				    // When not set any filter.
					$terms = get_terms(
						array(
							'taxonomy'   => $tax,
							'hide_empty' => true,
						)
					);
					foreach ( $terms as $tdata ) {
						$selected = '';
						if ( isset( $_POST[ $tax ] ) && '' !== $_POST[ $tax ] ) {
							if ( $_POST[ $tax ] === $tdata->slug ) {
								$selected = "selected=''";
							}
						}

						$check_resul_filter[ $tax ][] = array(
							$tdata->slug => $tdata->name,
						);
					}
				}
			}
          
			wp_reset_postdata();
		}
		$jws_ganerate_filter_box = jws_ganerate_filter_box( $taxonomys, $tax_query_arry, $result_filter );
    
		$html = '';
		$asc = ( 'asc' === $data_order ) ? 'active' : '' ;
	    $desc = ( 'desc' === $data_order ) ? 'active' : '' ;
	
        $html .= '<a id="pgs_cars_order" class="'.$asc.'" data-order="desc" data-current_order="asc" href="javascript:void(0)"><i class="fas fa-arrow-up"></i></a>';
        $html .= '<a id="pgs_cars_order" class="'.$desc.'" data-order="asc" data-current_order="desc" href="javascript:void(0)"><i class="fas fa-arrow-down"></i></a>';
		if ( ! isset( $_POST['cfb'] ) ) {
			$attributs .= '<div class="submit-filters-btn"><a class="button" href="javascript:void(0);" id="submit_all_filters">' . esc_html__( 'Submit', 'idealauto' ) . '</a></div>';
			$attributs .= '<div class=""><a class="button" href="javascript:void(0);" id="reset_filters">' . esc_html__( 'Reset All Filters', 'idealauto' ) . '</a></div>';
			$attributs .= '</div>';
			$data       = array(
				'status'          => 'success',
				'all_filters'     => $check_resul_filter,
				'data_html'       => $data_html,
				'pagination_html' => $pagination_html,
				'order_html'      => $html,
				'tot_result'      => $tot_result,
			);
		} else {
			$data = array(
				'status'      => 'success',
				'all_filters' => $check_resul_filter,
                'check_filters' =>$loc,
			);
		}
		return $data;
	}
}

if ( ! function_exists( 'jws_get_filters_taxonomy' ) ) {
	/**
	 * Filters taxonomy
	 */
	function jws_get_filters_taxonomy() {
	   
    
       
		global $jws_option;
        
        
      //  var_dump($jws_option['car_taxonomy_field']['enabled']);
        $taxonomies = array();
        if(isset($jws_option['car_taxonomy_field']['enabled']) && !empty($jws_option['car_taxonomy_field']['enabled'])) {
           foreach($jws_option['car_taxonomy_field']['enabled'] as $key => $value) {
            if($key == 'placebo') continue;
            $taxonomies[] = $key;
           } 
        }else {
           $taxonomies = array(  'car_make' , 'car_model' , 'car_year', 'car_body_style', 'car_condition', 'car_mileage', 'car_transmission', 'car_engine', 'car_exterior_color' ); 
        }
        


        
		
		/**
		* Filters the elements of vehicle taxonomy used on vehicle inventory page filters.
		*
		* @since 1.0
		* @return array     Array of vehicle taxonomy slugs.
		* $visible          true
		*/
		$taxonomys = apply_filters( 'jws_filters_taxonomy_array', $taxonomies );
		if ( isset( $jws_option['cars_listing_filters']['Added Filters'] ) ) {
			unset( $jws_option['cars_listing_filters']['Added Filters']['placebo'] );
			$car_attributes = $jws_option['cars_listing_filters']['Added Filters'];
			if ( ! empty( $car_attributes ) ) {
				$taxonomys = array();
				foreach ( $car_attributes as $key => $car_att ) {
					$taxonomys[] = $key;
				}
			}
		}
		// Check year range slider enabled?
		if ( isset( $jws_option['year_range'] ) && 'yes' === (string) $jws_option['year_range'] ) {
			if ( ! array_search( 'car_year', $taxonomys ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
				$key = array_search( 'car_year', $taxonomys ); // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict

				unset( $taxonomys[ $key ] );
			}
		}
		/**
		 * Filters the array of vehicle filter attributes displayed on vehicle inventory page.
		 *
		 * @since 1.0
		 *
		 * @param array        $taxonomys   Array of vehicle filter attributes.
		 * @visible            true
		 */
		return apply_filters( 'jws_get_filters_taxonomy', $taxonomys );
	}
}

if ( ! function_exists( 'jws_make_filter_wp_query' ) ) {
	/**
	 * Make filter wp query
	 *
	 * @param array $request_method .
	 */
	function jws_make_filter_wp_query( $request_method ) {

		$tax_query_arry = array();
		$taxonomys      = jws_get_filters_taxonomy();
		if ( isset( $request_method['selected_attr'] ) && ! empty( $request_method['selected_attr'] ) ) {
			$taxonomys = explode( ',', $request_method['selected_attr'] );
		}

		$tax_query_arry  = jws_set_tex_query_array( $taxonomys, $request_method );
		$data_html       = '';
		$pagination_html = '';
		$cars_orderby    = 'date (post_date)';
		$data_order      = 'asc';

		global $jws_option;


		$per_page   = 12;

		if ( isset( $jws_option['cars-per-page'] ) ) {
			$per_page = $jws_option['cars-per-page'];
		}
		if ( isset( $request_method['cars_pp'] ) && ! empty( $request_method['cars_pp'] ) ) {
			$per_page = $request_method['cars_pp'];
		}

		if ( isset( $request_method['cars_order'] ) && ! empty( $request_method['cars_order'] ) ) {
			$data_order = $request_method['cars_order'];
		}
		$paged = isset( $request_method['paged'] ) ? (int) $request_method['paged'] : 1;
		$args  = array(
			'post_type'      => 'cars',
			'post_status'    => array( 'publish', 'acf-disabled' ),
			'posts_per_page' => $per_page,
			'order'          => $data_order,
			'paged'          => $paged,
		);

		if ( isset( $request_method['cars_orderby'] ) && ! empty( $request_method['cars_orderby'] ) ) {
			$cars_orderby = $request_method['cars_orderby'];
		}

		if ( 'sale_price' === $cars_orderby ) {
			$args['orderby']  = 'meta_value_num';
			$args['meta_key'] = 'final_price';
		} elseif ( 'featured' === $cars_orderby ) {
			$args['orderby']  = 'meta_value';
			$args['meta_key'] = 'featured';
		} else {
			$args['orderby'] = $cars_orderby;
		}
        
  

		if ( isset( $request_method['s'] ) && ! empty( $request_method['s'] ) ) {
			$args['s'] = $request_method['s'];
		}

		if ( isset( $tax_query_arry ) && ! empty( $tax_query_arry ) ) {

			$args['tax_query'] = array( 'relation' => 'AND' );

			foreach ( $tax_query_arry as $k => $val ) {
				$args['tax_query'][ $k ] = $val;
			}
		}

		/* Set Price meta query  */
		$pgs_min_price = isset( $request_method['min_price'] ) ? esc_attr( $request_method['min_price'] ) : 0;
		$pgs_max_price = isset( $request_method['max_price'] ) ? esc_attr( $request_method['max_price'] ) : 0;
		if ( $pgs_min_price > 0 || $pgs_max_price > 0 ) {
			$prices = jws_get_car_filtered_price();
			$min    = floor( $prices->min_price );
			$max    = ceil( $prices->max_price );
			if ( $min !== $pgs_min_price || $max !== $pgs_max_price ) {
				$args['meta_query'][] = array(
					'key'     => 'final_price',
					'value'   => array( $pgs_min_price, $pgs_max_price ),
					'compare' => 'BETWEEN',
					'type'    => 'NUMERIC',
				);
			}
		}

		/* Don't want to show sold car on car listing page */
		if ( isset( $jws_option['car_no_sold'] ) && 1 === (int) $jws_option['car_no_sold'] ) {
			$args['meta_query'][] = array(
				'key'     => 'car_status',
				'value'   => 'sold',
				'compare' => '!=',
			);

		}

		if ( isset( $request_method['vehicle_location'] ) && ! empty( $request_method['vehicle_location'] ) ) {
			$args['meta_query'][] = array(
				'key'     => 'vehicle_location',
				'value'   => $request_method['vehicle_location'],
				'compare' => 'LIKE',
			);
		}
		return $args;
	}
}

if ( ! function_exists( 'jws_set_tex_query_array' ) ) {
	/**
	 * Tax query
	 *
	 * @param array $taxonomys .
	 * @param array $post .
	 */
	function jws_set_tex_query_array( $taxonomys, $post ) {
		$mileage_terms = array();
		$arg           = array();
		if ( isset( $_GET ) && function_exists( 'jws_get_cars_taxonomy' ) ) {
			$cars_taxonomy = jws_get_cars_taxonomy();

			$cfb = array();
			foreach ( $_GET as $key => $val ) {
				if ( in_array( $key, $cars_taxonomy ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
					$cfb[] = $key;
				}
			}
			if ( ! empty( $cfb ) ) {
				$taxonomys = array_unique( array_merge( $taxonomys, $cfb ) );
			}
		}
		foreach ( $taxonomys as $tax ) {
			if ( isset( $post[ $tax ] ) && '' !== $post[ $tax ] ) {
				foreach ( $post as $key => $val ) {
					if ( $key === $tax ) {
						if ( 'car_mileage' === $key ) {
							$terms = get_terms(
								array(
									'taxonomy'   => 'car_mileage',
									'hide_empty' => true,
								)
							);
							foreach ( $terms as $tdata ) {
								$mileage      = $tdata->slug;
								$post_mileage = $post[ $tax ];
								if ( is_numeric( $mileage ) && is_numeric( $post_mileage ) ) {
									if ( $mileage < $post[ $tax ] ) {
										$mileage_terms[] = $tdata->slug;
									}
								}
							}

							$arg[] = array(
								'taxonomy' => $tax,
								'field'    => 'slug',
								'terms'    => $mileage_terms,
							);
						} else {
							$arg[] = array(
								'taxonomy' => $tax,
								'field'    => 'slug',
								'terms'    => array( $post[ $tax ] ),
							);
						}
					}
				}
			}
		}

	   if ( is_tax( 'car_cat' ) || ( isset( $post['is_vehicle_cat'] ) && 'yes' === $post['is_vehicle_cat'] ) ) {
			global $wp_query;
			if ( isset( $wp_query->query_vars['car_cat'] ) && ! empty( $wp_query->query_vars['car_cat'] ) ) {
				$vehicle_cat = $wp_query->query_vars['car_cat'];
			} elseif ( isset( $post['vehicle_cat'] ) && ! empty( $post['vehicle_cat'] ) ) {
				$vehicle_cat = $post['vehicle_cat'];
			}
			$arg[] = array(
				'taxonomy' => 'car_cat',
				'field'    => 'slug',
				'terms'    => array( $vehicle_cat ),
			);
		}

		$year_rang_slider = jws_is_year_range_active();
		if ( $year_rang_slider ) {

			$year_range    = jws_get_year_range();
			$yearmin       = isset( $year_range['min_year'] ) ? $year_range['min_year'] : '';
			$yearmax       = isset( $year_range['max_year'] ) ? $year_range['max_year'] : '';
			$pgs_min_year  = isset( $post['min_year'] ) ? esc_attr( $post['min_year'] ) : 0;
			$pgs_max_year  = isset( $post['max_year'] ) && !empty( $post['max_year']) ? esc_attr( $post['max_year'] ) : $yearmax;
			$year_rang_qur = array();
         
			if ( $pgs_min_year > 0 || $pgs_max_year > 0 ) {

				if ( $yearmin !== $pgs_min_year || $yearmax !== $pgs_max_year ) {

					$terms         = get_terms(
						array(
							'taxonomy'   => 'car_year',
							'hide_empty' => true,
						)
					);
					$quryear       = array();
					$taxonomy_name = get_taxonomy( 'car_year' );
					$slug          = $taxonomy_name->rewrite['slug'];
					$label         = $taxonomy_name->labels->menu_name;
					if ( ! empty( $terms ) ) {
						foreach ( $terms as $tdata ) {
							if ( ( $tdata->slug >= $pgs_min_year ) && ( $tdata->slug <= $pgs_max_year ) ) {
								$quryear[] = $tdata->slug;
							}
						}
					}
					$arg['tax_query'][] = array(
						'taxonomy' => 'car_year',
						'field'    => 'slug',
						'terms'    => $quryear,
						'operator' => 'IN',
					);

				}
			}
		}
		/**
		 * Filters vehicle taxonomy query.
		 *
		 * @since 1.0
		 * @param array      $arg   Vehicle taxonomy query arguments.
		 * @visible          true
		 */
		return apply_filters( 'jws_set_tax_query', $arg );
	}
}

   /**
     * Get Taxomony of Cars Posttype.
     */

/**
 * Get Taxomony of Cars Posttype.
 */
function jws_get_cars_taxonomy() {
	$taxonomies = get_object_taxonomies( 'cars' );

	$vehicle_cat_key = array_search( 'vehicle_cat', $taxonomies, true );
	if ( false !== $vehicle_cat_key ) {
		unset( $taxonomies[ $vehicle_cat_key ] );
	}

	$car_features_options_key = array_search( 'car_features_options', $taxonomies, true );
	if ( false !== $car_features_options_key ) {
		unset( $taxonomies[ $car_features_options_key ] );
	}

	$car_vehicle_review_stamps_key = array_search( 'car_vehicle_review_stamps', $taxonomies, true );
	if ( false !== $car_vehicle_review_stamps_key ) {
		unset( $taxonomies[ $car_vehicle_review_stamps_key ] );
	}
	$taxonomy_array = array();
	foreach ( $taxonomies as $taxonomy ) {
		$tax_obj                           = get_taxonomy( $taxonomy );
		$taxonomy_array[ $tax_obj->label ] = $taxonomy;
	}
	return $taxonomy_array;
}

    
 if ( ! function_exists( 'jws_is_year_range_active' ) ) :
	/**
	 * Check year rang slider is active for listing page
	 */
	function jws_is_year_range_active() {
		$year_rang_slider = true;
		global $jws_option;
		$cars_year_rang = ( isset( $jws_option['year_range'] ) ) ? $jws_option['year_range'] : 'no';
		if ( 'no' === (string) $cars_year_rang ) {
			$year_rang_slider = false;
		}
		return $year_rang_slider;
	}
endif;   

if ( ! function_exists( 'jws_get_year_range' ) ) {
	/**
	 * Get filtered year range.
	 *
	 * @return int
	 */
	function jws_get_year_range() {
		global $wpdb , $jws_option;
		$terms = get_terms(
			array(
				'taxonomy'   => 'car_year',
				'hide_empty' => true,
				'order'      => 'ASC',
			)
		);

		$taxonomy_name = get_taxonomy( 'car_year' );
		$data          = array();
        if ( isset( $jws_option['year_range'] ) && 'yes' === (string) $jws_option['year_range'] ) { 
    		if ( ! empty( $taxonomy_name ) ) {
    			$slug  = $taxonomy_name->rewrite['slug'];
    			$label = $taxonomy_name->labels->menu_name;
    
    			if ( ! empty( $terms ) ) {
    				$year_arr = array();
    				foreach ( $terms as $tdata ) {
    					$year_arr[] = $tdata->slug;
    				}
    				$first = reset( $year_arr );
    				$last  = max( $year_arr );
    				$data  = array(
    					'min_year' => $first,
    					'max_year' => $last,
    				);
    			}
    		}
        }
		/**
		 * Filters the year range to be used in inventory filter.
		 *
		 * @since 1.0
		 * @param array     $data Year range array - minimum year and maximum year.
		 * @hooked jws_list_layout_style_lazyload - 10
		 * @visible          true
		 */
		return apply_filters( 'jws_year_range', $data );
	}
}

if ( ! function_exists( 'jws_ganerate_filter_box' ) ) {
	/**
	 * Filter box
	 *
	 * @param string $taxonomys get the taxonomys.
	 * @param array  $tax_query_arry get tex query array.
	 * @param array  $result_filter .
	 */
	function jws_ganerate_filter_box( $taxonomys, $tax_query_arry = array(), $result_filter = array() ) {
		/**
		 * IF Request from custom search box Widgets
		 */
		$result_data = array();

		/**
		 * CFB used for custom filter box
		 * */
		if ( isset( $_POST['cfb'] ) && 'yes' === $_POST['cfb'] ) {
			$attributs = '';
			foreach ( $taxonomys as $tax ) {
				$taxonomy_name = get_taxonomy( $tax );
				$label         = $taxonomy_name->labels->menu_name;
				// Check filter array set.
				if ( isset( $tax_query_arry ) && ! empty( $tax_query_arry ) ) {
					$newarr = array();
					if ( isset( $result_filter[ $tax ] ) ) {
						foreach ( $result_filter[ $tax ] as $term_data ) {
							if ( 'car_mileage' === $tax ) {

								$mileage_array = jws_get_mileage_array();
								if ( 'car_mileage' === $tax && isset( $t ) && 1 === $t ) {
									foreach ( $mileage_array as $mileage ) {
										$result_data[ $tax ][] = array(
											$mileage => '&lt; ' . $mileage,
										);
									}
									$t++;
								}
							} else {
								$selected = '';
								if ( isset( $_POST[ $tax ] ) && '' !== $_POST[ $tax ] ) {
									if ( $_POST[ $tax ] === $term_data['slug'] ) {
										$selected = "selected='selected'";

									}
								}
								//if ( ! in_array( $term_data['slug'], $newarr ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
									$newarr[]              = $term_data['slug'];
									$result_data[ $tax ][] = array(
										$term_data['slug'] => $term_data['name'],
									);
								//}
							}
						}
					}
				} else {
					// When not set any filter.
					$terms = get_terms(
						array(
							'taxonomy'   => $tax,
							'hide_empty' => true,
						)
					);
					foreach ( $terms as $tdata ) {
						$selected = '';
						if ( isset( $_POST[ $tax ] ) && '' !== $_POST[ $tax ] ) {
							if ( $_POST[ $tax ] === $tdata->slug ) {
								$selected = "selected=''";
							}
						}

						$result_data[ $tax ][] = array(
							$tdata->slug => $tdata->name,
						);
					}
				}
			}
		} else {

			/**
			 * Without CFB
			 * */
			$tot_count = count( $taxonomys );
			$i         = 0;
			$t         = 1;
			foreach ( $taxonomys as $tax ) {
				$flg = 0;
				if ( isset( $tax_query_arry ) && ! empty( $tax_query_arry ) ) {
					$newarr = array();
					if ( isset( $result_filter[ $tax ] ) ) {
						foreach ( $result_filter[ $tax ] as $term_data ) {
							if ( 'car_mileage' === $tax ) {

								$mileage_array = jws_get_mileage_array();
								if ( 'car_mileage' === $tax && 1 === $t ) {
									foreach ( $mileage_array as $mileage ) {
										$result_data[ $tax ][] = array(
											$mileage => '&lt; ' . $mileage,
										);
									}
									$t++;
								}
							} else {
								$selected = '';
								if ( isset( $_POST[ $tax ] ) && '' !== $_POST[ $tax ] ) {
									if ( $_POST[ $tax ] === $term_data['slug'] ) {
										$selected = "selected='selected'";

									}
								}
								if ( ! in_array( $term_data['slug'], $newarr ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
									$newarr[]              = $term_data['slug'];
									$result_data[ $tax ][] = array(
										$term_data['slug'] => $term_data['name'],
									);
								}
							}
						}
					}
				} else {
					$terms = get_terms(
						array(
							'taxonomy'   => $tax,
							'hide_empty' => true,
						)
					);
					foreach ( $terms as $tdata ) {
						$selected = '';
						if ( isset( $_POST[ $tax ] ) && '' !== $_POST[ $tax ] ) {
							if ( $_POST[ $tax ] === $tdata->slug ) {
								$selected = "selected=''";
							}
						}

						$result_data[ $tax ][] = array(
							$tdata->slug => $tdata->name,
						);
					}
				}
			}
		}
		if ( isset( $_POST['current_attr'] ) && isset( $result_data[ $_POST['current_attr'] ] ) ) {
			unset( $result_data[ $_POST['current_attr'] ] );
		}
		return $result_data;
	}
}

if ( ! function_exists( 'jws_get_mileage_array' ) ) {
	/**
	 * Get array
	 */
	function jws_get_mileage_array() {
		$mileage_array = array( '10000', '20000', '30000', '40000', '50000', '60000', '70000', '80000', '90000', '100000' );
         global $wpdb;

          $query = $wpdb->get_results( $wpdb->prepare( "
            SELECT DISTINCT  pm.meta_value FROM {$wpdb->postmeta} pm
            LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
            WHERE pm.meta_key = '%s' 
            AND p.post_type = '%s'
          ", 'car_mileage' , 'cars'
        ) );
   
		/**
		 * Filters the vehicle mileage array - mostly used in vehicle filters on "vehicle inventory page" and "potenza custom filters" shortcode.
		 *
		 * @since 1.0
		 * @param array         $mileage_array  Mileage array elements.
		 * @visible             true
		 */
		return apply_filters( 'jws_get_mileage_array', $mileage_array );
	}
}


if ( ! function_exists( 'jws_cars_pagination' ) ) {
	/**
	 * Cars pagination
	 *
	 * @param bool $echo .
	 * @param bool $query .
	 * @param bool $paged .
	 */
	function jws_cars_pagination( $echo = true, $query = null, $paged = null ) {
		if ( null !== $query || ! empty( $query ) ) {
			$wp_query = $query;
			if ( null !== $paged ) {
				$paged = ( 0 === $paged ) ? 1 : $paged;
			} else {
				$paged = ( 0 === get_query_var( 'paged' ) ) ? 1 : get_query_var( 'paged' );
			}
		} else {
			global $wp_query;
			$paged = ( 0 === get_query_var( 'paged' ) ) ? 1 : get_query_var( 'paged' );
		}

		$big   = 999999999; // need an unlikely integer.
		$pages = paginate_links(
			array(
				'base'      => str_replace( $big, '%#%', wp_specialchars_decode( esc_url( get_pagenum_link( $big ) ) ) ),
				'format'    => '?paged=%#%',
				'current'   => max( 1, $paged ),
				'total'     => $wp_query->max_num_pages,
				'type'      => 'array',
				'prev_next' => true,
				'prev_text' => esc_html__( 'Prev', 'idealauto' ),
				'next_text' => esc_html__( 'Next', 'idealauto' ),
			)
		);
		if ( is_array( $pages ) ) {
		  
         
            $pagination = ' <div class="jws-pagination-number">';
			$pagination = '<ul class="page-numbers">';
			foreach ( $pages as $page ) {
				$pagination .= "<li>$page</li>";
			}
			$pagination .= '</ul>';
            $pagination .= '</div>';
			$pagination_escaped = wp_kses(
				$pagination,
				array(
					'ul'   => array(
						'class' => true,
					),
					'li'   => array(
						'class' => true,
					),
					'span' => array(
						'class'        => true,
						'aria-current' => true,
					),
					'a'    => array(
						'class' => true,
						'href'  => true,
					),
				)
			);

			if ( $echo ) {
				echo ''.$pagination_escaped;
			} else {
				return $pagination_escaped;
			}
		}
	}
}

if ( ! function_exists( 'jws_get_car_catlog_sidebar_left' ) ) {
	/**
	 * Catlog sidebar left
	 */
	function jws_get_car_catlog_sidebar_left() {

			if ( is_active_sidebar( 'sidebar-inventory' ) ) {
					?>
					<div  class="col-xl-3 col-lg-12 col-12 cars-sidebar">
						<div class="listing-sidebar jws_sticky_move">
							<?php dynamic_sidebar( 'sidebar-inventory' ); ?>
						</div>
					</div>
					<?php
			}
	}
}

if ( ! function_exists( 'jws_get_all_filters' ) ) {
	/**
	 * Get all filter select box
	 */
	function jws_get_all_filters() {
		$taxonomys     = jws_get_filters_taxonomy();
		$get_arg       = array();
		$get_url_terms = array();

		if ( is_tax() ) {
			$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
			if ( isset( $term ) && ! empty( $term ) ) {
				$_GET[ $term->taxonomy ] = $term->slug;
			}
		}

		// @codingStandardsIgnoreStart
		foreach ( $taxonomys as $tax ) {
			/** Check from url if there any filter*/
			if ( isset( $_GET[ $tax ] ) && '' !== $_GET[ $tax ] ) {
				if ( isset( $_GET['car_mileage'] ) && ! empty( $_GET['car_mileage'] ) ) {
					$get_arg[] = array(
						'taxonomy' => $tax,
						'field'    => 'slug',
						'terms'    => array( $_GET[ $tax ] ),
						'compare'  => '<',
						'type'     => 'NUMERIC',
					);
				} else {
					$get_arg[] = array(
						'taxonomy' => $tax,
						'field'    => 'slug',
						'terms'    => array( $_GET[ $tax ] ),
					);
				}
			}
		}
		// @codingStandardsIgnoreEnd

		/** Check year_range filter is active then add in query*/
		$year_range    = jws_get_year_range();
		$yearmin       = isset( $year_range['min_year'] ) ? $year_range['min_year'] : 0;
		$yearmax       = isset( $year_range['max_year'] ) ? $year_range['max_year'] : 0;
		$pgs_min_year  = isset( $post['min_year'] ) ? sanitize_text_field( wp_unslash( $post['min_year'] ) ) : 0;
		$pgs_max_year  = isset( $post['max_year'] ) && !empty( $post['max_year']) ? esc_attr( $post['max_year'] ) : $yearmax;
		$year_rang_qur = array();
		if ( $pgs_min_year > 0 || $pgs_max_year > 0 ) {

			if ( $yearmin !== $pgs_min_year || $yearmax !== $pgs_max_year ) {

				$terms         = get_terms(
					array(
						'taxonomy'   => 'car_year',
						'hide_empty' => true,
					)
				);
				$quryear       = array();
				$taxonomy_name = get_taxonomy( 'car_year' );
				$slug          = $taxonomy_name->rewrite['slug'];
				$label         = $taxonomy_name->labels->menu_name;
				if ( ! empty( $terms ) ) {
					foreach ( $terms as $tdata ) {
						if ( ( $tdata->slug >= $pgs_min_year ) && ( $tdata->slug <= $pgs_max_year ) ) {
							$quryear[] = $tdata->slug;
						}
					}
				}
				$get_arg['tax_query'][] = array(
					'taxonomy' => 'car_year',
					'field'    => 'slug',
					'terms'    => $quryear,
					'operator' => 'IN',
				);

			}
		}

		/**
		 * Filters the search arguments used in filtering vehicle inventory on inventory page.
		 *
		 * @since 1.0
		 *
		 * @param array      $get_arg   Array arguments for vehicle filter query.
		 * @visible          true
		 */
		$get_arg = apply_filters( 'jws_get_all_filters', $get_arg );

		/**
		 * Pass query var
		 *
		 * @param array $get_arg pass query var if any in url else it blank
		 */
		$attributs = jws_new_get_all_filters( $get_arg );
		echo wp_kses(
			$attributs,
			array(
				'div'    => array(
					'id'       => true,
					'class'    => true,
					'tabindex' => true,
				),
				'span'   => array(
					'id'    => true,
					'class' => true,
				),
				'strong' => array(
					'id'    => true,
					'class' => true,
				),
				'ul'     => array(
					'id'                => true,
					'class'             => true,
					'data-all-listings' => true,
				),
				'li'     => array(
					'id'        => true,
					'class'     => true,
					'style'     => true,
				),
                'span'     => array(
					'id'        => true,
					'class'     => true,
					'style'     => true,
					'data-type' => true,
				),
				'select' => array(
					'id'       => true,
					'class'    => true,
					'data-tax' => true,
					'data-id'  => true,
					'name'     => true,
					'style'    => true,
                    'multiple' => true
				),
				'option' => array(
					'id'       => true,
					'class'    => true,
					'value'    => true,
					'selected' => true,
				),
				'a'      => array(
					'id'    => true,
					'class' => true,
					'href'  => true,
				),
				'i'      => array(
					'class' => true,
				),
                 'label' => array(
                    'for' => true,
                ),
				'input'  => array(
					'type'         => true,
					'id'           => true,
					'name'         => true,
					'value'        => true,
					'data-yearmin' => true,
					'data-yearmax' => true,
                    'data-min' => true,
					'data-max' => true,
					'readonly'     => true,
					'data-cfb'     => true,
                    'placeholder' => true,
                    
				),
			)
		);
	}
}

if ( ! function_exists( 'jws_new_get_all_filters' ) ) {
	/**
	 * Get all filters
	 *
	 * @param array $get_arg .
	 */
	function jws_new_get_all_filters( $get_arg ) {
		$is_vehicle_cat = false;
		if ( is_tax( 'vehicle_cat' ) ) {
			$is_vehicle_cat = false;
			global $wp_query;
			$get_arg[] = array(
				'taxonomy' => 'vehicle_cat',
				'field'    => 'slug',
				'terms'    => array( $wp_query->query_vars['vehicle_cat'] ),

			);
		}

		$taxonomys     = jws_get_filters_taxonomy();
		$args          = jws_make_filter_wp_query( $_GET );
		$result_filter = array();

		$args_new                  = $args;
		$args_new['fields']        = 'ids';
		$args_new['no_found_rows'] = true;
		$filter_query_args         = array_replace( $args_new, array( 'posts_per_page' => -1 ) );

		$filter_query = new WP_Query( $filter_query_args );
		$tot_result   = $filter_query->post_count;
		if ( $filter_query->have_posts() ) {
			if ( isset( $get_arg ) && ! empty( $get_arg ) && $tot_result > 0 ) {
				foreach ( $taxonomys as $tax ) {
					$tax_args = array(
						'orderby' => 'name',
						'order'   => 'ASC',
						'fields'  => 'all',
					);
					$terms    = wp_get_object_terms( $filter_query->posts, $tax, $tax_args );
					foreach ( $terms as $tdata ) {
						if ( $tdata->taxonomy === $tax ) {
							$result_filter[ $tax ][] = array(
								'term_id'  => $tdata->term_id,
								'slug'     => $tdata->slug,
								'name'     => $tdata->name,
								'taxonomy' => $tdata->taxonomy,
							);
						}
					}
				}
			}
			if ( $is_vehicle_cat ) {
				$args  = array(
					'orderby' => 'name',
					'order'   => 'ASC',
					'fields'  => 'all',
				);
				$terms = wp_get_object_terms( $filter_query->posts, 'vehicle_cat', $tax_args );
				foreach ( $terms as $tdata ) {
					if ( 'vehicle_cat' === $tdata->taxonomy ) {
						$result_filter[ $tax ][] = array(
							'term_id'  => $tdata->term_id,
							'slug'     => $tdata->slug,
							'name'     => $tdata->name,
							'taxonomy' => $tdata->taxonomy,
						);
					}
				}
			}
			wp_reset_postdata();
		}
		$attributs      = '<div class="cars-total-vehicles">';
			//$attributs .= '<span class="stripe"><strong><span class="number_of_listings">' . esc_html( $tot_result ) . '</span> ';
			//$attributs .= '<span class="listings_grammar">' . esc_html__( 'Vehicles Matching', 'idealauto' ) . '</span></strong></span>';

		//$attributs     .= '</div>';
		$attributs     .= '<div class="listing_sort">';

		$attributs .= '<div class="sort-filters">';
        $attributs .= '<ul>';
		$t          = 1;

		$is_year_range_active = jws_is_year_range_active();
		if ( $is_year_range_active ) {
			if ( array_search( 'car_year', $taxonomys ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
				$key = array_search( 'car_year', $taxonomys ); // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict

				//unset( $taxonomys[ $key ] );
                }
		}
            
		/** Here we create selectbox as per query or default*/
		foreach ( $taxonomys as $tax ) {
           
            $has_val = isset($_GET[ $tax ]) && !empty($_GET[ $tax ]) ? ' has_val' : '';
			$taxonomy_name = get_taxonomy( $tax );
			$label         = $taxonomy_name->labels->menu_name;
            if($tax == 'car_year' && $is_year_range_active) {
                	$year_range_filters = jws_get_year_range_filters( '' );
			        $attributs         .= $year_range_filters;
            }else {
            $attributs    .= '<li><label>'.$label.'</label><select data-tax="--' . esc_html__('All ','idealauto').esc_html( $label ) . '--" data-id="' . esc_attr( $tax ) . '" id="sort_' . esc_attr( $tax ) . '" name="' . esc_attr( $tax ) . '" class="select-sort-filters '.$has_val.'" >';
			$attributs    .= '<option value="">--' . esc_html__('All ','idealauto').esc_html( $label ) . '--</option>';
			/** Cehck is there any argumet for filter term */
			if ( isset( $get_arg ) && ! empty( $get_arg ) ) {
				$newarr = array();

				if ( ! empty( $result_filter[ $tax ] ) ) {
					foreach ( $result_filter[ $tax ] as $term_data ) {
							$selected = '';
						if ( 'car_mileage' !== $tax ) {
							if ( isset( $_GET[ $tax ] ) && '' !== $_GET[ $tax ] ) {
								if ( $_GET[ $tax ] === $term_data['slug'] ) {
									$selected = "selected='selected'";
								}
							}

							if ( ! in_array( $term_data['slug'], $newarr ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
								$attributs .= '<option value="' . $term_data['slug'] . '" ' . $selected . '>' . $term_data['name'] . '</option>';
								$newarr[]   = $term_data['slug'];
							}
						} else {

							$mileage_array = jws_get_mileage_array();
							if ( 'car_mileage' === $tax && 1 === $t ) {
								foreach ( $mileage_array as $mileage ) {
									$selected = '';
									if ( isset( $_GET['car_mileage'] ) && $_GET['car_mileage'] === $mileage ) {
										$selected = "selected=''";
									}
									$attributs .= '<option value="' . esc_attr( $mileage ) . '" ' . esc_attr( $selected ) . '>&lt; ' . esc_html( $mileage ) . '</option>';
								}
								$t++;
							}
						}
					}
				}
			} else {
				/** Here we set default terms list */
				$terms = get_terms(
					array(
						'taxonomy'   => $tax,
						'hide_empty' => true,
					)
				);

				foreach ( $terms as $tdata ) {
					if ( 'car_mileage' !== $tax ) {
						$selected = '';
						if ( isset( $_GET[ $tax ] ) && '' !== $_GET[ $tax ] ) {
							if ( $_GET[ $tax ] === $tdata->slug ) {
								$selected = "selected=''";
							}
						}
						$attributs .= '<option value="' . esc_attr( $tdata->slug ) . '" ' . esc_attr( $selected ) . '>' . esc_html( $tdata->name ) . '</option>';
					} else {

						$mileage_array = jws_get_mileage_array();
						if ( 'car_mileage' === $tax && 1 === $t ) {
							foreach ( $mileage_array as $mileage ) {
								$selected = '';
								if ( isset( $_GET['car_mileage'] ) && $_GET['car_mileage'] === $mileage ) {
									$selected = "selected=''";
								}
								$attributs .= '<option value="' . esc_attr( $mileage ) . '" ' . esc_attr( $selected ) . '>&lt; ' . esc_html( $mileage ) . '</option>';
							}
							$t++;
						}
					}
				}
			}
			$attributs .= '</select><div class="clear-value">';
                    
                	foreach ( $_GET as $gkey => $gval ) {
     
            			if ( in_array( $gkey, $taxonomys ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
            				$taxonomy_name = get_taxonomy( $gkey );
            				$label         = $taxonomy_name->labels->menu_name;
            				$term          = get_term_by( 'slug', $gval, $gkey );
                            if($gkey == $tax && !empty($gval)) {
                                if($is_year_range_active && $gkey == 'car_year') {
                                   $attributs    .= '';
                                }else{
                                   $attributs    .= '<span class="remove-cars-value" id="stripe-item-' . esc_attr( $gkey ) . '" data-type="' . esc_attr( $gkey ) . '"><a href="javascript:void(0)"><i class="jws-icon-icon_close-1"></i></a></span>';  
                                }  
                            }
            			}
            		}
            
            '</div></li>';  
            }
	
		}
        $attributs .= '</ul>';
        
        
		// Find min and max price in current result set.
		$pgs_min_price = isset( $_GET['min_price'] ) ? esc_attr( $_GET['min_price'] ) : '';
		$pgs_max_price = isset( $_GET['max_price'] ) ? esc_attr( $_GET['max_price'] ) : '';
		$prices        = ( function_exists( 'jws_get_car_filtered_price' ) ) ? jws_get_car_filtered_price() : '';
        $step = 100;
		$min           = floor( $prices->min_price );
		$max           = ceil( $prices->max_price );

		$attributs .= '<div class="price_slider_wrapper">';                		
			$attributs .= '<div class="price-slide">'; 
				$attributs .= '<div class="price">'; 
					if ( $min > 0 || $max > 0 ) { 
    					$attributs .= '<input type="hidden" id="pgs_min_price" name="min_price" value="'.esc_attr( $pgs_min_price ).'" data-min="'.esc_attr( $min ).'"/>';
    					$attributs .= '<input type="hidden" id="pgs_max_price" name="max_price" value="'.esc_attr( $pgs_max_price ).'" data-max="'.esc_attr( $max ).'" data-step="'.esc_attr( $step ).'"/>';
    
    					$attributs .= '<label for="dealer-slider-amount">'.esc_html__( 'Price Range', 'idealauto' ).'</label>';
    					$attributs .= '<input type="text" id="dealer-slider-amount" readonly class="amount" value="" />';
    					$attributs .= '<div id="slider-range"></div>';
				    }							
				$attributs .= '</div>';
			$attributs .= '</div>';
		$attributs .= '</div>'; 

        
		$attributs .= '<div class=""><a class="button" href="" id="reset_filters">' . esc_html__( 'Reset Filter', 'idealauto' ) . '</a></div>';
		$attributs .= '</div>';
		$attributs .= '</div>';
		return $attributs;
	}
}

if ( ! function_exists( 'jws_get_year_range_filters' ) ) :
	/**
	 * Year rang filter
	 *
	 * @param string $cfb .
	 */
	function jws_get_year_range_filters( $cfb = '' ) {
		$pgs_year_range_min = isset( $_GET['min_year'] ) ? sanitize_text_field( wp_unslash( $_GET['min_year'] ) ) : '';
		$pgs_year_range_max = isset( $_GET['max_year'] ) ? sanitize_text_field( wp_unslash( $_GET['max_year'] ) ) : '';

		// Find min and max price in current result set.
		$year_range = ( function_exists( 'jws_get_year_range' ) ) ? jws_get_year_range() : '';

		if ( empty( $year_range ) ) {
			return;
		}

		$yearmin = floor( $year_range['min_year'] );
		$yearmax = ceil( $year_range['max_year'] );

		if ( $yearmin === $yearmax ) {
			return;
		}
		$html          = '';
        $html .= '<li class="year-min-max">';
        $html .= '<span class="min">';
    		$html .= '<input type="number" id="pgs_year_range_min" class="sort_min_year" name="min_year" placeholder="'.esc_attr_x( 'Min year', 'placeholder', 'idealauto' ).'" value="' . esc_attr( $pgs_year_range_min ) . '" data-yearmin="' . esc_attr( $yearmin ) . '" />';
            $html .= '<div class="clear-value"></div>';
        $html .= '</span>';
        $html .= '<span class="max">';
    		$html .= '<input type="number" id="pgs_year_range_max" class="sort_max_year" name="max_year" placeholder="'.esc_attr_x( 'Max year', 'placeholder', 'idealauto' ).'" value="' . esc_attr( $pgs_year_range_max ) . '" data-yearmax="' . esc_attr( $yearmax ) . '" />';
            $html .= '<div class="clear-value"></div>';
        $html .= '</span>';
        $html .= '</li>';
		return apply_filters( 'jws_year_range_filters', $html );
	}
endif;


if ( ! function_exists( 'jws_get_cars_list_layout_style' ) ) {
	/**
	 * Add layout style in cookie
	 */
	function jws_get_cars_list_layout_style() {
		global $jws_option;

		// @codingStandardsIgnoreStart
		$getlayout = '';
		$getlayout = ( isset( $jws_option['cars-lay-style'] ) && ! empty( $jws_option['cars-lay-style'] ) ) ? $jws_option['cars-lay-style'] : 'view-grid';
		if ( isset( $_REQUEST['lay_style'] ) && ! empty( $_REQUEST['lay_style'] ) ) {
			$getlayout = $_REQUEST['lay_style']; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		} elseif ( isset( $_COOKIE['lay_style'] ) && ! empty( $_COOKIE['lay_style'] ) ) {
			$getlayout = $_COOKIE['lay_style']; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		}
		// @codingStandardsIgnoreEnd

		/**
		 * Filters the layout style option for inventory listing(grid/list).
		 *
		 * @since 1.0
		 * @param  string    $getlayout Layout style selected for vehicle listing.
		 * @hooked jws_list_layout_style_lazyload - 10
		 * @visible          true
		 */
		return apply_filters( 'jws_list_layout_style', $getlayout );
	}
}

if ( ! function_exists( 'jws_get_cars_catlog_style' ) ) {
	/**
	 * Catalog style
	 */
	function jws_get_cars_catlog_style() {
		$getlayout = jws_get_cars_list_layout_style();
		if ( isset( $getlayout ) ) {
			switch ( $getlayout ) {
				case 'view-grid':
					return 'yes';
				break;
				case 'view-list':
					return 'no';
				break;
			}
		}
	}
}

if ( ! function_exists( 'jws_get_default_sort_by' ) ) {
	/**
	 * Get default listing sort by dropdown option value
	 */
	function jws_get_default_sort_by() {
		global $jws_option;
		$cars_orderby = '';
		if ( isset( $jws_option['cars-default-sort-by'] ) ) {
			$cars_orderby = $jws_option['cars-default-sort-by'];
		}
		return $cars_orderby;
	}
}

if ( ! function_exists( 'jws_get_default_sort_by_order' ) ) {
	/**
	 * Get default listing order by value
	 */
	function jws_get_default_sort_by_order() {
		global $jws_option;
		$cars_order = 'desc';
		if ( isset( $jws_option['cars-default-sort-by-order'] ) ) {
			$cars_order = $jws_option['cars-default-sort-by-order'];
		}
		return $cars_order;
	}
}

if ( ! function_exists( 'jws_cars_catalog_ordering' ) ) :
	/**
	 * Catalog ordering
	 */
	function jws_cars_catalog_ordering() {
		global $wp,$jws_option;

		

		$cars_orderby_selected = jws_get_default_sort_by(); // get default option value.
		if ( isset( $_GET['cars_orderby'] ) && ! empty( $_GET['cars_orderby'] ) ) {
			$cars_orderby_selected = $_GET['cars_orderby'];
		}

		$cars_order_selected = jws_get_default_sort_by_order();// get default option value.
		if ( isset( $_GET['cars_order'] ) && ! empty( $_GET['cars_order'] ) && in_array( $_GET['cars_order'], array( 'desc', 'asc' ), true ) ) {
			$cars_order_selected = $_GET['cars_order'];
		}

	
		$jws_orderby_types = array(
			'name'       => esc_html__( 'Sort by Name', 'idealauto' ),
			'sale_price' => esc_html__( 'Sort by Price', 'idealauto' ),
			'date'       => esc_html__( 'Sort by Date', 'idealauto' ),
			'year'       => esc_html__( 'Sort by Year', 'idealauto' ),
            'mileage'       => esc_html__( 'Sort by Mileage', 'idealauto' ),

		);
		?>
       
		<div class="selected-box">
		
                <span class="text"><?php echo esc_html__('Sort by','idealauto'); ?></span>
				<select class="select-box" name="cars_orderby" id="pgs_cars_orderby">
					<option value=""><?php esc_html_e( 'Sort by Default', 'idealauto' ); ?></option>
					<?php
					foreach ( $jws_orderby_types as $jws_orderby_v => $jws_orderby_label ) {
						?>
						<option value="<?php echo esc_attr( $jws_orderby_v ); ?>" <?php selected( $cars_orderby_selected, $jws_orderby_v ); ?>><?php echo esc_html( $jws_orderby_label ); ?></option>
						<?php
					}
					?>
				</select>
		
		</div>
		<?php
		$desc = ( 'desc' === $cars_order_selected ) ? 'active' : '';
        $asc = ( 'asc' === $cars_order_selected ) ? 'active' : '';
    	?>
		  <div class="cars-order text-right">
            <a id="pgs_cars_order" class="<?php echo esc_attr($asc); ?>" data-order="desc" data-current_order="asc" href="javascript:void(0)"><i class="fas fa-arrow-up"></i></a>
            <a id="pgs_cars_order" class="<?php echo esc_attr($desc); ?>" data-order="asc" data-current_order="desc" href="javascript:void(0)"><i class="fas fa-arrow-down"></i></a>
          </div>
		<?php
	}
endif;

if ( ! function_exists( 'jws_cars_perpage' ) ) :
	/**
	 * Catalog ordering
	 */
	function jws_cars_perpage() { 
	   global $wp,$jws_option;

	
        $per_page_array = (isset($jws_option['cars-per-page']) && !empty($jws_option['cars-per-page'][0])) ? $jws_option['cars-per-page'] : array('9','12','18','24');
        $cars_pp_selected = ( isset( $_GET['cars_pp'] ) && ! empty( $_GET['cars_pp'] ) ) ? $_GET['cars_pp'] : '';
        	
		?>
		<div class="selected-box">
             <?php if ( is_post_type_archive( 'cars' ) ) { ?>  
                 <a class="toggle-cars-sidebar" href="javascript:void(0)">
                     <i class="jws-icon-005-list"></i>
                 </a> 
            <?php } ?>   
            
            <span class="pgs_cars_pp_wap">
                <span class="text"><?php echo esc_html__('Show on page','idealauto'); ?></span>
    			<select name="cars_pp" id="pgs_cars_pp">
    				<?php
    				foreach ($per_page_array as & $per_page_value) {
    				
    					?>
    					<option value="<?php echo esc_html( $per_page_value ); ?>" <?php selected( $cars_pp_selected, $per_page_value ); ?>><?php echo esc_html( $per_page_value ).esc_html__(' cars','idealauto'); ?></option>
    					<?php
    				}
    				?>
    			</select>
            </span>
		</div>
		<?php
	}
endif;    
    

if ( ! function_exists( 'jws_get_catlog_view' ) ) {
	/**
	 * Catlog view
	 */
	function jws_get_catlog_view() {
		$cars_grid = isset( $_COOKIE['cars_grid'] ) ? sanitize_text_field( wp_unslash( $_COOKIE['cars_grid'] ) ) : 1;
		$grid_sel  = ( 1 === $cars_grid ) ? 'sel-active' : '';
		$list_sel  = ( 0 === $cars_grid ) ? 'sel-active' : '';
		global $jws_option;
		$theme_color = isset( $jws_option['site_color_scheme_custom']['color'] ) ? $jws_option['site_color_scheme_custom']['color'] : '';

		$getlayout        = jws_get_cars_list_layout_style();
		$list_view_layout = array(
			'view-grid',
			'view-list',
		);
		$layout_css_style = array();
		foreach ( $list_view_layout as $key => $value ) {
			$layout_css_style[ $key ] = ( $getlayout === $value ) ? "sel-active" : '';
		}
		?>
		<div class="grid-view change-view-button">
			<div class="view-icon">
				<a class="change-layout view-grid <?php echo esc_attr( $layout_css_style[0] ); ?>" data-id="view-grid" href="javascript:void(0)">
                <span>
                    <i class="jws-icon-004-grid"></i>
                </span>
                </a>
                <a class="change-layout view-list <?php echo esc_attr( $layout_css_style[1] ); ?>" data-id="view-list" href="javascript:void(0)">
                <span>
                    <i class="jws-icon-005-list"></i>
                </span>
                </a>
			</div>
		</div><!--.grid-view-->
		<?php
	}
}
if ( ! function_exists( 'jws_get_vehicles_taxonomies' ) ) {
	/**
	 * Get car gurubad
	 *
	 * @param array $taxonomies_unset .
	 * @param array $return_array_type .
	 */
	function jws_get_vehicles_taxonomies( $taxonomies_unset = array(), $return_array_type = 'val_to_key' ) {
		if ( ! empty( $taxonomies_unset ) ) {
			$unset_taxonomies = $taxonomies_unset;
		} else {
			$unset_taxonomies = array( 'car_features_options' );
		}
		$taxonomies = get_object_taxonomies( 'cars' );
		foreach ( $unset_taxonomies as $taxo ) {
			if ( array_search( $taxo, $taxonomies ) !== false ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
				$key = array_search( $taxo, $taxonomies ); // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
				unset( $taxonomies[ $key ] );
			}
		}
		$taxonomy_array = array();
		if ( 'val_to_key' === $return_array_type ) { // array( taxonomy_label => taxonomy_key ).
			foreach ( $taxonomies as $taxonomy ) {
				$tax_obj                           = get_taxonomy( $taxonomy );
				$taxonomy_array[ $tax_obj->label ] = $taxonomy;
			}
		} else { // array( taxonomy_key => taxonomy_label ).
			foreach ( $taxonomies as $taxonomy ) {
				$tax_obj                     = get_taxonomy( $taxonomy );
				$taxonomy_array[ $taxonomy ] = $tax_obj->label;
			}
		}
		/**
		 * Filters the vehicle taxonomy array .
		 *
		 * @since 1.0
		 *
		 * @param array    $taxonomy_array   A list of taxonomies with taxonomy slug to taxonomy label pair.
		 * @visible        true
		 */
		return apply_filters( 'jws_vehicles_taxonomies', $taxonomy_array );
	}
}
if ( ! function_exists( 'jws_cars_get_catalog_ordering_args' ) ) {
	/**
	 * Pass arguments on cars listing page
	 *
	 * @param array $wp_query get the value.
	 */
	function jws_cars_get_catalog_ordering_args( $wp_query ) {
   
		global $wp_query,$jws_option;
		$taxonomies   = jws_get_vehicles_taxonomies();
		$taxonomies   = array_values( $taxonomies );
		$current_term = $wp_query->get_queried_object();

		$cars_inventory_page = ( isset( $jws_option['cars_inventory_page'] ) ) ? $jws_option['cars_inventory_page'] : '';

		if ( ( ! is_admin() && $wp_query->is_main_query() && is_post_type_archive( 'cars' ) ) || ( $wp_query->is_page() && 'page' === get_option( 'show_on_front' ) && '' !== $cars_inventory_page && absint( $wp_query->get( 'page_id' ) ) === absint( $cars_inventory_page ) ) || ( is_tax() && ( isset( $current_term->taxonomy ) && in_array( $current_term->taxonomy, $taxonomies ) ) ) ) { // phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
			$wp_query->set( 'page_id', '' );
			$wp_query->is_singular          = false;
			$wp_query->is_post_type_archive = true;
			$wp_query->bis_archive          = true;
			$wp_query->is_page              = false;

			$pgs_min_price = isset( $_GET['min_price'] ) ? esc_attr( $_GET['min_price'] ) : 0;
			$pgs_max_price = isset( $_GET['max_price'] ) ? esc_attr( $_GET['max_price'] ) : 0;
			if ( $pgs_min_price > 0 || $pgs_max_price > 0 ) {
				$prices = jws_get_car_filtered_price();
				$min    = floor( $prices->min_price );
				$max    = ceil( $prices->max_price );

				if ( $min !== $pgs_min_price || $max !== $pgs_max_price ) {
					$args['meta_query'][] = array(
						'key'     => 'final_price',
						'value'   => array( $pgs_min_price, $pgs_max_price ),
						'compare' => 'BETWEEN',
						'type'    => 'NUMERIC',
					);
				}
			}
			/* Don't want to show sold car on car listing page */
			if ( isset( $jws_option['car_no_sold'] ) && 1 === (int) $jws_option['car_no_sold'] && ! is_admin() ) {
				$args['meta_query'][] =
					array(
						'key'     => 'car_status',
						'value'   => 'sold',
						'compare' => '!=',
					);

			}

			if ( isset( $_GET['vehicle_location'] ) && ! empty( $_GET['vehicle_location'] ) ) {
				$args['meta_query'][] = array(
					'key'     => 'vehicle_location',
					'value'   => $_GET['vehicle_location'],
					'compare' => 'LIKE',
				);
			}
            
            
            if ( isset( $_GET['car_mileage'] ) && ! empty( $_GET['car_mileage'] ) ) {

				$mileage_terms   = array();
				$get_car_mileage = $_GET['car_mileage'];
				$terms           = get_terms(
					array(
						'taxonomy'   => 'car_mileage',
						'hide_empty' => true,
					)
				);
				foreach ( $terms as $tdata ) {
					$mileage = $tdata->slug;
            
					if ( is_numeric( $mileage ) && is_numeric( $get_car_mileage ) ) {
						if ( $mileage < $get_car_mileage ) {
							$mileage_terms[] = $tdata->term_id;
						}
					}
				}
				if ( ! empty( $mileage_terms ) ) {

                 

					$car_mileage_args = array(
						array(
							'taxonomy' => 'car_mileage',
							'field'    => 'id',
							'terms'    => $mileage_terms,
						),
					);
					unset( $wp_query->query_vars['car_mileage'] );
                    $wp_query->set( 'tax_query', $car_mileage_args );
				}
			}
            
         

			/* Set meta query*/
			if ( ! empty( $args['meta_query'] ) ) {
				$wp_query->set( 'meta_query', $args['meta_query'] );
			}

			/* Check Year range option enable from backend */

				$year_range    = jws_get_year_range();
				$yearmin       = isset( $year_range['min_year'] ) ? $year_range['min_year'] : '';
				$yearmax       = isset( $year_range['max_year'] ) ? $year_range['max_year'] : '';
				$pgs_min_year  = isset( $_GET['min_year'] ) ? esc_attr( $_GET['min_year'] ) : 0;
				$pgs_max_year  = isset( $_GET['max_year'] ) && !empty( $_GET['max_year']) ? esc_attr( $_GET['max_year'] ) : $yearmax; 
				$year_rang_qur = array();
				if ( ! empty( $year_range ) && ( $pgs_min_year > 0 || $pgs_max_year > 0 ) ) {
					if ( $yearmin !== $pgs_min_year || $yearmax !== $pgs_max_year ) {
						$terms   = get_terms(
							array(
								'taxonomy'   => 'car_year',
								'hide_empty' => true,
							)
						);
						$quryear = array();
						if ( ! empty( $terms ) ) {
							foreach ( $terms as $tdata ) {
								if ( ( $tdata->slug >= $pgs_min_year ) && ( $tdata->slug <= $pgs_max_year ) ) {
									$quryear[] = $tdata->slug;
								}
							}
						}
               
						$year_rang_qur                = array( 'relation' => 'AND' );
						$year_rang_qur['tax_query'][] = array(
							'taxonomy' => 'car_year',
							'field'    => 'slug',
							'terms'    => $quryear,
						);
						$wp_query->set( 'tax_query', $year_rang_qur );

					}
				}  
		
  
		
			$wp_query->set( 'post_type', array( 'cars' ) );

			$pob = jws_get_default_sort_by();// get default option value.
			if ( isset( $_GET['cars_orderby'] ) && ! empty( $_GET['cars_orderby'] ) ) {
				$pob = $_GET['cars_orderby'];
			}

			$order = jws_get_default_sort_by_order();// get default option value.
			if ( isset( $_GET['cars_order'] ) && ! empty( $_GET['cars_order'] ) && in_array( $_GET['cars_order'], array( 'desc', 'asc' ), true ) ) {
				$order = $_GET['cars_order'];
			}
			switch ( $pob ) {
				case 'name':
					$orderby = 'title';
					break;
				case 'sale_price':
					$orderby = 'meta_value_num';
					$wp_query->set( 'meta_key', 'final_price' );
					$wp_query->set( 'type', 'NUMERIC' );
					break;
				case 'year':
					$orderby = 'year';
					break;
                case 'mileage':
					$orderby = 'mileage';
					break;     
				case 'date':
					$orderby = 'date (post_date)';
					break;
				default:
					$orderby = 'date (post_date)';
					break;
			}
			$wp_query->set( 'orderby', $orderby );
			$wp_query->set( 'order', $order );

			/* set number of car on car listing page */
			if ( isset( $_GET['cars_pp'] ) && ! empty( $_GET['cars_pp'] ) ) {
				$per_page = $_GET['cars_pp'];
			} elseif ( isset( $jws_option['cars-per-page'] ) && ! empty( $jws_option['cars-per-page'][0] ) ) {
				$per_page = $jws_option['cars-per-page'][0];
			} else {
				$per_page = 9;
			}

			$wp_query->set( 'posts_per_page', $per_page );

		}
	}
	add_action( 'pre_get_posts', 'jws_cars_get_catalog_ordering_args' );
}
if ( ! function_exists( 'orderby_car_year_qur' ) ) {
	/**
	 * Year qur
	 *
	 * @param string $orderby set orderby.
	 * @param array  $wp_query get the value.
	 */
	function orderby_car_year_qur( $orderby, $wp_query ) {
		global $wpdb;
		if ( isset( $wp_query->query_vars['orderby'] ) && 'year' === $wp_query->query_vars['orderby'] ) {
			$orderby  = "(
				SELECT GROUP_CONCAT(name ORDER BY name ASC)
				FROM $wpdb->term_relationships
				INNER JOIN $wpdb->term_taxonomy USING (term_taxonomy_id)
				INNER JOIN $wpdb->terms USING (term_id)
				WHERE $wpdb->posts.ID = object_id
				AND taxonomy = 'car_year'
				GROUP BY object_id
			) ";
			$orderby .= ( 'ASC' === strtoupper( $wp_query->get( 'order' ) ) ) ? 'ASC' : 'DESC';
		}
		return $orderby;
	}
	/**
	 * Filter for add custom subquery for year wise sorting order in car listing page
	 */
	add_filter( 'posts_orderby', 'orderby_car_year_qur', 10, 2 );
}


if ( ! function_exists( 'orderby_car_mileage_qur' ) ) {
    
	/**
	 * mileage qur
	 *
	 * @param string $orderby set orderby.
	 * @param array  $wp_query get the value.
	 */
     
    function orderby_car_mileage_qur($orderby, $wp_query) {
        global $wpdb;
    
        if (isset($wp_query->query_vars['orderby']) && 'mileage' === $wp_query->query_vars['orderby']) {
            $orderby = "(
                SELECT MAX(CASE
                    WHEN name = '0' THEN 0
                    ELSE CAST(name AS UNSIGNED)
                    END) AS mileage_value
                FROM $wpdb->term_relationships
                INNER JOIN $wpdb->term_taxonomy USING (term_taxonomy_id)
                INNER JOIN $wpdb->terms USING (term_id)
                WHERE $wpdb->posts.ID = object_id
                AND taxonomy = 'car_mileage'
                GROUP BY object_id
            ) ";
            $orderby .= ('ASC' === strtoupper($wp_query->get('order'))) ? 'ASC' : 'DESC';
        }
        return $orderby;
    }
    
    /**
     * Filter for adding custom subquery for mileage wise sorting order in car listing page
     */
    add_filter('posts_orderby', 'orderby_car_mileage_qur', 10, 2);
}

if ( ! function_exists( 'jws_currencie_list' ) ) {
	/**
	 * Get currency list.
	 */
	function jws_currencie_list() {
		return array_unique(
			apply_filters(
				'jws_currencie_list',
				array(
					'AED' => esc_html__( 'United Arab Emirates dirham', 'idealauto' ),
					'AFN' => esc_html__( 'Afghan afghani', 'idealauto' ),
					'ALL' => esc_html__( 'Albanian lek', 'idealauto' ),
					'AMD' => esc_html__( 'Armenian dram', 'idealauto' ),
					'ANG' => esc_html__( 'Netherlands Antillean guilder', 'idealauto' ),
					'AOA' => esc_html__( 'Angolan kwanza', 'idealauto' ),
					'ARS' => esc_html__( 'Argentine peso', 'idealauto' ),
					'AUD' => esc_html__( 'Australian dollar', 'idealauto' ),
					'AWG' => esc_html__( 'Aruban florin', 'idealauto' ),
					'AZN' => esc_html__( 'Azerbaijani manat', 'idealauto' ),
					'BAM' => esc_html__( 'Bosnia and Herzegovina convertible mark', 'idealauto' ),
					'BBD' => esc_html__( 'Barbadian dollar', 'idealauto' ),
					'BDT' => esc_html__( 'Bangladeshi taka', 'idealauto' ),
					'BGN' => esc_html__( 'Bulgarian lev', 'idealauto' ),
					'BHD' => esc_html__( 'Bahraini dinar', 'idealauto' ),
					'BIF' => esc_html__( 'Burundian franc', 'idealauto' ),
					'BMD' => esc_html__( 'Bermudian dollar', 'idealauto' ),
					'BND' => esc_html__( 'Brunei dollar', 'idealauto' ),
					'BOB' => esc_html__( 'Bolivian boliviano', 'idealauto' ),
					'BRL' => esc_html__( 'Brazilian real', 'idealauto' ),
					'BSD' => esc_html__( 'Bahamian dollar', 'idealauto' ),
					'BTC' => esc_html__( 'Bitcoin', 'idealauto' ),
					'BTN' => esc_html__( 'Bhutanese ngultrum', 'idealauto' ),
					'BWP' => esc_html__( 'Botswana pula', 'idealauto' ),
					'BYR' => esc_html__( 'Belarusian ruble', 'idealauto' ),
					'BZD' => esc_html__( 'Belize dollar', 'idealauto' ),
					'CAD' => esc_html__( 'Canadian dollar', 'idealauto' ),
					'CDF' => esc_html__( 'Congolese franc', 'idealauto' ),
					'CHF' => esc_html__( 'Swiss franc', 'idealauto' ),
					'CLP' => esc_html__( 'Chilean peso', 'idealauto' ),
					'CNY' => esc_html__( 'Chinese yuan', 'idealauto' ),
					'COP' => esc_html__( 'Colombian peso', 'idealauto' ),
					'CRC' => esc_html__( 'Costa Rican col&oacute;n', 'idealauto' ),
					'CUC' => esc_html__( 'Cuban convertible peso', 'idealauto' ),
					'CUP' => esc_html__( 'Cuban peso', 'idealauto' ),
					'CVE' => esc_html__( 'Cape Verdean escudo', 'idealauto' ),
					'CZK' => esc_html__( 'Czech koruna', 'idealauto' ),
					'DJF' => esc_html__( 'Djiboutian franc', 'idealauto' ),
					'DKK' => esc_html__( 'Danish krone', 'idealauto' ),
					'DOP' => esc_html__( 'Dominican peso', 'idealauto' ),
					'DZD' => esc_html__( 'Algerian dinar', 'idealauto' ),
					'EGP' => esc_html__( 'Egyptian pound', 'idealauto' ),
					'ERN' => esc_html__( 'Eritrean nakfa', 'idealauto' ),
					'ETB' => esc_html__( 'Ethiopian birr', 'idealauto' ),
					'EUR' => esc_html__( 'Euro', 'idealauto' ),
					'FJD' => esc_html__( 'Fijian dollar', 'idealauto' ),
					'FKP' => esc_html__( 'Falkland Islands pound', 'idealauto' ),
					'GBP' => esc_html__( 'Pound sterling', 'idealauto' ),
					'GEL' => esc_html__( 'Georgian lari', 'idealauto' ),
					'GGP' => esc_html__( 'Guernsey pound', 'idealauto' ),
					'GHS' => esc_html__( 'Ghana cedi', 'idealauto' ),
					'GIP' => esc_html__( 'Gibraltar pound', 'idealauto' ),
					'GMD' => esc_html__( 'Gambian dalasi', 'idealauto' ),
					'GNF' => esc_html__( 'Guinean franc', 'idealauto' ),
					'GTQ' => esc_html__( 'Guatemalan quetzal', 'idealauto' ),
					'GYD' => esc_html__( 'Guyanese dollar', 'idealauto' ),
					'HKD' => esc_html__( 'Hong Kong dollar', 'idealauto' ),
					'HNL' => esc_html__( 'Honduran lempira', 'idealauto' ),
					'HRK' => esc_html__( 'Croatian kuna', 'idealauto' ),
					'HTG' => esc_html__( 'Haitian gourde', 'idealauto' ),
					'HUF' => esc_html__( 'Hungarian forint', 'idealauto' ),
					'IDR' => esc_html__( 'Indonesian rupiah', 'idealauto' ),
					'ILS' => esc_html__( 'Israeli new shekel', 'idealauto' ),
					'IMP' => esc_html__( 'Manx pound', 'idealauto' ),
					'INR' => esc_html__( 'Indian rupee', 'idealauto' ),
					'IQD' => esc_html__( 'Iraqi dinar', 'idealauto' ),
					'IRR' => esc_html__( 'Iranian rial', 'idealauto' ),
					'IRT' => esc_html__( 'Iranian toman', 'idealauto' ),
					'ISK' => esc_html__( 'Icelandic kr&oacute;na', 'idealauto' ),
					'JEP' => esc_html__( 'Jersey pound', 'idealauto' ),
					'JMD' => esc_html__( 'Jamaican dollar', 'idealauto' ),
					'JOD' => esc_html__( 'Jordanian dinar', 'idealauto' ),
					'JPY' => esc_html__( 'Japanese yen', 'idealauto' ),
					'KES' => esc_html__( 'Kenyan shilling', 'idealauto' ),
					'KGS' => esc_html__( 'Kyrgyzstani som', 'idealauto' ),
					'KHR' => esc_html__( 'Cambodian riel', 'idealauto' ),
					'KMF' => esc_html__( 'Comorian franc', 'idealauto' ),
					'KPW' => esc_html__( 'North Korean won', 'idealauto' ),
					'KRW' => esc_html__( 'South Korean won', 'idealauto' ),
					'KWD' => esc_html__( 'Kuwaiti dinar', 'idealauto' ),
					'KYD' => esc_html__( 'Cayman Islands dollar', 'idealauto' ),
					'KZT' => esc_html__( 'Kazakhstani tenge', 'idealauto' ),
					'LAK' => esc_html__( 'Lao kip', 'idealauto' ),
					'LBP' => esc_html__( 'Lebanese pound', 'idealauto' ),
					'LKR' => esc_html__( 'Sri Lankan rupee', 'idealauto' ),
					'LRD' => esc_html__( 'Liberian dollar', 'idealauto' ),
					'LSL' => esc_html__( 'Lesotho loti', 'idealauto' ),
					'LYD' => esc_html__( 'Libyan dinar', 'idealauto' ),
					'MAD' => esc_html__( 'Moroccan dirham', 'idealauto' ),
					'MDL' => esc_html__( 'Moldovan leu', 'idealauto' ),
					'MGA' => esc_html__( 'Malagasy ariary', 'idealauto' ),
					'MKD' => esc_html__( 'Macedonian denar', 'idealauto' ),
					'MMK' => esc_html__( 'Burmese kyat', 'idealauto' ),
					'MNT' => esc_html__( 'Mongolian t&ouml;gr&ouml;g', 'idealauto' ),
					'MOP' => esc_html__( 'Macanese pataca', 'idealauto' ),
					'MRO' => esc_html__( 'Mauritanian ouguiya', 'idealauto' ),
					'MUR' => esc_html__( 'Mauritian rupee', 'idealauto' ),
					'MVR' => esc_html__( 'Maldivian rufiyaa', 'idealauto' ),
					'MWK' => esc_html__( 'Malawian kwacha', 'idealauto' ),
					'MXN' => esc_html__( 'Mexican peso', 'idealauto' ),
					'MYR' => esc_html__( 'Malaysian ringgit', 'idealauto' ),
					'MZN' => esc_html__( 'Mozambican metical', 'idealauto' ),
					'NAD' => esc_html__( 'Namibian dollar', 'idealauto' ),
					'NGN' => esc_html__( 'Nigerian naira', 'idealauto' ),
					'NIO' => esc_html__( 'Nicaraguan c&oacute;rdoba', 'idealauto' ),
					'NOK' => esc_html__( 'Norwegian krone', 'idealauto' ),
					'NPR' => esc_html__( 'Nepalese rupee', 'idealauto' ),
					'NZD' => esc_html__( 'New Zealand dollar', 'idealauto' ),
					'OMR' => esc_html__( 'Omani rial', 'idealauto' ),
					'PAB' => esc_html__( 'Panamanian balboa', 'idealauto' ),
					'PEN' => esc_html__( 'Peruvian nuevo sol', 'idealauto' ),
					'PGK' => esc_html__( 'Papua New Guinean kina', 'idealauto' ),
					'PHP' => esc_html__( 'Philippine peso', 'idealauto' ),
					'PKR' => esc_html__( 'Pakistani rupee', 'idealauto' ),
					'PLN' => esc_html__( 'Polish z&#x142;oty', 'idealauto' ),
					'PRB' => esc_html__( 'Transnistrian ruble', 'idealauto' ),
					'PYG' => esc_html__( 'Paraguayan guaran&iacute;', 'idealauto' ),
					'QAR' => esc_html__( 'Qatari riyal', 'idealauto' ),
					'RON' => esc_html__( 'Romanian leu', 'idealauto' ),
					'RSD' => esc_html__( 'Serbian dinar', 'idealauto' ),
					'RUB' => esc_html__( 'Russian ruble', 'idealauto' ),
					'RWF' => esc_html__( 'Rwandan franc', 'idealauto' ),
					'SAR' => esc_html__( 'Saudi riyal', 'idealauto' ),
					'SBD' => esc_html__( 'Solomon Islands dollar', 'idealauto' ),
					'SCR' => esc_html__( 'Seychellois rupee', 'idealauto' ),
					'SDG' => esc_html__( 'Sudanese pound', 'idealauto' ),
					'SEK' => esc_html__( 'Swedish krona', 'idealauto' ),
					'SGD' => esc_html__( 'Singapore dollar', 'idealauto' ),
					'SHP' => esc_html__( 'Saint Helena pound', 'idealauto' ),
					'SLL' => esc_html__( 'Sierra Leonean leone', 'idealauto' ),
					'SOS' => esc_html__( 'Somali shilling', 'idealauto' ),
					'SRD' => esc_html__( 'Surinamese dollar', 'idealauto' ),
					'SSP' => esc_html__( 'South Sudanese pound', 'idealauto' ),
					'STD' => esc_html__( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'idealauto' ),
					'SYP' => esc_html__( 'Syrian pound', 'idealauto' ),
					'SZL' => esc_html__( 'Swazi lilangeni', 'idealauto' ),
					'THB' => esc_html__( 'Thai baht', 'idealauto' ),
					'TJS' => esc_html__( 'Tajikistani somoni', 'idealauto' ),
					'TMT' => esc_html__( 'Turkmenistan manat', 'idealauto' ),
					'TND' => esc_html__( 'Tunisian dinar', 'idealauto' ),
					'TOP' => esc_html__( 'Tongan pa&#x2bb;anga', 'idealauto' ),
					'TRY' => esc_html__( 'Turkish lira', 'idealauto' ),
					'TTD' => esc_html__( 'Trinidad and Tobago dollar', 'idealauto' ),
					'TWD' => esc_html__( 'New Taiwan dollar', 'idealauto' ),
					'TZS' => esc_html__( 'Tanzanian shilling', 'idealauto' ),
					'UAH' => esc_html__( 'Ukrainian hryvnia', 'idealauto' ),
					'UGX' => esc_html__( 'Ugandan shilling', 'idealauto' ),
					'USD' => esc_html__( 'United States dollar', 'idealauto' ),
					'UYU' => esc_html__( 'Uruguayan peso', 'idealauto' ),
					'UZS' => esc_html__( 'Uzbekistani som', 'idealauto' ),
					'VEF' => esc_html__( 'Venezuelan bol&iacute;var', 'idealauto' ),
					'VND' => esc_html__( 'Vietnamese &#x111;&#x1ed3;ng', 'idealauto' ),
					'VUV' => esc_html__( 'Vanuatu vatu', 'idealauto' ),
					'WST' => esc_html__( 'Samoan t&#x101;l&#x101;', 'idealauto' ),
					'XAF' => esc_html__( 'Central African CFA franc', 'idealauto' ),
					'XCD' => esc_html__( 'East Caribbean dollar', 'idealauto' ),
					'XOF' => esc_html__( 'West African CFA franc', 'idealauto' ),
					'XPF' => esc_html__( 'CFP franc', 'idealauto' ),
					'YER' => esc_html__( 'Yemeni rial', 'idealauto' ),
					'ZAR' => esc_html__( 'South African rand', 'idealauto' ),
					'ZMW' => esc_html__( 'Zambian kwacha', 'idealauto' ),
				)
			)
		);
	}
}

if ( ! function_exists( 'jws_get_currency_symbols' ) ) {
	/**
	 * Get currency symbols.
	 *
	 * @param array $currency_code variable.
	 */
	function jws_get_currency_symbols( $currency_code ) {
		$currency_symbols = array(
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => 'Afl.',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x10da;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => '&#36;',
			'HNL' => 'L',
			'HRK' => 'Kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => 'KZT',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => '&#xdbb;&#xdd4;',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'P',
			'MRO' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => '&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#x434;&#x438;&#x43d;.',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STD' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'Fr',
			'XCD' => '&#36;',
			'XOF' => 'Fr',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		);
		$currencysymbols  = apply_filters( 'jws_get_currency_symbols', $currency_symbols );

		$currency_symbol = isset( $currency_symbols[ $currency_code ] ) ? $currency_symbols[ $currency_code ] : $currency_code;

		return apply_filters( 'jws_get_currency_symbol', $currency_symbol, $currency_code );
	}
}

if ( ! function_exists( 'jws_currency_option_list' ) ) {
	/**
	 * Get currency options list.
	 */
	function jws_currency_option_list() {
		$jws_currencie_list = jws_currencie_list();
		$currencie_list      = array();
		foreach ( $jws_currencie_list as $code => $name ) {
			$currencie_list[ $code ] = $name . ' (' . jws_get_currency_symbols( $code ) . ')';
		}
		return $currencie_list;
	}
}

if ( ! function_exists( 'jws_get_images_url' ) ) {
	/**
	 * Image url
	 *
	 * @param string $car_size .
	 * @param string $id .
	 */
	function jws_get_images_url( $car_size = 'car_catalog_image', $id = null ) {
		global $post;
		$url = null;
	
			if ( isset( $id ) && ! empty( $id ) ) {
				$car_id = $id;
			} elseif ( isset( $post ) ) {
				$car_id = $post->ID;
			}
			$car_images = get_post_meta( $car_id , 'car_images',  true );
			$url        = array();
			if ( ! empty( $car_images ) ) {
				foreach ( $car_images as $car_image ) {
					$url[] = wp_get_attachment_url( $car_image );
				}
			}
		
		return $url;
	}
}



if ( ! function_exists( 'jws_validate_google_captch' ) ) {
	/**
	 * Validate google captch.
	 *
	 * @param string $captcha .
	 */
	function jws_validate_google_captch( $captcha ) {
		$secret_key = jws_get_goole_api_keys( 'secret_key' );
		if ( empty( $secret_key ) ) {
			return array( 'success' => true );
		}
		$response = array();

		if ( function_exists('ct_sv') &&  isset( ct_sv()['REMOTE_ADDR'] ) ) {
			$response = wp_remote_get( 'https://www.google.com/recaptcha/api/siteverify?secret=' . $secret_key . '&response=' . $captcha . '&remoteip=' . sanitize_text_field( wp_unslash( ct_sv()['REMOTE_ADDR'] ) ), array( 'timeout' => 30 ) );
		}

		if ( ! empty( $response ) && isset( $response['body'] ) ) {
			return json_decode( $response['body'], true );
		} else {
			return array( 'success' => false );
		}
	}
}

if ( ! function_exists( 'jws_get_goole_api_keys' ) ) {
	/**
	 * Get google api
	 *
	 * @param string $key_type .
	 */
	function jws_get_goole_api_keys( $key_type = '' ) {
		global $jws_option;
		if ( 'site_key' === $key_type ) {
			$key = ( isset( $jws_option['google_captcha_site_key'] ) && ! empty( $jws_option['google_captcha_site_key'] ) ) ? $jws_option['google_captcha_site_key'] : '';
		}
		if ( 'secret_key' === $key_type ) {
			$key = ( isset( $jws_option['google_captcha_secret_key'] ) && ! empty( $jws_option['google_captcha_secret_key'] ) ) ? $jws_option['google_captcha_secret_key'] : '';
		}
		return $key;
	}
}


if( ! function_exists( 'jws_ajax_load_car_form_contact' ) ) {
    	function jws_ajax_load_car_form_contact($type = 'contact') {
    	      
            if( isset($_GET['type']) ) {
            	$type = $_GET['type'];
            }
            
            if($type == 'test') {
                get_template_part( 'template-parts/content/cars/form/test-drive-form' );
            }elseif($type == 'quote') {
                get_template_part( 'template-parts/content/cars/form/quote-form' );
            }elseif($type == 'offer') {
                get_template_part( 'template-parts/content/cars/form/offer-form' );
            }elseif($type == 'availability') {
                get_template_part( 'template-parts/content/cars/form/availability-form' );
            }elseif($type == 'contact'){
               get_template_part( 'template-parts/content/cars/form/contact-form' ); 
            }elseif($type == 'request'){
               get_template_part( 'template-parts/content/cars/form/request-form' ); 
            }
 
    		die();
    	}
        // Note: Keep default AJAX actions in case WooCommerce endpoint URL is unavailable
        add_action('wp_ajax_jws_ajax_load_car_form_contact', 'jws_ajax_load_car_form_contact');
        add_action('wp_ajax_nopriv_jws_ajax_load_car_form_contact', 'jws_ajax_load_car_form_contact'); 
}   






function tiny_mce_add_buttons( $plugins ) {
  $plugins['myaccordionbtn'] = get_template_directory_uri() . '/assets/js/tiny-mce/tiny-mce.js';
  return $plugins;
}

function tiny_mce_register_buttons( $buttons ) {
 	array_push($buttons, 'myaccordionbtn');

		return $buttons;
}


//add_filter( 'mce_external_plugins', 'tiny_mce_add_buttons' );
//add_filter( 'mce_buttons', 'tiny_mce_register_buttons' );  
  
if( ! function_exists( 'jws_inventory_label' ) ) {
	function jws_inventory_label() {

		if ( get_post_meta( get_the_ID(), 'car_asset_type', true ) == 'featured') {
			echo '<span class="featured jws-car-label">' . esc_html__( 'Special', 'idealauto' ) . '</span>';
		}
	}
}
