<?php
    /**
     * ReduxFramework Theme Config File
     * For full documentation, please visit: https://docs.reduxframework.com
     * */

    if ( ! class_exists( 'Redux_Framework_theme_config' ) ) {

        class Redux_Framework_theme_config {

            public $args = array();
            public $sections = array();
            public $theme;
            public $ReduxFramework;

            public function __construct() {

                if ( ! class_exists( 'ReduxFramework' ) ) {
                    return;
                }

                // This is needed. Bah WordPress bugs.  ;)
                if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
                    $this->initSettings();
                } else {
                    add_action( 'plugins_loaded', array( $this, 'initSettings' ), 10 );
                }
		

            }

            public function initSettings() {

                // Just for demo purposes. Not needed per say.
                $this->theme = wp_get_theme();

                // Set the default arguments
                $this->setArguments();

                // Set a few help tabs so you can see how it's done
         

                // Create the sections and fields
                $this->setSections();

                if ( ! isset( $this->args['opt_name'] ) ) { // No errors please
                    return;
                }


                $this->ReduxFramework = new ReduxFramework( $this->sections, $this->args );
            }

            /**
             * This is a test function that will let you see when the compiler hook occurs.
             * It only runs if a field    set with compiler=>true is changed.
             * */
            function compiler_action( $options, $css, $changed_values ) {
                echo '<h1>The compiler hook has run!</h1>';
                echo "<pre>";
                print_r( $changed_values ); // Values that have changed since the last save
                echo "</pre>";
            }

            /**
             * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
             * Simply include this function in the child themes functions.php file.
             * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
             * so you must use get_template_directory_uri() if you want to use any of the built in icons
             * */
            function dynamic_section( $sections ) {
                //$sections = array();
                $sections[] = array(
                    'title'  => __( 'Section via hook', 'idealauto' ),
                    'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'idealauto' ),
                    'icon'   => 'el-icon-paper-clip',
                    // Leave this as a blank section, no options just some intro text set above.
                    'fields' => array()
                );

                return $sections;
            }

            /**
             * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
             * */
            function change_arguments( $args ) {
                //$args['dev_mode'] = true;

                return $args;
            }

            /**
             * Filter hook for filtering the default value of any given field. Very useful in development mode.
             * */
            function change_defaults( $defaults ) {
                $defaults['str_replace'] = 'Testing filter hook!';

                return $defaults;
            }

            // Remove the demo link and the notice of integrated demo from the redux-framework plugin
            function remove_demo() {

                // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
                if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                    // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                    remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
                }
            }

            public function setSections() {

                /**
                 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
                 * */
                // Background Patterns Reader
                $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
                $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
                $sample_patterns      = array();

                if ( is_dir( $sample_patterns_path ) ) :

                    if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) :
                        $sample_patterns = array();

                        while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                            if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                                $name              = explode( '.', $sample_patterns_file );
                                $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                                $sample_patterns[] = array(
                                    'alt' => $name,
                                    'img' => $sample_patterns_url . $sample_patterns_file
                                );
                            }
                        }
                    endif;
                endif;

                ob_start();

                $ct          = wp_get_theme();
                $this->theme = $ct;
                $item_name   = $this->theme->get( 'Name' );
                $tags        = $this->theme->Tags;
                $screenshot  = $this->theme->get_screenshot();
                $class       = $screenshot ? 'has-screenshot' : '';

                $customize_title = sprintf( __( 'Customize &#8220;%s&#8221;', 'idealauto' ), $this->theme->display( 'Name' ) );

                ?>
                <div id="current-theme" class="<?php echo esc_attr( $class ); ?>">
                    <?php if ( $screenshot ) : ?>
                        <?php if ( current_user_can( 'edit_theme_options' ) ) : ?>
                            <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize"
                               title="<?php echo esc_attr( $customize_title ); ?>">
                                <img src="<?php echo esc_url( $screenshot ); ?>"
                                     alt="<?php esc_attr_e( 'Current theme preview', 'idealauto' ); ?>"/>
                            </a>
                        <?php endif; ?>
                        <img class="hide-if-customize" src="<?php echo esc_url( $screenshot ); ?>"
                             alt="<?php esc_attr_e( 'Current theme preview', 'idealauto' ); ?>"/>
                    <?php endif; ?>

                    <h4><?php echo esc_attr($this->theme->display( 'Name' )); ?></h4>

                    <div>
                        <ul class="theme-info">
                            <li><?php printf( __( 'By %s', 'idealauto' ), $this->theme->display( 'Author' ) ); ?></li>
                            <li><?php printf( __( 'Version %s', 'idealauto' ), $this->theme->display( 'Version' ) ); ?></li>
                            <li><?php echo '<strong>' . __( 'Tags', 'idealauto' ) . ':</strong> '; ?><?php printf( $this->theme->display( 'Tags' ) ); ?></li>
                        </ul>
                        <p class="theme-description"><?php echo esc_attr($this->theme->display( 'Description' )); ?></p>
                        <?php
                            if ( $this->theme->parent() ) {
                                printf( ' <p class="howto">' . __( 'This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'idealauto' ) . '</p>', __( 'http://codex.wordpress.org/Child_Themes', 'idealauto' ), $this->theme->parent()->display( 'Name' ) );
                            }
                        ?>

                    </div>
                </div>

                <?php
                $item_info = ob_get_contents();

                ob_end_clean();

                $sampleHTML = '';
           
				
				$of_options_fontsize = array("8px" => "8px", "9px" => "9px", "10px" => "10px", "11px" => "11px", "12px" => "12px", "13px" => "13px", "14px" => "14px", "15px" => "15px", "16px" => "16px", "17px" => "17px", "18px" => "18px", "19px" => "19px", "20px" => "20px", "21px" => "21px", "22px" => "22px", "23px" => "23px", "24px" => "24px", "25px" => "25px", "26px" => "26px", "27px" => "27px", "28px" => "28px", "29px" => "29px", "30px" => "30px", "31px" => "31px", "32px" => "32px", "33px" => "33px", "34px" => "34px", "35px" => "35px", "36px" => "36px", "37px" => "37px", "38px" => "38px", "39px" => "39px", "40px" => "40px");
				$of_options_fontweight = array("100" => "100", "200" => "200", "300" => "300", "400" => "400", "500" => "500", "600" => "600", "700" => "700");
				$of_options_font = array("1" => "Google Font", "2" => "Standard Font", "3" => "Custom Font");

				//Standard Fonts
				$of_options_standard_fonts = array(
					'Arial, Helvetica, sans-serif' => 'Arial, Helvetica, sans-serif',
					"'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
					"'Bookman Old Style', serif" => "'Bookman Old Style', serif",
					"'Comic Sans MS', cursive" => "'Comic Sans MS', cursive",
					"Courier, monospace" => "Courier, monospace",
					"Garamond, serif" => "Garamond, serif",
					"Georgia, serif" => "Georgia, serif",
					"Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
					"'Lucida Console', Monaco, monospace" => "'Lucida Console', Monaco, monospace",
					"'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
					"'MS Sans Serif', Geneva, sans-serif" => "'MS Sans Serif', Geneva, sans-serif",
					"'MS Serif', 'New York', sans-serif" => "'MS Serif', 'New York', sans-serif",
					"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
					"Tahoma, Geneva, sans-serif" => "Tahoma, Geneva, sans-serif",
					"'Times New Roman', Times, serif" => "'Times New Roman', Times, serif",
					"'Trebuchet MS', Helvetica, sans-serif" => "'Trebuchet MS', Helvetica, sans-serif",
					"Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif"
				);
				
                //lists page
                $lists_page = array();
                $args_page = array(
                    'sort_order' => 'asc',
                    'sort_column' => 'post_title',
                    'hierarchical' => 1,
                    'exclude' => '',
                    'include' => '',
                    'meta_key' => '',
                    'meta_value' => '',
                    'authors' => '',
                    'child_of' => 0,
                    'parent' => -1,
                    'exclude_tree' => '',
                    'number' => '',
                    'offset' => 0,
                    'post_type' => 'page',
                    'post_status' => 'publish'
                );
                $pages = get_pages( $args_page );

                foreach( $pages as $p ){
                    $lists_page[ $p->ID ] = esc_attr( $p->post_title );
                }
// -> START 
$this->sections[] = array(
    'title' => esc_html__('General', 'idealauto'),
    'id' => 'general',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/004-setting.png',
    'fields' => array(
        array(
            'id'        => 'favicon',
            'type'      => 'media',
            'url'       => true,
            'title'     => esc_html__('Favicon', 'idealauto' ),
            'compiler'  => 'false',
            'subtitle'  => esc_html__('Upload your favicon', 'idealauto' ),
        ),
        array(         
            'id'       => 'bg_body',
            'type'     => 'background',
            'title'    =>  esc_html__('Background', 'idealauto'),
            'subtitle' =>  esc_html__('background with image, color, etc.', 'idealauto'),
            'desc'     =>  esc_html__('Change background for body.', 'idealauto'),
            'default'  => array(
                'background-color' => '#ffffff',
            ),
            'output' => array('body'),
        ),

        array(
            'id'       => 'less',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Less To Css', 'idealauto'),
            'default'  => false,
            'desc'      =>  esc_html__('Function Render Less To Css.Please turn off if you not use.', 'idealauto'),
        ),
        array(
            'id'       => 'box-change-style',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Box Style', 'idealauto'),
            'default'  => false,
            'desc'      =>  esc_html__('Display box change style demo.', 'idealauto'),
        ),
        array (
				'id'       => 'rtl',
				'type'     => 'switch',
				'title'    => esc_html__( 'RTL', 'idealauto' ),
				'default'  => false
		),
        array (
				'id'       => 'scroll_speed',
				'type'     => 'switch',
				'title'    => esc_html__( 'Scroll Speed', 'idealauto' ),
				'default'  => true
		),

        array(
            'id'        => 'container-width',
            'type'      => 'slider',
            'title'     =>  esc_html__('Website Width Dektop', 'idealauto'),
            "default"   => 1200,
            "min"       => 700,
            "step"      => 10,
            "max"       => 1920,
            'display_value' => 'label'
        ),
        array(
            'id'        => 'container-laptop-width',
            'type'      => 'slider',
            'title'     =>  esc_html__('Website Width Laptop', 'idealauto'),
            "default"   => 1200,
            "min"       => 700,
            "step"      => 10,
            "max"       => 1920,
            'display_value' => 'label'
        ),

    )
);
// -> START Header Fields
$this->sections[] = array(
    'title' => esc_html__('Header', 'idealauto'),
    'id' => 'header',
    'desc' => esc_html__('Custom Header', 'idealauto'),
    'customizer_width' => '400px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/002-header.png',
    'fields' => array(
          array(
            'id' => 'choose-header-absolute',
            'type' => 'select',
            'multi' => true,
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select header absolute.', 'idealauto'),
        ),
         array(
            'id' => 'select-header',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for header', 'idealauto'),
            'desc' => esc_html__('Select layout for header from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
    )
);

// -> START Title Bar Fields
$this->sections[] = array(
    'title' => esc_html__('Title Bar', 'idealauto'),
    'id' => 'title_bar',
    'desc' => esc_html__('Custom title bar', 'idealauto'),
    'customizer_width' => '400px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/001-right-arrow.png',
    'fields' => array(
        array(
            'id'       => 'title-bar-switch',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Switch On Title Bar', 'idealauto'),
            'subtitle' =>  esc_html__('Look, it\'s on!', 'idealauto'),
            'default'  => true,
        ),
        array(
            'id' => 'select-titlebar',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(         
            'id'       => 'bg_titlebar',
            'type'     => 'background',
            'title'    =>  esc_html__('Background', 'idealauto'),
            'subtitle' =>  esc_html__('background with image, color, etc.', 'idealauto'),
            'desc'     =>  esc_html__('Change background for titler defaul (not woking with title elemetor template).', 'idealauto'),
            'default'  => array(
                'background-color' => '#333333',
            ),
            'output' => array('.jws-title-bar-wrap-inner'),
        ),
        array(
            'id'             => 'titlebar-spacing',
            'type'           => 'spacing',
            'output'         => array('.jws-title-bar-wrap-inner'),
            'mode'           => 'padding',
            'units'          => array('em', 'px'),
            'units_extended' => 'false',
            'desc'           =>  esc_html__('You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'idealauto'),
            'default'            => array(
                'padding-top'     => '150px', 
                'padding-right'   => '15px', 
                'padding-bottom'  => '100px', 
                'padding-left'    => '15px',
                'units'          => 'px', 
         ),
        
    ),
));

// -> START footer Fields
$this->sections[] = array(
    'title' => esc_html__('Footer', 'idealauto'),
    'id' => 'footer',
    'desc' => esc_html__('Custom Footer', 'idealauto'),
    'customizer_width' => '400px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/004-footer.png',
    'fields' => array(
        array(
            'id'       => 'footer-switch-parallax',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Switch Parallax', 'idealauto'),
            'default'  => false,
        ),
        array(
            'id' => 'select-footer',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for footer', 'idealauto'),
            'desc' => esc_html__('Select layout for footer from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
    )
);

// -> START Color Fields
$this->sections[] = array(
    'title' => esc_html__('Color Styling', 'idealauto'),
    'id' => 'global-color',
    'desc' => esc_html__('These are really color fields!', 'idealauto'),
    'customizer_width' => '400px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/003-rgb.png',
);
$this->sections[] = array(
    'title' => esc_html__('Color', 'idealauto'),
    'id' => 'color-styling',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'main-color',
            'type' => 'color',
            'title' => esc_html__('Main Color', 'idealauto'),
            'default' => '#ed1c24',
        ),
        array(
            'id' => 'secondary-color',
            'type' => 'color',
            'title' => esc_html__('Secondary Color', 'idealauto'),
            'default' => '#d71b22',
        ),
        array(
            'id' => 'color_heading',
            'type' => 'color',
            'title' => esc_html__('Color Heading', 'idealauto'),
            'default' => '#131313',
        ),
        array(
            'id' => 'color_light',
            'type' => 'color',
            'title' => esc_html__('Color Light', 'idealauto'),
            'default' => '#ffffff',
        ),
        array(
            'id' => 'color_body',
            'type' => 'color',
            'title' => esc_html__('Color Body', 'idealauto'),
            'default' => '#6f6f6f',
        ),
    ),
);
$this->sections[] = array(
    'title' => esc_html__('Back To Top', 'idealauto'),
    'id' => 'to-top-styling',
    'subsection' => true,
    'fields' => array(
          array(
            'id'       => 'to-top-layout',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Back To Top Skins', 'idealauto'), 
            'options'  => array(
                'with-shadow' => 'With Shadow',
                'with-mancolor' => 'With Main Color',
            ),
            'default'  => 'with-shadow',
        ),
        array(
            'id' => 'to-top-color',
            'type' => 'color',
            'title' => esc_html__('Color', 'idealauto'),
            'default' => '#333333',
            'output' => array('.backToTop'),
        ),
    ),
);
$this->sections[] = array(
    'title' => esc_html__('Button', 'idealauto'),
    'id' => 'button-styling',
    'subsection' => true,
    'fields' => array(
          array(
            'id'       => 'button-layout',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Button Global Skins', 'idealauto'), 
            'options'  => array(
                'default' => 'Default',
                'gradient' => 'Gradient',
            ),
            'default'  => 'gradient',
        ),
        array(
            'id' => 'button-bgcolor',
            'type' => 'color',
            'title' => esc_html__('Background Color', 'idealauto'),
            'default' => '',
        ),
        array(
            'id' => 'button-bgcolor2',
            'type' => 'color',
            'title' => esc_html__('Background Color 2', 'idealauto'),
            'default' => '',
        ),
        array(
            'id' => 'button-color',
            'type' => 'color',
            'title' => esc_html__('Color', 'idealauto'),
            'default' => '',
        ),
        array(
            'id' => 'button-color2',
            'type' => 'color',
            'title' => esc_html__('Color 2', 'idealauto'),
            'default' => '',
        ),
         array(
            'id' => 'opt-typography-button',
            'type' => 'typography',
            'title' => esc_html__('Font', 'idealauto'),
            'google' => true,
            'color' => false,
            'text-align' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'output' => array('body.button-default  .elementor-button, body.button-default .jws-cf7-style .wpcf7-submit, body.button-default .elementor-button.rev-btn'),
        ),
        array(
            'title' => esc_html__('Padding', 'idealauto'),
            'id'             => 'button-padding',
            'type'           => 'spacing',
            'mode'           => 'padding',
            'units'          => array('em', 'px'),
            'units_extended' => 'false',
            'output' => array('body.button-default  .elementor-button, body.button-default .jws-cf7-style .wpcf7-submit, body.button-default .elementor-button.rev-btn'),
        ),

    ),
);


// -> START Blogs Fields
$this->sections[] = array(
    'title' => esc_html__('Blogs', 'idealauto'),
    'id' => 'blogs',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/005-blogging.png',
    'fields' => array(
        array(
            'id' => 'select-titlebar-blog-archive',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'position_sidebar',
            'type' => 'select',
            'title' => esc_html__('Select Position Sidebar', 'idealauto'),
            'options' => array(
                'left' => 'Left',
                'right' => 'Right',
                'no_sidebar' => 'No Sidebar',
            ),
            'default' => 'right',
        ),
        array(
            'id' => 'select-sidebar-post-columns',
            'type' => 'select',
            'title' => esc_html__('Select Columns Default', 'idealauto'),
            'options' => array(
                '1' => '1 Columns',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns',
            ),
            'default' => '1',
        ),
        array(
            'id'       => 'blog_layout',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Blog Skin', 'idealauto'), 
            'options'  => array(
                'default' => 'Default',
                'layout2' => 'Layout 2',
            ),
            'default'  => 'default',
        ),
        array(
            'id' => 'select-sidebar-post',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for sidebar', 'idealauto'),
            'desc' => esc_html__('Select layout from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
            'required' => array('position_sidebar', '!=', 'no_sidebar'),
        ),
        array(
            'id'       => 'blog_imagesize',
            'type'     => 'text',
            'title'    =>  esc_html__('Single Image Size', 'idealauto'),
            'default'  => '866x505'
        ),
      
    )
);
$this->sections[] = array(
    'title' => esc_html__('Blog Single', 'idealauto'),
    'id' => 'blog-single',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'blog-title-bar-switch',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Switch On Title Bar', 'idealauto'),
            'subtitle' =>  esc_html__('Look, it\'s on!', 'idealauto'),
            'default'  => true,
        ),
        array(
            'id' => 'select-titlebar-blog',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
            'required' => array('blog-title-bar-switch', '=', true),
        ),
        array(
            'id' => 'select-header-blog',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for header', 'idealauto'),
            'desc' => esc_html__('Select layout for header from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
                'id'       => 'header_absolute_blog',
                'type'     => 'switch', 
                'title'    =>  esc_html__('Header Absolute', 'idealauto'),
                'default'  => true,
        ),
         array(
            'id'       => 'blog_single_layout',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Single Blog Skin', 'idealauto'), 
            'subtitle' =>  esc_html__('No validation can be done on this field type', 'idealauto'),
            'desc'     =>  esc_html__('Choose layout for single blog (comment,meta, author box...)', 'idealauto'),
            'options'  => array(
                'layout1' => 'Layout 1',
                'layout2' => 'Layout 2',
                'layout3' => 'Layout 3',
                'layout4' => 'Layout 4',
                'layout5' => 'Layout 5',
                'layout6' => 'Layout 6',
                'layout7' => 'Layout 7',
                'layout8' => 'Layout 8'
            ),
            'default'  => 'layout6',
        ),
        array(
            'id' => 'select-related-blog',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for Related Post', 'idealauto'),
            'desc' => esc_html__('Select layout from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'position_sidebar_blog_single',
            'type' => 'select',
            'title' => esc_html__('Select Position Sidebar', 'idealauto'),
            'options' => array(
                'left' => 'Left',
                'right' => 'Right',
                'full' => 'No Sidebar',
            ),
            'default' => 'full',
        ),
         array(
            'id' => 'select-sidebar-post-single',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for sidebar', 'idealauto'),
            'desc' => esc_html__('Select layout from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
            'required' => array('position_sidebar_blog_single', '!=', 'no_sidebar'),
        ),
        array(
            'id'       => 'single_blog_imagesize',
            'type'     => 'text',
            'title'    =>  esc_html__('Single Blog Image Size', 'idealauto'),
            'default'  => '1170x550'
        ),
        array(
            'id' => 'select-content-before-footer-blog-single',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select content before footer for archive', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
    ),
);
// -> START Jobs Fields
$this->sections[] = array(
    'title' => esc_html__('Gallery', 'idealauto'),
    'id' => 'gallery',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/006-gallery.png',
    'fields' => array(
      array(
            'id'=>'gallery_category',
            'type' => 'multi_text',
            'title' =>  esc_html__('Gallery Category', 'idealauto'),
            'validate' => 'no_html',
        ),
    )
);
// -> START Blogs Fields

if ( ! function_exists( 'jws_product_rent_available_fields' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_product_rent_available_fields() {
		$product_attributes = array();
        $fields = array();
		if( function_exists( 'wc_get_attribute_taxonomies' ) ) {
			$product_attributes = wc_get_attribute_taxonomies();
		}
    
		if ( count( $product_attributes ) > 0 ) {
			foreach ( $product_attributes as $attribute ) {
				$fields[ $attribute->attribute_name ] = $attribute->attribute_label;
			}	
		}

		return $fields;
	}
}


$this->sections[] = array(
    'title' => esc_html__('Rental', 'idealauto'),
    'id' => 'rental',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/003-car-rental.png',
    'fields' => array(
       
        array(
            'id'=>'locations',
            'type' => 'multi_text',
            'title' =>  esc_html__('Locations', 'idealauto'),
            'validate' => 'no_html',
        ),
        array(
            'id'       => 'select_rent_age',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Age For Rent', 'idealauto'), 
            'options'  => jws_product_rent_available_fields(),
            'default'  => '',
        ),
         array(
            'id'       => 'select_rent_body',
            'type'     => 'select',
            'title'    =>  esc_html__('Select Body For Rent', 'idealauto'), 
            'options'  => jws_product_rent_available_fields(),
            'default'  => '',
        ),
        array(
            'id'       => 'select_rent_features',
            'type'     => 'select',
            'title'    =>  esc_html__('Features & Options', 'idealauto'), 
            'options'  => jws_product_rent_available_fields(),
            'default'  => '',
        ),
        
    )
);

// -> START Blogs Fields
$this->sections[] = array(
    'title' => esc_html__('Service', 'idealauto'),
    'id' => 'service',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/007-car-jack.png',
    'fields' => array(
       
        
    )
);
$this->sections[] = array(
    'title' => esc_html__('Services Single', 'idealauto'),
    'id' => 'service-single',
    'subsection' => true,
    'fields' => array(

        array(
            'id' => 'select-titlebar-service',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
     
        ),
        array(
            'id' => 'select-header-service',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for header', 'idealauto'),
            'desc' => esc_html__('Select layout for header from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'select-footer-service',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for footer', 'idealauto'),
            'desc' => esc_html__('Select layout for footer from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
         array(
            'id' => 'select-sidebar-service-single',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for sidebar', 'idealauto'),
            'desc' => esc_html__('Select layout from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
          
        ),
         array(
            'id' => 'service_position_sidebar',
            'type' => 'select',
            'title' => esc_html__('Select Position Sidebar', 'idealauto'),
            'options' => array(
                'left' => 'Left',
                'right' => 'Right',
                'no_sidebar' => 'No Sidebar',
            ),
            'default' => 'left',
        ),
        array(
            'id' => 'service-single-color',
            'type' => 'color',
            'title' => esc_html__('Custom Main Color', 'idealauto'),
            'default' => '',
        ),
    
    ),
);
// -> START Dealer Fields
$this->sections[] = array(
    'title' => esc_html__('Dealer', 'idealauto'),
    'id' => 'dealer',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/008-car-breakdown.png',
    'fields' => array(
       
        array(
            'id'=>'dealer_distance',
            'type' => 'multi_text',
            'title' =>  esc_html__('Distance (Km)', 'idealauto'),
            'validate' => 'no_html',
            'default' => array('10','25','50','100','500')
        ),
        array(
            'id'=>'dealer_results',
            'type' => 'multi_text',
            'title' =>  esc_html__('Number results', 'idealauto'),
            'validate' => 'no_html',
            'default' => array('5','10','15','20')
        ),
        array(
            'id'       => 'unit_distance',
            'type'     => 'select',
            'title'    =>  esc_html__('Distance Unit', 'idealauto'), 
            'options'  => array(
                'km' => 'Km',
                'mile' => 'Mile',
            ),
            'default'  => 'km',
        ),
    )
);

$this->sections[] = array(
    'title' => esc_html__('Dealer Detail', 'idealauto'),
    'id' => 'dealer_detail',
    'subsection'       => true,
    'customizer_width' => '300px',
    'fields' => array(
         array(
            'id' => 'select-titlebar-dealer-detail',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id'       => 'dealer_review_pending',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Enable moderation for dealer review', 'idealauto'),
            'default'  => false,
        ),
       array(
            'id' => 'dealer_login_form',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
            'title' => esc_html__('Select Page Form Login', 'idealauto'),
            'desc' => esc_html__('Select Page Form Login Redirect From: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
        ), 
         array(
            'id' => 'select-content-before-footer-author-detail',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select content before footer for author detail', 'idealauto'),
            'desc' => esc_html__('Select content before footer elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
    )
);



$this->sections[] = array(
    'title' => esc_html__('Dealer Account', 'idealauto'),
    'id' => 'dealer_account',
    'subsection'       => true,
    'customizer_width' => '300px',
    'fields' => array(
       array(
            'id' => 'select-pricing-page',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
            'title' => esc_html__('Select page pricing', 'idealauto'),
            'desc' => esc_html__('Select page from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Header Footer Template</a>',
        ),
    )
);
// -> START Login Register Fields
$this->sections[] = array(
    'title' => esc_html__('Login/Register', 'idealauto'),
    'id' => 'login_register',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/002-login.png',
    'fields' => array(
        
            array(
                'id'       => 'select-page-login-register-author',
                'type'     => 'switch', 
                'title'    =>  esc_html__('Switch On Login Register To User Page', 'idealauto'),
                'default'  => false,
            ),
            array(
                'id' => 'login_form_redirect',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Form Login Redirect', 'idealauto'),
                'desc' => esc_html__('Select Page Form Login Redirect From: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
            array(
                'id' => 'logout_form_redirect',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Form Logout Redirect', 'idealauto'),
                'desc' => esc_html__('Select Page Form Logout Redirect From: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
            array(
                'id' => 'page_mail',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Verify Email', 'idealauto'),
                'desc' => esc_html__('Select Page Verify Email From: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
    )
);

if ( ! function_exists( 'jws_inventory_flter_field' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_inventory_flter_field() {

		$fields = array(
			'enabled'  => array(
			 	'car_make' => esc_html__( 'Make', 'idealauto' ),
                'car_model' => esc_html__( 'Model', 'idealauto' ),
                'car_year' => esc_html__( 'Year', 'idealauto' ),
                'car_body_style' => esc_html__( 'Body', 'idealauto' ),
                'car_condition' => esc_html__( 'Condition', 'idealauto' ),
                'car_mileage' => esc_html__( 'Mileage', 'idealauto' ),
                'car_transmission' => esc_html__( 'Transmission', 'idealauto' ),
                'car_engine' => esc_html__( 'Engine', 'idealauto' ),
                'car_exterior_color' => esc_html__( 'Exterior Color', 'idealauto' ),
                'car_fuel_type' => esc_html__( 'Fuel Type', 'idealauto' ),
			),
			'disabled' => array(
				'car_interior_color' => esc_html__( 'Interior Color', 'idealauto' ),
			)
		);

		return $fields;
	}
}


if ( ! function_exists( 'jws_inventory_tax_field' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_inventory_tax_field() {

		$fields = array(

                'car_body_style' => esc_html__( 'Body', 'idealauto' ),
                'car_mileage' => esc_html__( 'Mileage', 'idealauto' ),
                'car_engine' => esc_html__( 'Engine', 'idealauto' ),
                'car_fuel_type' => esc_html__( 'Fuel Type', 'idealauto' ),
                'car_transmission' => esc_html__( 'Transmission', 'idealauto' ),
                'car_drive_train' => esc_html__( 'Drive Train', 'idealauto' ),
                'car_fuel_economy' => esc_html__( 'City/Highway', 'idealauto' ),
                'car_msrp_price' => esc_html__( 'MRSP Price', 'idealauto' ),
                'car_interior_color' => esc_html__( 'Interior Color', 'idealauto' ),
                'car_exterior_color' => esc_html__( 'Exterior Color', 'idealauto' ),
                'car_registered' => esc_html__( 'Registered', 'idealauto' ),
                'car_vin_number' => esc_html__( 'Vin', 'idealauto' ),
                'car_stock_number' => esc_html__( 'Stock Number', 'idealauto' ),
                'car_door_number' => esc_html__( 'Door Number', 'idealauto' ),
                'car_seat_number' => esc_html__( 'Seating Capacity', 'idealauto' ),
                'car_trim' => esc_html__( 'Trim', 'idealauto' ),
		);

		return $fields;
	}
}


if ( ! function_exists( 'jws_user_featured_list' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_user_featured_list() {

        $blogusers = get_users( );
        // Array of WP_User objects.
        foreach ( $blogusers as $user ) {
            $fields[$user->ID] = $user->display_name;
        }

		return $fields;
	}
}


// -> START Blogs Fields
$this->sections[] = array(
    'title' => esc_html__('Inventory', 'idealauto'),
    'id' => 'inventory',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/009-car.png',
    'fields' => array(
         array(
            'id' => 'select-titlebar-cars-archive',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
				'id'       => 'year_range',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Year Range', 'idealauto' ),
				'desc'     => esc_html__( 'Enble year filter min and max', 'idealauto' ),
				'options'  => array(
					'yes' => esc_html__( 'Enabled', 'idealauto' ),
					'no'  => esc_html__( 'Disabled', 'idealauto' ),
				),
				'default'  => 'yes',
	   ),
       	array(
				'id'      => 'car_no_sold',
				'type'    => 'switch',
				'title'   => esc_html__( 'Sold Vehicles', 'idealauto' ),
				'desc'    => esc_html__( 'This will hide the vehicles that are sold', 'idealauto' ),
				'on'      => esc_html__( 'Show', 'idealauto' ),
				'off'     => esc_html__( 'Hide', 'idealauto' ),
				'default' => true,
		),
        
        array(
            'id'=>'cars-per-page',
            'type' => 'multi_text',
            'title' =>  esc_html__('Vehicles Per Page', 'idealauto'),
            'subtitle' => __('Please enter the number', 'idealauto'),
            'validate' => 'no_html',
            'default' => array('9','12','18','24'),
        ),
    	array(
			'id'       => 'cars-lay-style',
			'type'     => 'select',
			'title'    => esc_html__( 'Default listing layout', 'idealauto' ),
			'subtitle' => esc_html__( 'Select layout style', 'idealauto' ),
			'options'  => array(
				'view-grid'          => esc_html__( 'With sidebar grid', 'idealauto' ),
				'view-list'          => esc_html__( 'With sidebar list', 'idealauto' ),
			),
			'default'  => 'view-grid',

		),
        	array(
				'id'       => 'cars-default-sort-by',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sort By', 'idealauto' ),
				'subtitle' => esc_html__( 'Select default sort by listing', 'idealauto' ),
				// Must provide key => value pairs for radio options
				'options'  => array(
					'name'       => esc_html__( 'Sort by Name', 'idealauto' ),
					'sale_price' => esc_html__( 'Sort by Price', 'idealauto' ),
					'date'       => esc_html__( 'Sort by Date', 'idealauto' ),
					'year'       => esc_html__( 'Sort by Year', 'idealauto' ),
				),
				'default'  => 'date',
			),
			array(
				'id'       => 'cars-default-sort-by-order',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Default Order By', 'idealauto' ),
				'subtitle' => esc_html__( 'Default order by', 'idealauto' ),
				'options'  => array(
					'asc'  => esc_html__( 'Ascending', 'idealauto' ),
					'desc' => esc_html__( 'Descending', 'idealauto' ),
				),
				'default'  => 'desc',
			),
            array (
				'id'       => 'car_taxonomy_field',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Select taxonomy field for inventory filter.', 'idealauto' ),
				'subtitle' => esc_html__( 'Choose which fields should be presented on the filter.', 'idealauto' ),
				'options'  => jws_inventory_flter_field()
			),
            array(
    			'id'       => 'cars-dealer-featured',
    			'type'     => 'select',
    			'title'    => esc_html__( 'Select Author Car Featured', 'idealauto' ),
    			'subtitle' => esc_html__( 'Display car featured in inventory archive.', 'idealauto' ),
    			// Must provide key => value pairs for radio options
    			'options'  => jws_user_featured_list(),
    		),
            array(
				'id'      => 'cars_grid_attr_enable',
				'type'    => 'switch',
				'title'   => esc_html__( 'Car Attribute Grid', 'idealauto' ),
				'on'      => esc_html__( 'Enable', 'idealauto' ),
				'off'     => esc_html__( 'Diable', 'idealauto' ),
				'default' => false,
		  ),
        
            array(
                'id'         => 'cars_grid_attr',
                'type'       => 'repeater',
                'title'      => __( 'Car Info Attribute In Grid', 'seatevent' ),
                'subtitle'   => __( '', 'seatevent' ),
                'desc'       => __( '', 'seatevent' ),
                'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => '', // Add a repeater block name to the Add and Delete buttons
                'required' => array('cars_grid_attr_enable', '=', true),
                'fields'     => array(
                
                    array (
        				'id'       => 'car_field',
        				'type'     => 'select',
        				'title'    => esc_html__( 'Select taxonomy field for gid.', 'idealauto' ),
        				'subtitle' => esc_html__( 'Choose which fields should be presented on the car grid.', 'idealauto' ),
        				'options'  => jws_inventory_tax_field()
        			),
                    
                    array(
        				'id'       => 'label',
        				'type'     => 'text',
        				'title'    => esc_html__( 'Label', 'idealauto' ),
        				'desc'     => esc_html__( 'Enter label for attr.', 'idealauto' ),
        				'default'  => 'Label name',
        			),
                    
                    array(
                        'id'        => 'icon',
                        'type'      => 'media',
                        'url'       => true,
                        'title'     => esc_html__('Image', 'idealauto' ),
                        'compiler'  => 'false',
                        'subtitle'  => esc_html__('Upload your image', 'idealauto' ),
                    ), 
                )
            ),
            array(
                'id' => 'select-content-before-footer-car-archive',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
                'title' => esc_html__('Select content before footer for archive', 'idealauto'),
                'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
            ),
    )
);






/*Dealer Cars Detail Settings options */
$this->sections[] = array(
		'title'            => esc_html__( 'Cars Detail Settings', 'idealauto' ),
		'id'               => 'cars-detail-settings',
		'subsection'       => true,
		'customizer_width' => '400px',
		'fields'           => array(
              array(
                    'id'       => 'cars-detail-layout',
                    'type'     => 'select',
                    'title'    =>  esc_html__('Select Layout Cars Detail', 'idealauto'), 
                    'options'  => array(
                        'layout1' => 'Layout 1',
                        'layout2' => 'layout 2',
                    ),
                    'default'  => 'layout1',
             ),   
			 array(
                'id' => 'select-titlebar-cars-detail',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
                'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
                'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer And Template</a>',
            ),
            array(
                'id' => 'select-content-before-footer-car-single',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
                'title' => esc_html__('Select content before footer for single', 'idealauto'),
                'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
            ),
            array(
				'id'      => 'cars_grid_attr_enable_single',
				'type'    => 'switch',
				'title'   => esc_html__( 'Car Info Attribute Single', 'idealauto' ),
				'on'      => esc_html__( 'Enable', 'idealauto' ),
				'off'     => esc_html__( 'Diable', 'idealauto' ),
				'default' => false,
		  ),
        
          array(
                'id'         => 'cars_grid_attr_single',
                'type'       => 'repeater',
                'title'      => __( 'Car Info Attribute In Single', 'seatevent' ),
                'subtitle'   => __( '', 'seatevent' ),
                'desc'       => __( '', 'seatevent' ),
                'group_values' => true, // Group all fields below within the repeater ID
                'item_name' => '', // Add a repeater block name to the Add and Delete buttons
                'required' => array('cars_grid_attr_enable_single', '=', true),
                'fields'     => array(
                
                    array (
        				'id'       => 'car_field',
        				'type'     => 'select',
        				'title'    => esc_html__( 'Select taxonomy field for gid.', 'idealauto' ),
        				'subtitle' => esc_html__( 'Choose which fields should be presented on the car grid.', 'idealauto' ),
        				'options'  => jws_inventory_tax_field()
        			),
                    
                    array(
        				'id'       => 'label',
        				'type'     => 'text',
        				'title'    => esc_html__( 'Label', 'idealauto' ),
        				'desc'     => esc_html__( 'Enter label for attr.', 'idealauto' ),
        				'default'  => 'Label name',
        			),
                    
                    array(
                        'id'        => 'icon',
                        'type'      => 'media',
                        'url'       => true,
                        'title'     => esc_html__('Image', 'idealauto' ),
                        'compiler'  => 'false',
                        'subtitle'  => esc_html__('Upload your image', 'idealauto' ),
                    ), 
                )
            ),
            
          array(
				'id'      => 'enable_sidebar_phone_single',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable Phone Single', 'idealauto' ),
				'on'      => esc_html__( 'Enable', 'idealauto' ),
				'off'     => esc_html__( 'Diable', 'idealauto' ),
				'default' => true,
		  ),
          array(
				'id'      => 'enable_sidebar_dealer_info_single',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable Dealer Info Single', 'idealauto' ),
				'on'      => esc_html__( 'Enable', 'idealauto' ),
				'off'     => esc_html__( 'Diable', 'idealauto' ),
				'default' => true,
		  ),
          array(
				'id'      => 'enable_sidebar_finance_single',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable Finance Calculate Single', 'idealauto' ),
				'on'      => esc_html__( 'Enable', 'idealauto' ),
				'off'     => esc_html__( 'Diable', 'idealauto' ),
				'default' => true,
		  ),
          
            
 		),
);          
/*Dealer Cars Currency Settings options */
$this->sections[] = array(
		'title'            => esc_html__( 'Currency Settings', 'idealauto' ),
		'id'               => 'currency-settings',
		'subsection'       => true,
		'customizer_width' => '400px',
		'fields'           => array(
			array(
				'id'      => 'cars-currency-symbol',
				'type'    => 'select',
				'title'   => esc_html__( 'Currency Symbol', 'idealauto' ),
				'options' => jws_currency_option_list(),
				'default' => 'USD',
			),
			array(
				'id'      => 'cars-currency-symbol-placement',
				'type'    => 'select',
				'title'   => esc_html__( 'Currency Symbol Placement', 'idealauto' ),
				'options' => array(
					'1' => esc_html__( 'Before Value', 'idealauto' ),
					'2' => esc_html__( 'After Value', 'idealauto' ),
					'3' => esc_html__( 'Before Value With Spacing', 'idealauto' ),
					'4' => esc_html__( 'After Value With Spacing', 'idealauto' ),
				),
				'default' => '1',
			),
			array(
				'id'      => 'cars-disable-currency-separators',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Display Currency Separators', 'idealauto' ),
				'options' => array(
					'1' => esc_html__( 'Yes', 'idealauto' ),
					'0' => esc_html__( 'No', 'idealauto' ),
				),
				'default' => '1',
			),
			array(
				'id'       => 'cars-thousand-separator',
				'type'     => 'text',
				'title'    => esc_html__( 'Thousand Separator', 'idealauto' ),
				'desc'     => esc_html__( 'Enter in a separator for large currency amounts', 'idealauto' ),
				'default'  => ',',
				'required' => array(
					'cars-disable-currency-separators',
					'=',
					'1',
				),
			),
			array(
				'id'       => 'cars-decimal-separator',
				'type'     => 'text',
				'title'    => esc_html__( 'Decimal Separator', 'idealauto' ),
				'desc'     => esc_html__( 'Enter in a separator for decimal formate', 'idealauto' ),
				'default'  => '.',
				'required' => array(
					'cars-disable-currency-separators',
					'=',
					'1',
				),
			),
			array(
				'id'       => 'cars-number-decimals',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Decimals', 'idealauto' ),
				'desc'     => esc_html__( 'Number of decimals to be displayed after the price', 'idealauto' ),
				'default'  => '2',
				'required' => array(
					'cars-disable-currency-separators',
					'=',
					'1',
				),
			),
		),
);
/*Dealer Cars Compare Settings options */
$this->sections[] = array(
		'title'            => esc_html__( 'Cars Compare Settings', 'idealauto' ),
		'id'               => 'cars-compare-settings',
		'subsection'       => true,
		'customizer_width' => '400px',
		'fields'           => array(
			 array(
                'id' => 'select-page-compare',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Compare', 'idealauto'),
                'desc' => esc_html__('Select page comapre from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
 		),
);

if ( ! function_exists( 'jws_inventory_submit_field' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_inventory_submit_field() {

		$fields = array(
			'enabled'  => array(
                'body_style' => esc_html__( 'Body', 'idealauto' ),
                'mileage' => esc_html__( 'Mileage', 'idealauto' ),
                'engine' => esc_html__( 'Engine', 'idealauto' ),
                'fuel_type' => esc_html__( 'Fuel Type', 'idealauto' ),
                'transmission' => esc_html__( 'Transmission', 'idealauto' ),
                'drive_train' => esc_html__( 'Drive Train', 'idealauto' ),
                'fuel_economy' => esc_html__( 'City/Highway', 'idealauto' ),
                'msrp_price' => esc_html__( 'MRSP Price', 'idealauto' ),
                'interior_color' => esc_html__( 'Interior Color', 'idealauto' ),
                'exterior_color' => esc_html__( 'Exterior Color', 'idealauto' ),
                'registered' => esc_html__( 'Registered', 'idealauto' ),
                'vin_number' => esc_html__( 'Vin', 'idealauto' ),
                'stock_number' => esc_html__( 'Stock Number', 'idealauto' ),
                'door_number' => esc_html__( 'Door Number', 'idealauto' ),
                'seat_number' => esc_html__( 'Seating Capacity', 'idealauto' ),
                'trim' => esc_html__( 'Trim', 'idealauto' ),
			),
			'disabled' => array(
              
			)
		);

		return $fields;
	}
}




/*Dealer Cars Compare Settings options */
$this->sections[] = array(
		'title'            => esc_html__( 'Cars Submit Settings', 'idealauto' ),
		'id'               => 'cars-submit-settings',
		'subsection'       => true,
		'customizer_width' => '400px',
		'fields'           => array(
			 array(
                'id' => 'select-page-submit',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Submit', 'idealauto'),
                'desc' => esc_html__('Select page submit from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
            array (
				'id'       => 'jws_auto_publish',
				'type'     => 'switch',
				'title'    => esc_html__( 'Car Auto Publish', 'idealauto' ),
				'default'  => false
		    ),
        	array(
				'id'            => 'jws_cars_limit',
				'type'          => 'slider',
				'title'         => esc_html__( 'Vehicles limit', 'idealauto' ),
				'subtitle'      => esc_html__( 'Set max limit of the vehicles that user can add.', 'idealauto' ),
				'default'       => 10,
				'min'           => 0,
				'step'          => 0,
				'max'           => 500,
				'display_value' => 'text',
			),
            array(
					'id'            => 'jws_image_limit',
					'type'          => 'slider',
					'title'         => esc_html__( 'Vehicles Image limit', 'idealauto' ),
					'subtitle'      => esc_html__( 'Set max limit of the vehicles images that user can add for vehicle.', 'idealauto' ),
					'default'       => 10,
					'min'           => 0,
					'step'          => 0,
					'max'           => 100,
					'display_value' => 'text',
			),  
            array(
                'id' => 'jws_add_car_login_form',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('page'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Page Form Login', 'idealauto'),
                'desc' => esc_html__('Select Page Form Login Redirect From: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=page')) . '" target="_blank">Pages</a>',
            ),
            array (
				'id'       => 'car_submit_field',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Select field for car submit.', 'idealauto' ),
				'subtitle' => esc_html__( 'Choose which fields should be presented on the submit page.', 'idealauto' ),
				'options'  => jws_inventory_submit_field()
			),
            array (
				'id'       => 'car_sub_stamps',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Review Stamps', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_location',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Location', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_video',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Video', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_brochure',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Video', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_features',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Features', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_overview',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Overview', 'idealauto' ),
				'default'  => true
		    ),
            array (
				'id'       => 'car_sub_specifications',
				'type'     => 'switch',
				'title'    => esc_html__( 'Cars Specifications', 'idealauto' ),
				'default'  => true
		    ),
  
 		),
);
// Default Values Options
$this->sections[] = array(
		'title'            => esc_html__( 'Default Values', 'idealauto' ),
		'id'               => 'default_values',
		'subsection'       => true,
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'       => 'location-section-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Default location', 'idealauto' ),
				'subtitle' => esc_html__( 'This location will be the default used while adding new vehicle', 'idealauto' ),
				'indent'   => true,
			),
			array(
				'title'   => esc_html__( 'Latitude', 'idealauto' ),
				'desc'    => sprintf(
					wp_kses(
						/* translators: %s: url */
						__( 'The default latitude. <a href="%1$s"  target="_blank">Click here</a> to get the latitude', 'idealauto' ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						)
					),
					'https://www.latlong.net/'
				),
				'id'      => 'default_value_lat',
				'type'    => 'text',
				'default' => '43.653226',
			),
			array(
				'title'   => esc_html__( 'Longitude', 'idealauto' ),
				'desc'    => sprintf(
					wp_kses(
						/* translators: %s: url */
						__( 'The default longitude. <a href="%1$s"  target="_blank">Click here</a> to get the latitude', 'idealauto' ),
						array(
							'a' => array(
								'href'   => array(),
								'target' => array(),
							),
						)
					),
					'https://www.latlong.net/'
				),
				'id'      => 'default_value_long',
				'type'    => 'text',
				'default' => '-79.3831843',
			),

			array(
				'title'         => esc_html__( 'Zoom', 'idealauto' ),
				'desc'          => esc_html__( 'The default zoom level.', 'idealauto' ),
				'id'            => 'default_value_zoom',
				'type'          => 'slider',
				'default'       => '10',
				'min'           => 0,
				'max'           => 19,
				'step'          => 1,
				'display_value' => 'text',
			),
			array(
				'id'     => 'location-section-end',
				'type'   => 'section',
				'indent' => false,
			),
		),
);
// Car Form Settings Options.
$this->sections[] = array(
		'id'               => 'form_settings',
		'subsection'       => false,
		'title'            => esc_html__( 'Contact Forms', 'idealauto' ),
		'customizer_width' => '450px',
		'icon' => JWS_URI_PATH.'/assets/image/theme_option/001-checklist.png',
		'fields'           => array(
			array(
				'id'      => 'req_info_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide request info form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'req_info_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
                'required' => array( 'req_info_form_status', '=', true ),

			),
			array(
				'id'       => 'inq_mail_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
                'required' => array( 'req_info_form_status', '=', true ),
			),
			array(
				'id'       => 'inq_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
                'required' => array( 'req_info_form_status', '=', true ),
			),
			array(
				'id'       => 'inq_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - Inquiry Received', 'idealauto' ),
                'required' => array( 'req_info_form_status', '=', true ),
			),

	
			array(
				'id'       => 'inq_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
                'required' => array( 'req_info_form_status', '=', true ),

			
			),

			array(
				'id'       => 'inq_wid_html_mail_body',
				'type'     => 'editor',
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
				'title'    => esc_html__( 'HTML Body without product detail', 'idealauto' ),
				'subtitle' => esc_html__( 'Request more info form html mail body without product detail to be used in Inquiry Widget', 'idealauto' ),
				'desc'     => esc_html(	'From mail name : #JWS_FROM_NAME#,<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Mobile : #JWS_MOBILE#<br>Preferred Contact : #JWS_PREFERRED_CONTACT#'),
		        'required' => array( 'req_info_form_status', '=', true ),  
				'default'  => sprintf(
					wp_kses(
						__( '<p>Hello #JWS_FROM_NAME#,<br /><br />One Inquiry received.<br />Following are the information of the Inquiry :<br /><br />First Name : #JWS_FIRST_NAME#<br />Last Name : #JWS_LAST_NAME#<br />Email : #JWS_EMAIL#<br />Mobile : #JWS_MOBILE#<br />Preferred Contact : #JWS_PREFERRED_CONTACT#<br /><br />Thanks and Regards,<br />Idealauto Team</p>', 'idealauto' ),
						array( 'br' => array() )
					)
				),
			),

			array(
				'id'     => 'req_info_end',
				'type'   => 'section',
				'indent' => false,
			),
		),
);

$this->sections[] = array(
		'id'               => 'form_drive_test_settings',
		'subsection'       => true,
		'title'            => esc_html__( 'Driver Test Forms', 'idealauto' ),
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'      => 'schedule_drive_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide schedule drive form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'schedule_drive_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
			    'required' => array( 'schedule_drive_form_status', '=', true ), 
			),
			array(
				'id'       => 'std_mail_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
		      'required' => array( 'schedule_drive_form_status', '=', true ), 
			),
			array(
				'id'       => 'std_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
		        'required' => array( 'schedule_drive_form_status', '=', true ),   
			),
			array(
				'id'       => 'std_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - Test Drive Inquiry Received', 'idealauto' ),
		        'required' => array( 'schedule_drive_form_status', '=', true ), 
			),

			array(
				'id'       => 'std_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
				'required' => array( 'schedule_drive_form_status', '=', true ), 
			),
			array(
				'id'       => 'sstd_html_body',
				'type'     => 'editor',
				'title'    => esc_html__( 'HTML Mail Body', 'idealauto' ),
				'subtitle' => esc_html__( 'Schedule Test Drive Form HTML Mail Body', 'idealauto' ),
				'desc'     => sprintf(
					wp_kses(
						/* translators: %s: link */
						__(
							'Use <a href="#" class="JWS_dialog" data-id="std-1">this</a> variables to build or update mail body.
									<div id="std-1" class="variable-content" title="Schedule Test Drive"><p>%1$s</p></div>',
							'idealauto'
						),
						array(
							'a'   => array(
								'href'    => array(),
								'class'   => array(),
								'data-id' => array(),
							),
							'div' => array(
								'title' => array(),
								'id'    => array(),
								'class' => array(),
							),
							'p'   => array(),
							'br'  => array(),
						)
					),
					'From mail name :  #JWS_FROM_NAME#<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Mobile : #JWS_MOBILE#<br>Preferred Contact : #JWS_PREFERRED_CONTACT#<br>Test Drive?: #JWS_TEST_DRIVE#<br>Date : #JWS_DATE#<br>Time : #JWS_TIME#<br>Product Detail : #PRODUCT_DETAIL#'
				),
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
                'required' => array( 'schedule_drive_form_status', '=', true ), 
				'default'  => sprintf(
					wp_kses(
						__( 'Hello #JWS_FROM_NAME#,<br><br>One Inquiry received for Test Drive.<br>Following are the information of the Inquiry :<br><br>First Name : #JWS_FIRST_NAME#<br>Last Name  : #JWS_LAST_NAME#<br>Email      : #JWS_EMAIL#<br>Mobile       : #JWS_MOBILE#<br>Preferred Contact : #JWS_PREFERRED_CONTACT#<br>Test Drive?: #JWS_TEST_DRIVE#<br>Date       : #JWS_DATE#<br>Time       : #JWS_TIME#<br>Product Detail : #PRODUCT_DETAIL#<br><br><br>Thanks and Regards,<br>Idealauto Team', 'idealauto' ),
						array(
							'br' => array(),
							'br' => array(),
						)
					)
				),
			),

			array(
				'id'     => 'schedule_drive_end',
				'type'   => 'section',
				'indent' => false,
			),
            
		),
);   

$this->sections[] = array(
		'id'               => 'form_quote_settings',
		'subsection'       => true,
		'title'            => esc_html__( 'Quote Forms', 'idealauto' ),
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'      => 'quo_info_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide request info form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'quo_info_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
		        'required' => array( 'quo_info_form_status', '=', true ),   
			),
			array(
				'id'       => 'quo_mail_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
	            'required' => array( 'quo_info_form_status', '=', true ),    
			),
			array(
				'id'       => 'quo_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
	            'required' => array( 'quo_info_form_status', '=', true ),    
			),
			array(
				'id'       => 'quo_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - Quote Received', 'idealauto' ),
	            'required' => array( 'quo_info_form_status', '=', true ),    
			),

			array(
				'id'       => 'quo_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
			    'required' => array( 'quo_info_form_status', '=', true ),  
			),

			array(
				'id'       => 'quo_wid_html_mail_body',
				'type'     => 'editor',
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
				'title'    => esc_html__( 'HTML Body without product detail', 'idealauto' ),
				'subtitle' => esc_html__( 'Request more info form html mail body without product detail to be used in Quote Widget', 'idealauto' ),
				'desc'     => esc_html('From mail name : #JWS_FROM_NAME#,<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Mobile : #JWS_MOBILE#br>Preferred Contact : #JWS_PREFERRED_CONTACT#'),
			     'required' => array( 'quo_info_form_status', '=', true ), 
				'default'  => sprintf(
					wp_kses(
						__( '<p>Hello #JWS_FROM_NAME#,<br /><br />One Inquiry received for Quote.<br />Following are the information of the Quote :<br /><br />First Name : #JWS_FIRST_NAME#<br />Last Name : #JWS_LAST_NAME#<br />Email : #JWS_EMAIL#<br />Mobile : #JWS_MOBILE#<br />Address : #JWS_ADDRESS#<br />Preferred Contact : #JWS_PREFERRED_CONTACT#<br /><br />Thanks and Regards,<br />Idealauto Team</p>', 'idealauto' ),
						array( 'br' => array() )
					)
				),
			),
        )
);  

$this->sections[] = array(
		'id'               => 'form_offer_settings',
		'subsection'       => true,
		'title'            => esc_html__( 'Offer Forms', 'idealauto' ),
		'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'      => 'make_offer_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide make an offer form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'mao_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
                'required' => array( 'make_offer_form_status', '=', true ), 
			),
			array(
				'id'       => 'mao_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
                'required' => array( 'make_offer_form_status', '=', true ), 
			),
			array(
				'id'       => 'mao_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
		        'required' => array( 'make_offer_form_status', '=', true ),   
			),
			array(
				'id'       => 'mao_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - Make an Offer Inquiry Received', 'idealauto' ),
		        'required' => array( 'make_offer_form_status', '=', true ),  
			),

			array(
				'id'       => 'mao_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
			    'required' => array( 'make_offer_form_status', '=', true ),  
			),   
			array(
				'id'       => 'mmao_html_body',
				'type'     => 'editor',
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
				'title'    => esc_html__( 'HTML Mail Body', 'idealauto' ),
				'subtitle' => esc_html__( 'Make an Offer Form Mail Body', 'idealauto' ),
				'desc'     => sprintf(
					wp_kses(
						/* translators: %s: string */
						__(
							'Use <a href="#" class="JWS_dialog" data-id="mno-1">this</a> variables to build or update mail body.
									<div id="mno-1" class="variable-content" title="Make an Offer"><p>%1$s</p></div>',
							'idealauto'
						),
						array(
							'a'   => array(
								'href'    => array(),
								'class'   => array(),
								'data-id' => array(),
							),
							'div' => array(
								'title' => array(),
								'id'    => array(),
								'class' => array(),
							),
							'p'   => array(),
							'br'  => array(),
						)
					),
					'From mail name :  #JWS_FROM_NAME#<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Home Phone : #JWS_HOME_PHONE#<br>Request Price: #JWS_REQ_PRICE#<br>Product Detail :#PRODUCT_DETAIL#'
				),
		        'required' => array( 'make_offer_form_status', '=', true ),   
				'default'  => sprintf(
					wp_kses(
						__( '<p>Hello #JWS_FROM_NAME#,</p><br /><br /><p>One Inquiry received for Make an Offer.</p><p><br /> Following are the information of the Inquiry :</p><p><br /><br /><strong>First Name :</strong> #JWS_FIRST_NAME#<br /> <strong>Last Name :</strong> #JWS_LAST_NAME#<br /> <strong>Email :</strong> #JWS_EMAIL#<br/> <strong>Home Phone :</strong> #JWS_HOME_PHONE#<br />  <strong>Request Price:</strong> #JWS_REQ_PRICE#<br /><p><strong>product Detail :</strong></p><p>#PRODUCT_DETAIL#<br /><br /> Thanks and Regards,<br />Idealauto Team</p>', 'idealauto' ),
						array(
							'br' => array(),
							'br' => array(),
						)
					)
				),
			),

			array(
				'id'     => 'make_offer_end',
				'type'   => 'section',
				'indent' => false,
			),
            
            
		),
); 

$this->sections[] =	array(
		'id'               => 'form_availability_settings',
		'subsection'       => true,
		'title'            => esc_html__( 'Availability Forms', 'idealauto' ),
    		'customizer_width' => '450px',
    		'fields'           => array(
			array(
				'id'      => 'avai_info_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide request info form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'avai_info_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
	            'required' => array( 'avai_info_form_status', '=', true ),    
			),
			array(
				'id'       => 'avai_mail_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
	            'required' => array( 'avai_info_form_status', '=', true ),    
			),
			array(
				'id'       => 'avai_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
                'required' => array( 'avai_info_form_status', '=', true ), 
			),
			array(
				'id'       => 'avai_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - avaite Received', 'idealauto' ),
	            'required' => array( 'avai_info_form_status', '=', true ),    
			),

			array(
				'id'       => 'avai_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
			     'required' => array( 'avai_info_form_status', '=', true ), 
			),

			array(
				'id'       => 'avai_wid_html_mail_body',
				'type'     => 'editor',
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
				'title'    => esc_html__( 'HTML Body without product detail', 'idealauto' ),
				'subtitle' => esc_html__( 'Request more info form html mail body without product detail to be used in avaite Widget', 'idealauto' ),
				'desc'     => sprintf(
					wp_kses(
						/* translators: %s: string */
						__(
							'Use <a href="#" class="JWS_dialog" data-id="rmi-2">this</a> variables to build or update mail body.
									<div id="rmi-2" class="variable-content" title="Request More Info"><p>%1$s</p></div>',
							'idealauto'
						),
						array(
							'a'   => array(
								'href'    => array(),
								'class'   => array(),
								'data-id' => array(),
							),
							'div' => array(
								'title' => array(),
								'id'    => array(),
								'class' => array(),
							),
							'p'   => array(),
							'br'  => array(),
						)
					),
					'From mail name : #JWS_FROM_NAME#,<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Mobile : #JWS_MOBILE#<br>Preferred Contact : #JWS_PREFERRED_CONTACT#'
				),
			    'required' => array( 'avai_info_form_status', '=', true ), 
				'default'  => sprintf(
					wp_kses(
						__( '<p>Hello #JWS_FROM_NAME#,<br /><br />One Inquiry received for Availability.<br />Following are the information of the avaite :<br /><br />First Name : #JWS_FIRST_NAME#<br />Last Name : #JWS_LAST_NAME#<br />Email : #JWS_EMAIL#<br />Mobile : #JWS_MOBILE#<br />Preferred Contact : #JWS_PREFERRED_CONTACT#<br /><p><strong>product Detail :</strong></p><p>#PRODUCT_DETAIL#<br /><br />Thanks and Regards,<br />Idealauto Team</p>', 'idealauto' ),
						array( 'br' => array() )
					)
				),
			),
           
			array(
				'id'     => 'avai_info_end',
				'type'   => 'section',
				'indent' => false,
			),
       
            
		),
); 

$this->sections[] = array(
		'id'               => 'form_request_settings',
		'subsection'       => true,
		'title'            => esc_html__( 'Request Rent Forms', 'idealauto' ),
    	'customizer_width' => '450px',
		'fields'           => array(
			array(
				'id'      => 'request_info_form_status',
				'type'    => 'switch',
				'title'   => esc_html__( 'Enable / Disable', 'idealauto' ),
				'desc'    => esc_html__( 'Show/hide request info form for front end.', 'idealauto' ),
				'default' => true,
			),

			array(
				'id'       => 'request_info_policy_terms',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Policy and Terms', 'idealauto' ),
				'on'       => esc_html__( 'Yes', 'idealauto' ),
				'off'      => esc_html__( 'No', 'idealauto' ),
				'default'  => true,
                'required' => array( 'request_info_form_status', '=', true ),

			),
			array(
				'id'       => 'request_mail_from_name',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail Name', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer', 'idealauto' ),
                'required' => array( 'request_info_form_status', '=', true ),
			),
			array(
				'id'       => 'request_mail_id_from',
				'type'     => 'text',
				'title'    => esc_html__( 'From Mail ID', 'idealauto' ),
				'default'  => esc_html__( 'support@example.com', 'idealauto' ),
                'required' => array( 'request_info_form_status', '=', true ),
			),
			array(
				'id'       => 'request_subject',
				'type'     => 'text',
				'title'    => esc_html__( 'Mail Subject', 'idealauto' ),
				'default'  => esc_html__( 'Car Dealer - Inquiry Received', 'idealauto' ),
                'required' => array( 'request_info_form_status', '=', true ),
			),

	
			array(
				'id'       => 'request_html_mail_to',
				'type'     => 'text',
				'title'    => esc_html__( 'HTML Mail To', 'idealauto' ),
				'desc'     => esc_html__( 'You can add multiple email IDs separated by "," (comma).', 'idealauto' ),
                'required' => array( 'request_info_form_status', '=', true ),
                'default' => 'sample@gmail.com'

			
			),

			array(
				'id'       => 'request_wid_html_mail_body',
				'type'     => 'editor',
				'args'     => array(
					'teeny'         => false,
					'wpautop'       => false,
					'quicktags'     => 1,
					'textarea_rows' => 25,
				),
				'title'    => esc_html__( 'HTML Body without product detail', 'idealauto' ),
				'subtitle' => esc_html__( 'Request more info form html mail body without product detail to be used in Inquiry Widget', 'idealauto' ),
				'desc'     => esc_html(	'From mail name : #JWS_FROM_NAME#,<br>First Name : #JWS_FIRST_NAME#<br>Last Name : #JWS_LAST_NAME#<br>Email : #JWS_EMAIL#<br>Mobile : #JWS_MOBILE#<br>Preferred Contact : #JWS_PREFERRED_CONTACT#'),
		        'required' => array( 'request_info_form_status', '=', true ),  
				'default'  => sprintf(
					wp_kses(
						__( '<p>Hello #JWS_FROM_NAME#,<br /><br />First Name : #JWS_FIRST_NAME#<br />Last Name : #JWS_LAST_NAME#<br />Email : #JWS_EMAIL#<br />Mobile : #JWS_MOBILE#<br />Preferred Contact : #JWS_PREFERRED_CONTACT#<br />Comments : #JWS_COMMENT#</p>', 'idealauto' ),
						array( 'br' => array() )
					)
				),
			),

			array(
				'id'     => 'request_info_end',
				'type'   => 'section',
				'indent' => false,
			),
		),
);
// -> START 404
$this->sections[] = array(
    'title' => esc_html__('404 Page', 'idealauto'),
    'id' => '404_page',
    'desc' => esc_html__('Select Layout For 404 Page.', 'idealauto'),
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/010-404-error.png',
    'fields' => array(
         array(
            'id'       => '404-off-header',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Turn Off Header', 'idealauto'),
            'default'  => false,
        ),  
         array(
            'id'       => '404-off-footer',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Turn Off Footer', 'idealauto'),
            'default'  => false,
        ), 
         array(
            'id'       => '404-off-titlebar',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Turn Off TitleBar', 'idealauto'),
            'default'  => false,
        ),   
         array(
                'id' => 'select-content-404',
                'type' => 'select',
                'data' => 'posts',
                'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
                'title' => esc_html__('Select Content 404', 'idealauto'),
                'desc' => esc_html__('Select content 404 from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
         ),
    )
);
if ( ! function_exists( 'jws_product_available_fields' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_product_available_fields() {
		$product_attributes = array();
        $fields = array();
		if( function_exists( 'wc_get_attribute_taxonomies' ) ) {
			$product_attributes = wc_get_attribute_taxonomies();
		}
    
		if ( count( $product_attributes ) > 0 ) {
			foreach ( $product_attributes as $attribute ) {
				$fields[ 'pa_' . $attribute->attribute_name ] = $attribute->attribute_label;
			}	
		}

		return $fields;
	}
}
// -> START Shop
$this->sections[] = array(
    'title' => esc_html__('Shop', 'idealauto'),
    'id' => 'shop',
    'desc' => esc_html__('Select Layout For 404 Page.', 'idealauto'),
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/001-shopping-bag.png',
    'fields' => array( 
        array(
            'id' => 'select-header-shop',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for header elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for header elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'select-footer-shop',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for footer elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for footer elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
         array(
                'id'       => 'header_absolute_shop',
                'type'     => 'switch', 
                'title'    =>  esc_html__('Header Absolute', 'idealauto'),
                'default'  => true,
        ),
        array(
                'id'       => 'rental_mode',
                'type'     => 'switch', 
                'title'    =>  esc_html__('Enble Rental Mode', 'idealauto'),
                'default'  => false,
        ),
        array(
            'id' => 'exclude-product-in-shop',
            'type' => 'select',
            'multi' => true,
            'data' => 'posts',
            'args' => array('post_type' => array('product'), 'posts_per_page' => -1),
            'title' => esc_html__('Select product and remove in shop page', 'idealauto'),
        ), 
        array (
				'id'       => 'product_taxonomy_field',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Select taxonomy field for product filter.', 'idealauto' ),
				'subtitle' => esc_html__( 'Choose which fields should be presented on the filter.', 'idealauto' ),
				'options'  => array(
                        'enabled'  => jws_product_available_fields(),
                        'disabled' => array(
                        )
                )
		),
    )
);
$this->sections[] = array(
    'title' => esc_html__('Shop Page', 'idealauto'),
    'id' => 'shop_page',
    'subsection' => true,
    'fields' => array(
         array(
            'id' => 'select-titlebar-shop',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'shop_position_sidebar',
            'type' => 'select',
            'title' => esc_html__('Select Position Sidebar', 'idealauto'),
            'options' => array(
                'left' => 'Left',
                'right' => 'Right',
                'no_sidebar' => 'No Sidebar',
            ),
            'default' => 'no_sidebar',
        ),
        array(
            'id' => 'shop_layout',
            'type' => 'select',
            'title' => esc_html__('Archive Layout', 'idealauto'),
            'options' => array(
                'rent' => 'Layout For Renttal',
                'product' => 'Layout For Product',
            ),
            'default' => 'product',
        ),
        array(
            'id' => 'shop_position_sidebar',
            'type' => 'select',
            'title' => esc_html__('Select Position Sidebar', 'idealauto'),
            'options' => array(
                'left' => 'Left',
                'right' => 'Right',
                'no_sidebar' => 'No Sidebar',
            ),
            'default' => 'right',
        ),
          array(
            'id'       => 'shop-fullwidth-switch',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Switch On Shop Full Width', 'idealauto'),
            'subtitle' =>  esc_html__('Look, it\'s on!', 'idealauto'),
            'default'  => false,
        ),
         array(
            'id' => 'select-content-before-footer-shop-page',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select content before footer for archive', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id'=>'product_per_page',
            'type' => 'multi_text',
            'title' =>  esc_html__('Product Per Page', 'idealauto'),
            'subtitle' => __('Please enter the number', 'idealauto'),
            'validate' => 'no_html',
            'default' => array('9','12','18','24'),
        ),
        array(
            'id' => 'shop_columns',
            'type' => 'select',
            'title' => esc_html__('Select Columns Default', 'idealauto'),
            'options' => array(
                '1' => '1 Columns',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns',
            ),
            'default' => '3',
        ),
        array(
            'id'       => 'columns_review',
            'type'     => 'checkbox',
            'title'    => __('Columns Review', 'idealauto'), 
            'options'  => array(
                '1' => '1 Columns',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns'
            ),
            'default' => array(
                '1' => '1', 
                '2' => '0', 
                '3' => '1',
                '4' => '0'
            )
        )

    )
);
$this->sections[] = array(
    'title' => esc_html__('Shop Single', 'idealauto'),
    'id' => 'shop_single',
    'subsection' => true,
    'fields' => array(
         array(
            'id'       => 'product-single-title-bar-switch',
            'type'     => 'switch', 
            'title'    =>  esc_html__('Switch On Title Bar', 'idealauto'),
            'subtitle' =>  esc_html__('Look, it\'s on!', 'idealauto'),
            'default'  => true,
         ),   
         array(
            'id' => 'select-titlebar-shop-single',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for title bar elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for title bar elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
        array(
            'id' => 'shop_single_layout',
            'type' => 'select',
            'title' => esc_html__('Select Shop Layout', 'idealauto'),
            'options' => array(
                'rent' => 'Layout for rental',
                'product' => 'Product',
            ),
            'default' => 'product',
        ),
        array(
            'id' => 'shop_related_item',
            'type' => 'select',
            'title' => esc_html__('Select Related Item Number', 'idealauto'),
            'options' => array(
                '3' => '3 Item',
                '4' => '4 Item',
            ),
            'default' => '4',
        ),
        
    )
);

$this->sections[] = array(
    'title' => esc_html__('My Account', 'idealauto'),
    'id' => 'shop_account',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'select-shop-form-login',
            'type' => 'select',
            'data' => 'posts',
            'args' => array('post_type' => array('hf_template'), 'posts_per_page' => -1),
            'title' => esc_html__('Select layout for header elementor', 'idealauto'),
            'desc' => esc_html__('Select layout for header elementor from: ', 'idealauto') . '<a href="' . esc_url(admin_url('/edit.php?post_type=hf_template')) . '" target="_blank">Header Footer Template</a>',
        ),
    )
);

if ( ! function_exists( 'jws_compare_available_fields' ) ) {
	/**
	 * All available fields for Theme Settings sorter option.
	 *
	 * @since 4.5
	 */
	function jws_compare_available_fields() {
		$product_attributes = array();

		if( function_exists( 'wc_get_attribute_taxonomies' ) ) {
			$product_attributes = wc_get_attribute_taxonomies();
		}

		$fields = array(
			'enabled'  => array(
				'description' => esc_html__( 'Description', 'idealauto' ),
				'sku' => esc_html__( 'Sku', 'idealauto' ),
				'availability' => esc_html__( 'Availability', 'idealauto' ),
			),
			'disabled' => array(
				'weight' => esc_html__( 'Weight', 'idealauto' ),
				'dimensions' => esc_html__( 'Dimensions', 'idealauto' ),
			)
		);

		if ( count( $product_attributes ) > 0 ) {
			foreach ( $product_attributes as $attribute ) {
				$fields['disabled'][ 'pa_' . $attribute->attribute_name ] = $attribute->attribute_label;
			}	
		}

		return $fields;
	}
}



$this->sections[] = array(
    'title' => esc_html__('Compare', 'idealauto'),
    'id' => 'compare',
    'subsection' => true,
    'fields' => array(
       			array (
				'id'       => 'compare',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable compare', 'idealauto' ),
				'subtitle' => esc_html__( 'Enable compare functionality built in with the theme. Read more information in our documentation.', 'idealauto' ),
				'default'  => true
			),
			array(
				'id'       => 'compare_page',
				'type'     => 'select',
				'multi'    => false,
				'data'     => 'posts',
				'args'     => array( 'post_type' =>  array( 'page' ), 'numberposts' => -1 ),
				'title'    => esc_html__( 'Compare page', 'idealauto' ),
				'subtitle' => esc_html__( 'Select a page for compare table. It should contain the shortcode shortcode: [idealauto_compare]', 'idealauto' ),
			),
			array (
				'id'       => 'compare_on_grid',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show button on product grid', 'idealauto' ),
				'subtitle' => esc_html__( 'Display compare product button on all products grids and lists.', 'idealauto' ),
				'default'  => true
			),
			array (
				'id'       => 'fields_compare',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Select fields for compare table', 'idealauto' ),
				'subtitle' => esc_html__( 'Choose which fields should be presented on the product compare page with table.', 'idealauto' ),
				'options'  => jws_compare_available_fields()
			),
			array (
				'id'       => 'empty_compare_text',
				'type'     => 'textarea',
				'title'    => esc_html__('Empty compare text', 'idealauto'),
				'subtitle' => esc_html__('Text will be displayed if user don\'t add any products to compare', 'idealauto'),      
				'default'  => 'No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our "Shop" page.',
				'class'   => 'without-border'
			),
    )
);

$this->sections[] = array(
    'title' => esc_html__('Wishlist', 'idealauto'),
    'id' => 'wishlist',
    'subsection' => true,
    'fields' => array(
       			array (
				'id'       => 'wishlist',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable wishlist', 'idealauto' ),
				'subtitle' => esc_html__( 'Enable wishlist functionality built in with the theme. Read more information in our documentation.', 'idealauto' ),
				'default'  => true
			),
			array(
				'id'       => 'wishlist_page',
				'type'     => 'select',
				'multi'    => false,
				'data'     => 'posts',
				'args'     => array( 'post_type' =>  array( 'page' ), 'numberposts' => -1 ),
				'title'    => esc_html__( 'Compare page', 'idealauto' ),
				'subtitle' => esc_html__( 'Select a page for wishlist table. It should contain the shortcode shortcode: [idealauto_wishlist]', 'idealauto' ),
			),
			array (
				'id'       => 'empty_wishlist_text',
				'type'     => 'textarea',
				'title'    => esc_html__('Empty wishlist text', 'idealauto'),
				'subtitle' => esc_html__('Text will be displayed if user don\'t add any products to wishlist', 'idealauto'),      
				'default'  => 'No products added in the wishlist list. You must add some products to wishlist them.<br> You will find a lot of interesting products on our "Shop" page.',
				'class'   => 'without-border'
			),
    )
);

// -> START Typography
$this->sections[] = array(
    'title' => esc_html__('Typography', 'idealauto'),
    'id' => 'typography',
    'desc' => esc_html__('For full documentation on this field, visit: ', 'idealauto') . '<a href="//docs.reduxframework.com/core/fields/typography/" target="_blank">docs.reduxframework.com/core/fields/typography/</a>',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/002-text.png',
    'fields' => array(
        array(
            'id' => 'opt-typography-body',
            'type' => 'typography',
            'title' => esc_html__('Body Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the body font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('body'),
            'default' => array(
                'font-size' => '17px',
                'font-family' => 'Heebo',
                'font-weight' => '400',
                'line-height' => '28px'
            ),
        ),
        
        array(
            'id' => 'opt-typography-h1',
            'type' => 'typography',
            'title' => esc_html__('H1 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h1 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h1'),
        ),
        array(
            'id' => 'opt-typography-h2',
            'type' => 'typography',
            'title' => esc_html__('H2 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h2 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h2'),
        ),
        array(
            'id' => 'opt-typography-h3',
            'type' => 'typography',
            'title' => esc_html__('H3 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h3 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h3'),
        ),
        array(
            'id' => 'opt-typography-h4',
            'type' => 'typography',
            'title' => esc_html__('H4 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h4 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h4'),
        ),
        array(
            'id' => 'opt-typography-h5',
            'type' => 'typography',
            'title' => esc_html__('H5 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h5 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h5'),
        ),
        array(
            'id' => 'opt-typography-h6',
            'type' => 'typography',
            'title' => esc_html__('H6 Font', 'idealauto'),
            'subtitle' => esc_html__('Specify the h6 font properties.', 'idealauto'),
            'google' => true,
            'color' => false,
            'output' => array('h6'),
        ),
  
  
  
  
    )
);

// -> START API Fields
$this->sections[] = array(
    'title' => esc_html__('API And Other Setting', 'idealauto'),
    'id' => 'api',
    'customizer_width' => '300px',
    'icon' => JWS_URI_PATH.'/assets/image/theme_option/003-api.png',
    'fields' => array(
        array(
    		'id'     => 'google-api-section-start',
    		'type'   => 'section',
    		'title'  => esc_html__( 'Google Settings', 'idealauto' ),
    		'indent' => true,
    	),
        array(
            'id' => 'google_api',
            'type' => 'text',
            'title' => esc_html__('Google API', 'idealauto'),
            'default' => '',
        ),
        array(
    		'id'     => 'google-api-section-end',
    		'type'   => 'section',
    		'indent' => false,
    	),
    
    	array(
    		'id'     => 'google-captcha-section-start',
    		'type'   => 'section',
    		'title'  => esc_html__( 'Google Captcha Settings', 'idealauto' ),
    		'indent' => true,
    	),
    	array(
    		'id'       => 'google_captcha_site_key',
    		'type'     => 'text',
    		'title'    => esc_html__( 'Site Key', 'idealauto' ),
    		'subtitle' => sprintf(
    			wp_kses(
    				/* translators: %s: url */
    				__( 'You can get more information on Google Captcha at <a href="%1$s" target="_blank">here</a>', 'idealauto' ),
    				array(
    					'a' => array(
    						'href'   => array(),
    						'target' => array(),
    					),
    				)
    			),
    			esc_url( 'https://developers.google.com/recaptcha/' )
    		),
    	),
    	array(
    		'id'       => 'google_captcha_secret_key',
    		'type'     => 'text',
    		'title'    => esc_html__( 'Secret Key', 'idealauto' ),
    		'subtitle' => esc_html__( 'Google Captcha Secret Key', 'idealauto' ),
    	),
    	array(
    		'id'     => 'google-captcha-section-end',
    		'type'   => 'section',
    		'indent' => false,
    	),
        array(
    		'id'     => 'instagram-token-section-start',
    		'type'   => 'section',
    		'title'  => esc_html__( 'Instagram Settings', 'idealauto' ),
    		'indent' => true,
    	),
        array(
            'id' => 'instagram_token',
            'type' => 'text',
            'title' => esc_html__('Instagram Token', 'idealauto'),
            'default' => '',
        ),
   
   
    )
);

if (file_exists(dirname(__FILE__) . '/../README.md')) {
    $this->sections[] = array(
        'icon' => 'el el-list-alt',
        'title' => esc_html__('Documentation', 'idealauto'),
        'fields' => array(
            array(
                'id' => '17',
                'type' => 'raw',
                'markdown' => true,
                'content_path' => dirname(__FILE__) . '/../README.md', // FULL PATH, not relative please
                //'content' => 'Raw content here',
            ),
        ),
    );

}
				
            }

            public function setHelpTabs() {

                // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
                $this->args['help_tabs'][] = array(
                    'id'      => 'redux-help-tab-1',
                    'title'   => __( 'Theme Information 1', 'idealauto' ),
                    'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'idealauto' )
                );

                $this->args['help_tabs'][] = array(
                    'id'      => 'redux-help-tab-2',
                    'title'   => __( 'Theme Information 2', 'idealauto' ),
                    'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'idealauto' )
                );

                // Set the help sidebar
                $this->args['help_sidebar'] = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'idealauto' );
            }

            /**
             * All the possible arguments for Redux.
             * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
             * */
            public function setArguments() {

                $theme = wp_get_theme(); // For use with some settings. Not necessary.

                $this->args = array(
                    // TYPICAL -> Change these values as you need/desire
                    'opt_name'             => 'jws_option',
                    // This is where your data is stored in the database and also becomes your global variable name.
                    'display_name'         => $theme->get( 'Name' ),
                    // Name that appears at the top of your panel
                    'display_version'      => $theme->get( 'Version' ),
                    // Version that appears at the top of your panel
                    'menu_type'            => 'submenu',
                    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
                    'allow_sub_menu'       => true,
                    // Show the sections below the admin menu item or not
                    'menu_title'           => __( 'Theme Options', 'idealauto' ),
                    'page_title'           => __( 'Theme Options', 'idealauto' ),
                    // You will need to generate a Google API key to use this feature.
                    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
                    'google_api_key'       => '',
                    // Set it you want google fonts to update weekly. A google_api_key value is required.
                    'google_update_weekly' => false,
                    // Must be defined to add google fonts to the typography module
                    'async_typography'     => true,
                    // Use a asynchronous font on the front end or font string
                    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
                    'admin_bar'            => true,
                    // Show the panel pages on the admin bar
                    'admin_bar_icon'     => 'dashicons-portfolio',
                    // Choose an icon for the admin bar menu
                    'admin_bar_priority' => 50,
                    // Choose an priority for the admin bar menu
                    'global_variable'      => '',
                    // Set a different name for your global variable other than the opt_name
                    'dev_mode'             => false,
                    // Show the time the page took to load, etc
                    'update_notice'        => false,
                    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
                    'customizer'           => true,
                    // Enable basic customizer support
                    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
                    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

                    // OPTIONAL -> Give you extra features
                    'page_priority'        => null,
                    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
                    'page_parent'          => 'jws_settings.php',
                    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
                    'page_permissions'     => 'manage_options',
                    // Permissions needed to access the options panel.
                    'menu_icon'            => '',
                    // Specify a custom URL to an icon
                    'last_tab'             => '',
                    // Force your panel to always open to a specific tab (by id)
                    'page_icon'            => 'icon-themes',
                    // Icon displayed in the admin panel next to your menu_title
                    'page_slug'            => 'jws_option',
                    // Page slug used to denote the panel
                    'save_defaults'        => true,
                    // On load save the defaults to DB before user clicks save or not
                    'default_show'         => false,
                    // If true, shows the default value next to each field that is not the default value.
                    'default_mark'         => '',
                    // What to print by the field's title if the value shown is default. Suggested: *
                    'show_import_export'   => true,
                    // Shows the Import/Export panel when not used as a field.

                    // CAREFUL -> These options are for advanced use only
                    'transient_time'       => 60 * MINUTE_IN_SECONDS,
                    'output'               => true,
                    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
                    'output_tag'           => true,
                    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
                    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

                    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
                    'database'             => '',
                    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
                    'system_info'          => false,
                    // REMOVE

                    // HINTS
                    'hints'                => array(
                        'icon'          => 'icon-question-sign',
                        'icon_position' => 'right',
                        'icon_color'    => 'lightgray',
                        'icon_size'     => 'normal',
                        'tip_style'     => array(
                            'color'   => 'light',
                            'shadow'  => true,
                            'rounded' => false,
                            'style'   => '',
                        ),
                        'tip_position'  => array(
                            'my' => 'top left',
                            'at' => 'bottom right',
                        ),
                        'tip_effect'    => array(
                            'show' => array(
                                'effect'   => 'slide',
                                'duration' => '500',
                                'event'    => 'mouseover',
                            ),
                            'hide' => array(
                                'effect'   => 'slide',
                                'duration' => '500',
                                'event'    => 'click mouseleave',
                            ),
                        ),
                    )
                );
				
                // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
                $this->args['share_icons'][] = array(
                    'url'   => '#',
                    'title' => 'Visit us on GitHub',
                    'icon'  => 'el-icon-github'
                    //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
                );
                $this->args['share_icons'][] = array(
                    'url'   => '#',
                    'title' => 'Like us on Facebook',
                    'icon'  => 'el-icon-facebook'
                );
                $this->args['share_icons'][] = array(
                    'url'   => '#',
                    'title' => 'Follow us on Twitter',
                    'icon'  => 'el-icon-twitter'
                );
                $this->args['share_icons'][] = array(
                    'url'   => '#',
                    'title' => 'Find us on LinkedIn',
                    'icon'  => 'el-icon-linkedin'
                );
            }

            public function validate_callback_function( $field, $value, $existing_value ) {
                $error = true;
                $value = 'just testing';

                /*
              do your validation

              if(something) {
                $value = $value;
              } elseif(something else) {
                $error = true;
                $value = $existing_value;
                
              }
             */

                $return['value'] = $value;
                $field['msg']    = 'your custom error message';
                if ( $error == true ) {
                    $return['error'] = $field;
                }

                return $return;
            }

            public function class_field_callback( $field, $value ) {
                print_r( $field );
                echo '<br/>CLASS CALLBACK';
                print_r( $value );
            }

        }

        global $reduxConfig;
        $reduxConfig = new Redux_Framework_theme_config();
    } else {
        echo "The class named Redux_Framework_theme_config has already been called. <strong>Developers, you need to prefix this class with your company name or you'll run into problems!</strong>";
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ):
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    endif;

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ):
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error = true;
            $value = 'just testing';

            /*
          do your validation

          if(something) {
            $value = $value;
          } elseif(something else) {
            $error = true;
            $value = $existing_value;
            
          }
         */

            $return['value'] = $value;
            $field['msg']    = 'your custom error message';
            if ( $error == true ) {
                $return['error'] = $field;
            }

            return $return;
        }
    endif;


    if( ! function_exists('jws_theme_get_option') ){
        function jws_theme_get_option($name, $default=false){
            global $jws_option;
            return isset( $jws_option[ $name ] ) ? $jws_option[ $name ] : $default;
        }
    }

    if( ! function_exists('jws_theme_update_option') ){
        function jws_theme_update_option($name, $value){
            global $jws_option;
            $jws_option[ $name ] = $value;
        }
    }

