<?php // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

    function jws_register_services() {
        
		$labels = array(
			'name'                => _x( 'Services', 'Post Type General Name', 'idealauto' ),
			'singular_name'       => _x( 'Services', 'Post Type Singular Name', 'idealauto' ),
			'menu_name'           => esc_html__( 'Services', 'idealauto' ),
			'parent_item_colon'   => esc_html__( 'Parent Item:', 'idealauto' ),
			'all_items'           => esc_html__( 'All Items', 'idealauto' ),
			'view_item'           => esc_html__( 'View Item', 'idealauto' ),
			'add_new_item'        => esc_html__( 'Add New Item', 'idealauto' ),
			'add_new'             => esc_html__( 'Add New', 'idealauto' ),
			'edit_item'           => esc_html__( 'Edit Item', 'idealauto' ),
			'update_item'         => esc_html__( 'Update Item', 'idealauto' ),
			'search_items'        => esc_html__( 'Search Item', 'idealauto' ),
			'not_found'           => esc_html__( 'Not found', 'idealauto' ),
			'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'idealauto' ),
		);

		$args = array(
			'label'               => esc_html__( 'services', 'idealauto' ),
		    'labels'              => $labels,
            'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail','page-attributes', 'post-formats', 'revisions'),
            'taxonomies'          => array( 'services_cat' ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => ''.JWS_URI_PATH.'/assets/image/posttyle_icon/service_icon_type.png',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
		);


        if(function_exists('custom_reg_post_type')){
        	custom_reg_post_type( 'services', $args );
        }

		/**
		 * Create a taxonomy category for services
		 *
		 * @uses  Inserts new taxonomy object into the list
		 * @uses  Adds query vars
		 *
		 * @param string  Name of taxonomy object
		 * @param array|string  Name of the object type for the taxonomy object.
		 * @param array|string  Taxonomy arguments
		 * @return null|WP_Error WP_Error if errors, otherwise null.
		 */
		
		$labels = array(
			'name'					=> _x( 'Services Categories', 'Taxonomy plural name', 'idealauto' ),
			'singular_name'			=> _x( 'Services Category', 'Taxonomy singular name', 'idealauto' ),
			'search_items'			=> esc_html__( 'Search Categories', 'idealauto' ),
			'popular_items'			=> esc_html__( 'Popular services Categories', 'idealauto' ),
			'all_items'				=> esc_html__( 'All services Categories', 'idealauto' ),
			'parent_item'			=> esc_html__( 'Parent Category', 'idealauto' ),
			'parent_item_colon'		=> esc_html__( 'Parent Category', 'idealauto' ),
			'edit_item'				=> esc_html__( 'Edit Category', 'idealauto' ),
			'update_item'			=> esc_html__( 'Update Category', 'idealauto' ),
			'add_new_item'			=> esc_html__( 'Add New Category', 'idealauto' ),
			'new_item_name'			=> esc_html__( 'New Category', 'idealauto' ),
			'add_or_remove_items'	=> esc_html__( 'Add or remove Categories', 'idealauto' ),
			'choose_from_most_used'	=> esc_html__( 'Choose from most used text-domain', 'idealauto' ),
			'menu_name'				=> esc_html__( 'Category', 'idealauto' ),
		);
	
		$args = array(
			'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'services_cat' ),
		);
        

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'services_cat', array( 'services' ), $args  );
        }
        
        $labels = array(
            'name' => esc_html__( 'Tags', 'idealauto' ),
            'singular_name' => esc_html__( 'Tag',  'idealauto'  ),
            'search_items' =>  esc_html__( 'Search Tags' , 'idealauto' ),
            'popular_items' => esc_html__( 'Popular Tags' , 'idealauto' ),
            'all_items' => esc_html__( 'All Tags' , 'idealauto' ),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => esc_html__( 'Edit Tag' , 'idealauto' ), 
            'update_item' => esc_html__( 'Update Tag' , 'idealauto' ),
            'add_new_item' => esc_html__( 'Add New Tag' , 'idealauto' ),
            'new_item_name' => esc_html__( 'New Tag Name' , 'idealauto' ),
            'separate_items_with_commas' => esc_html__( 'Separate tags with commas' , 'idealauto' ),
            'add_or_remove_items' => esc_html__( 'Add or remove tags' , 'idealauto' ),
            'choose_from_most_used' => esc_html__( 'Choose from the most used tags' , 'idealauto' ),
            'menu_name' => esc_html__( 'Tags','idealauto'),
        ); 
    
        $args = array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array( 'slug' => 'services_tag' ),
        );
        
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'services_tag', array( 'services' ), $args  );
        }

	};
add_action( 'init', 'jws_register_services', 1 );

function add_featured_image_column_services($defaults) {
    $defaults['featured_image'] = 'Featured Image';
    return $defaults;
}
add_filter('manage_services_posts_columns', 'add_featured_image_column_services');
 
function show_featured_image_column_services($column_name, $post_id) {
    if ($column_name == 'featured_image') {
        echo get_the_post_thumbnail($post_id, 'thumbnail'); 
    }
}
add_action('manage_services_posts_custom_column', 'show_featured_image_column_services', 10, 2); 
