<?php // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

    function jws_register_inventory() {
        global $jws_option;
		$labels = array(
			'name'                => _x( 'inventory', 'Post Type General Name', 'idealauto' ),
			'singular_name'       => _x( 'inventory', 'Post Type Singular Name', 'idealauto' ),
			'menu_name'           => esc_html__( 'Inventory', 'idealauto' ),
			'parent_item_colon'   => esc_html__( 'Parent Item:', 'idealauto' ),
			'all_items'           => esc_html__( 'All Items', 'idealauto' ),
			'view_item'           => esc_html__( 'View Item', 'idealauto' ),
			'add_new_item'        => esc_html__( 'Add New Item', 'idealauto' ),
			'add_new'             => esc_html__( 'Add New', 'idealauto' ),
			'edit_item'           => esc_html__( 'Edit Item', 'idealauto' ),
			'update_item'         => esc_html__( 'Update Item', 'idealauto' ),
			'search_items'        => esc_html__( 'Search Item', 'idealauto' ),
			'not_found'           => esc_html__( 'Not found', 'idealauto' ),
			'not_found_in_trash'  => esc_html__( 'Not found in Trash', 'idealauto' ),
		);

		$args = array(
			'label'               => esc_html__( 'Inventory', 'idealauto' ),
		    'labels'              => $labels,
            'supports'            => array( 'title', 'editor', 'excerpt','page-attributes', 'post-formats','author' , 'custom-fields' , 'revisions' ),
            'taxonomies'          => array( 'cars_cat' ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'menu_icon'           => ''.JWS_URI_PATH.'/assets/image/posttyle_icon/inventory_icon_type.png',
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page',
         
		);


        if(function_exists('custom_reg_post_type')){
        	custom_reg_post_type( 'cars', $args );
        }

		/**
		 * Create a taxonomy category for inventory
		 *
		 * @uses  Inserts new taxonomy object into the list
		 * @uses  Adds query vars
		 *
		 * @param string  Name of taxonomy object
		 * @param array|string  Name of the object type for the taxonomy object.
		 * @param array|string  Taxonomy arguments
		 * @return null|WP_Error WP_Error if errors, otherwise null.
		 */
		
		$labels = array(
			'name'					=> _x( 'inventory Categories', 'Taxonomy plural name', 'idealauto' ),
			'singular_name'			=> _x( 'inventoryCategory', 'Taxonomy singular name', 'idealauto' ),
			'search_items'			=> esc_html__( 'Search Categories', 'idealauto' ),
			'popular_items'			=> esc_html__( 'Popular inventory Categories', 'idealauto' ),
			'all_items'				=> esc_html__( 'All inventory Categories', 'idealauto' ),
			'parent_item'			=> esc_html__( 'Parent Category', 'idealauto' ),
			'parent_item_colon'		=> esc_html__( 'Parent Category', 'idealauto' ),
			'edit_item'				=> esc_html__( 'Edit Category', 'idealauto' ),
			'update_item'			=> esc_html__( 'Update Category', 'idealauto' ),
			'add_new_item'			=> esc_html__( 'Add New Category', 'idealauto' ),
			'new_item_name'			=> esc_html__( 'New Category', 'idealauto' ),
			'add_or_remove_items'	=> esc_html__( 'Add or remove Categories', 'idealauto' ),
			'choose_from_most_used'	=> esc_html__( 'Choose from most used text-domain', 'idealauto' ),
			'menu_name'				=> esc_html__( 'Category', 'idealauto' ),
		);
	
		$args = array(
			'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'car_cat' ),
		);
        

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_cat', array( 'cars' ), $args  );
        }
        
        $labels = array(
            'name' => esc_html__( 'Tags', 'idealauto' ),
            'singular_name' => esc_html__( 'Tag',  'idealauto'  ),
            'search_items' =>  esc_html__( 'Search Tags' , 'idealauto' ),
            'popular_items' => esc_html__( 'Popular Tags' , 'idealauto' ),
            'all_items' => esc_html__( 'All Tags' , 'idealauto' ),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => esc_html__( 'Edit Tag' , 'idealauto' ), 
            'update_item' => esc_html__( 'Update Tag' , 'idealauto' ),
            'add_new_item' => esc_html__( 'Add New Tag' , 'idealauto' ),
            'new_item_name' => esc_html__( 'New Tag Name' , 'idealauto' ),
            'separate_items_with_commas' => esc_html__( 'Separate tags with commas' , 'idealauto' ),
            'add_or_remove_items' => esc_html__( 'Add or remove tags' , 'idealauto' ),
            'choose_from_most_used' => esc_html__( 'Choose from the most used tags' , 'idealauto' ),
            'menu_name' => esc_html__( 'Tags','idealauto'),
        ); 
    
        $args = array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array( 'slug' => 'inventory_tag' ),
        );
        
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'inventory_tag', array( 'inventory' ), $args  );
        }
        // Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Year', 'idealauto' ),
			'singular_name'              => esc_html__( 'Year', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Year', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Year', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Year', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Year', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Year', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Year', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Year Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate year with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Year', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Year', 'idealauto' ),
			'not_found'                  => esc_html__( 'No year found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Year', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'year' ),
		);


        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_year', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Make', 'idealauto' ),
			'singular_name'              => esc_html__( 'Make', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Make', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Make', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Make', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Make', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Make', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Make', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Make Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate make with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Make', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Make', 'idealauto' ),
			'not_found'                  => esc_html__( 'No make found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Make', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'make' ),
		);

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_make', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Model', 'idealauto' ),
			'singular_name'              => esc_html__( 'Model', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Model', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Model', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Model', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Model', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Model', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Model', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Model Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate model with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Model', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Model', 'idealauto' ),
			'not_found'                  => esc_html__( 'No model found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Model', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'model' ),
		);

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_model', array( 'cars' ), $args  );
        }
        
		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Body Style', 'idealauto' ),
			'singular_name'              => esc_html__( 'Body Style', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Body Style', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Body Style', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Body Style', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Body Style', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Body Style', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Body Style', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Body Style Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate body style with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove body style', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used body style', 'idealauto' ),
			'not_found'                  => esc_html__( 'No body style found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Body Style', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => true,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'body-style' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_body_style', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Mileage', 'idealauto' ),
			'singular_name'              => esc_html__( 'Mileage', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Mileage', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Mileage', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Mileage', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Mileage', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Mileage', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Mileage', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Mileage Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate mileage with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Mileage', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Mileage', 'idealauto' ),
			'not_found'                  => esc_html__( 'No mileage found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Mileage', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'mileage' ),
		);

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_mileage', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Transmission', 'idealauto' ),
			'singular_name'              => esc_html__( 'Transmission', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Transmission', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Transmission', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Transmission', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Transmission', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Transmission', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Transmission', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Transmission Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate transmission with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Transmission', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Transmission', 'idealauto' ),
			'not_found'                  => esc_html__( 'No transmission found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Transmission', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'transmission' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_transmission', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Condition', 'idealauto' ),
			'singular_name'              => esc_html__( 'Condition', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Condition', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Condition', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Condition', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Condition', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Condition', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Condition', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Condition Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate condition with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Condition', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Condition', 'idealauto' ),
			'not_found'                  => esc_html__( 'No condition found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Condition', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'condition' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_condition', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Drivetrain', 'idealauto' ),
			'singular_name'              => esc_html__( 'Drivetrain', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Drivetrain', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Drivetrain', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Drivetrain', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Drivetrain', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Drivetrain', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Drivetrain', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Drivetrain Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate drivetrain with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Drivetrain', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Drivetrain', 'idealauto' ),
			'not_found'                  => esc_html__( 'No drivetrain found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Drivetrain', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'drivetrain' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_drivetrain', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Engine', 'idealauto' ),
			'singular_name'              => esc_html__( 'Engine', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Engine', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Engine', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Engine', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Engine', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Engine', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Engine', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Engine Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate engine with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Engine', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Engine', 'idealauto' ),
			'not_found'                  => esc_html__( 'No engine found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Engine', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'engine' ),
		);

        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_engine', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Fuel Economy', 'idealauto' ),
			'singular_name'              => esc_html__( 'Fuel Economy', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Fuel Economy', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Fuel Economy', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Fuel Economy', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Fuel Economy', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Fuel Economy', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Fuel Economy', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Fuel Economy Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate fuel-economy with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Fuel Economy', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Fuel Economy', 'idealauto' ),
			'not_found'                  => esc_html__( 'No fuel-economy found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Fuel Economy', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'fuel-economy' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_fuel_economy', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Exterior Color', 'idealauto' ),
			'singular_name'              => esc_html__( 'Exterior Color', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Exterior Color', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Exterior Color', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Exterior Color', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Exterior Color', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Exterior Color', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Exterior Color', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Exterior Color Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate exterior-color with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Exterior Color', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Exterior Color', 'idealauto' ),
			'not_found'                  => esc_html__( 'No exterior-color found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Exterior Color', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'exterior-color' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_exterior_color', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Interior Color', 'idealauto' ),
			'singular_name'              => esc_html__( 'Interior Color', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Interior Color', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Interior Color', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Interior Color', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Interior Color', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Interior Color', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Interior Color', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Interior Color Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate interior-color with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Interior Color', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Interior Color', 'idealauto' ),
			'not_found'                  => esc_html__( 'No interior-color found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Interior Color', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'interior-color' ),
		);
		
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_interior_color', array( 'cars' ), $args  );
        }
        
        
        $labels = array(
			'name'                       => esc_html__( 'Drive Train', 'idealauto' ),
			'singular_name'              => esc_html__( 'Drive Train', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Drive Train', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Drive Train', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Drive Train', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Drive Train', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Drive Train', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Drive Train', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Drive Train Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate drive-train with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Drive Train', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Drive Train', 'idealauto' ),
			'not_found'                  => esc_html__( 'No drive-train found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Drive Train', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'drive-train' ),
		);
		
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_drive_train', array( 'cars' ), $args  );
        }
        
        $labels = array(
			'name'                       => esc_html__( 'Registered', 'idealauto' ),
			'singular_name'              => esc_html__( 'Registered', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Registered', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Registered', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Registered', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Registered', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Registered', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Registered', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Registered Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate registered with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Registered', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Registered', 'idealauto' ),
			'not_found'                  => esc_html__( 'No registered found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Registered', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'registered' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_registered', array( 'cars' ), $args  );
        }
        
        $labels = array(
			'name'                       => esc_html__( 'Door Number', 'idealauto' ),
			'singular_name'              => esc_html__( 'Door Number', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Door Number', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Door Number', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Door Number', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Door Number', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Door Number', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Door Number', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Door Number Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate Door Number with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Door Number', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Door Number', 'idealauto' ),
			'not_found'                  => esc_html__( 'No Door Number found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Door Number', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'Door Number' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_door_number', array( 'cars' ), $args  );
        }
        
        $labels = array(
			'name'                       => esc_html__( 'Seat Number', 'idealauto' ),
			'singular_name'              => esc_html__( 'Seat Number', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Seat Number', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Seat Number', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Seat Number', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Seat Number', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Seat Number', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Seat Number', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Seat Number Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate Seat Number with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Seat Number', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Seat Number', 'idealauto' ),
			'not_found'                  => esc_html__( 'No Seat Number found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Seat Number', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'Seat Number' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_seat_number', array( 'cars' ), $args  );
        }
        
		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Stock Number', 'idealauto' ),
			'singular_name'              => esc_html__( 'Stock Number', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Stock Number', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Stock Number', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Stock Number', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Stock Number', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Stock Number', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Stock Number', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Stock Number Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate stock-number with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Stock Number', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Stock Number', 'idealauto' ),
			'not_found'                  => esc_html__( 'No stock-number found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Stock Number', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'stock-number' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_stock_number', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'VIN Number', 'idealauto' ),
			'singular_name'              => esc_html__( 'VIN Number', 'idealauto' ),
			'search_items'               => esc_html__( 'Search VIN Number', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular VIN Number', 'idealauto' ),
			'all_items'                  => esc_html__( 'All VIN Number', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit VIN Number', 'idealauto' ),
			'update_item'                => esc_html__( 'Update VIN Number', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New VIN Number', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New VIN Number Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate vin-number with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove VIN Number', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used VIN Number', 'idealauto' ),
			'not_found'                  => esc_html__( 'No vin-number found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'VIN Number', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'vin-number' ),
		);
	
        if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_vin_number', array( 'cars' ), $args  );
        }

		$labels = array(
			'name'                       => esc_html__( 'Fuel Type', 'idealauto' ),
			'singular_name'              => esc_html__( 'Fuel Type', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Fuel Type', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Fuel Type', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Fuel Type', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Fuel Type', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Fuel Type', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Fuel Type', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Fuel Type Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate fuel-type with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Fuel Type', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Fuel Type', 'idealauto' ),
			'not_found'                  => esc_html__( 'No fuel-type found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Fuel Type', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'fuel-type' ),
		);
	
         if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_fuel_type', array( 'cars' ), $args  );
        }

		$labels = array(
			'name'                       => esc_html__( 'Trim', 'idealauto' ),
			'singular_name'              => esc_html__( 'Trim', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Trim', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Trim', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Trim', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Trim', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Trim', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Trim', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Trim Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate trim-type with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Trim', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Trim', 'idealauto' ),
			'not_found'                  => esc_html__( 'No trim found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Trim', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'trim' ),
		);

         if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_trim', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Features & Options', 'idealauto' ),
			'singular_name'              => esc_html__( 'Features & Options', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Features & Options', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Features & Options', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Features & Options', 'idealauto' ),
			'parent_item'                => esc_html__( 'Parent Feature', 'idealauto' ),
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Features & Options', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Features & Options', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Features & Options', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Features & Options Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate features-options with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Features & Options', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Features & Options', 'idealauto' ),
			'not_found'                  => esc_html__( 'No features-options found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Features & Options', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => true,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'features-options' ),
		);
	
         if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_features_options', array( 'cars' ), $args  );
        }

		// Add new taxonomy, NOT hierarchical (like tags).
		$labels = array(
			'name'                       => esc_html__( 'Vehicle Review Stamps', 'idealauto' ),
			'singular_name'              => esc_html__( 'Vehicle Review Stamps', 'idealauto' ),
			'search_items'               => esc_html__( 'Search Vehicle Review Stamps', 'idealauto' ),
			'popular_items'              => esc_html__( 'Popular Vehicle Review Stamps', 'idealauto' ),
			'all_items'                  => esc_html__( 'All Vehicle Review Stamps', 'idealauto' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Vehicle Review Stamps', 'idealauto' ),
			'update_item'                => esc_html__( 'Update Vehicle Review Stamps', 'idealauto' ),
			'add_new_item'               => esc_html__( 'Add New Vehicle Review Stamps', 'idealauto' ),
			'new_item_name'              => esc_html__( 'New Vehicle Review Stamps Name', 'idealauto' ),
			'separate_items_with_commas' => esc_html__( 'Separate Vehicle Review Stamps with commas', 'idealauto' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove Vehicle Review Stamps', 'idealauto' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used Vehicle Review Stamps', 'idealauto' ),
			'not_found'                  => esc_html__( 'No Vehicle Review Stamps found.', 'idealauto' ),
			'menu_name'                  => esc_html__( 'Vehicle Review Stamps', 'idealauto' ),
		);

		$args = array(
			'hierarchical'          => true,
			'labels'                => $labels,
			'show_ui'               => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var'             => true,
			'rewrite'               => true,
		);
	
         if(function_exists('custom_reg_taxonomy')){
            custom_reg_taxonomy( 'car_vehicle_review_stamps', array( 'cars' ), $args  );
        }

	};
add_action( 'init', 'jws_register_inventory', 1 );

function add_featured_image_column_inventory($defaults) {
    $defaults['price'] = esc_html__('Price','idealauto');
    $defaults['featured_image'] = esc_html__('Features Image','idealauto');
    
    $defaults['featured'] = esc_html__('Features','idealauto');
    return $defaults;
}
add_filter('manage_cars_posts_columns', 'add_featured_image_column_inventory');
 
function show_featured_image_column_inventory($column_name, $post_id) {
    
    if ($column_name == 'featured') { 
      $featured =  get_post_meta( $post_id , 'car_asset_type',  true ); 

      ?> <a href="javascript:void(0)" data-id="<?php echo esc_attr($post_id); ?>" class="jws-make-features<?php echo (isset($featured) && $featured == 'featured') ? ' active' : ''; ?>"><i class="jws-icon-star-full"></i></a><?php
        
    }
    if ($column_name == 'featured_image') {
      $car_images =  get_post_meta( $post_id , 'car_images',  true );      
      if(!empty($car_images)) {
        $img_car = jws_getImageBySize(array('attach_id' => $car_images[0], 'thumb_size' => '508x360', 'class' => 'car-images-'.$car_images[0].''));
        if(!empty($img_car['thumbnail'])) echo ''.$img_car['thumbnail'];
        
      }
    }
    
     if ($column_name == 'price') {
      $price =  get_post_meta( $post_id , 'regular_price',  true );      
      if(!empty($price)) {
        jws_car_price_html($class = '', $id = null, $tax_label = false, $echo = true);
       jws_car_price_msrp_html();
        
      }
    }
}
add_action('manage_cars_posts_custom_column', 'show_featured_image_column_inventory', 10, 2); 


        
add_action( 'admin_init', 'jws_remove_metabox' );
if ( ! function_exists( 'jws_remove_metabox' ) ) {
	/**
	 * Remove metabox.
	 */
	function jws_remove_metabox() {
		remove_meta_box( 'tagsdiv-car_year', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_make', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_model', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_body_style', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_condition', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_mileage', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_transmission', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_drivetrain', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_engine', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_fuel_economy', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_exterior_color', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_interior_color', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_stock_number', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_vin_number', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_fuel_type', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_trim', 'cars', 'side' );
		remove_meta_box( 'tagsdiv-car_features_options', 'cars', 'side' );
		remove_meta_box( 'car_features_optionsdiv', 'cars', 'side' );
		remove_meta_box( 'car_vehicle_review_stampsdiv', 'cars', 'side' );
	}
}


