<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
/**
 * idealauto functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage idealauto
 * @since 1.0.0
 */

/** Define THEME */ 
if (!defined('JWS_ABS_PATH')) define('JWS_ABS_PATH', get_template_directory());
if (!defined('JWS_ABS_PATH_ELEMENT')) define('JWS_ABS_PATH_ELEMENT', get_template_directory().'/inc/elementor_widget/widgets');
if (!defined('JWS_URI_PATH')) define('JWS_URI_PATH', get_template_directory_uri());
if ( ! function_exists( 'jws_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function jws_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on idealauto, use a find and replace
		 * to change 'idealauto' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'idealauto', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
        add_theme_support( 'post-formats', array( 'video','link','quote','audio','gallery'));
		set_post_thumbnail_size( 1568, 9999 );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style-editor.css' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
        // This theme uses wp_nav_menu() in two locations.
		register_nav_menus( array(
			'main_navigation'   => esc_html__( 'Main Menu','idealauto' ),
		) );
        
        
        add_image_size( 'jws-car-submit-size', 408, 285, true ); 
        add_image_size( 'jws-car-list-size', 408, 265, true );
        add_image_size( 'jws-car-size', 408, 235, true ); 
        add_image_size( 'jws-car-single-size', 870, 490, true ); 
        add_image_size( 'jws-car-single-size2', 670, 530, true ); 
        add_image_size( 'jws-car-author-size', 900, 490, true ); 
  
	}
endif;
add_action( 'after_setup_theme', 'jws_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function jws_widgets_init() {

    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Main Sidebar', 'idealauto' ),
			'id'            => 'sidebar-main',
			'description'   =>  esc_html__( 'Add widgets here to appear in your blog.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Single Blog Sidebar', 'idealauto' ),
			'id'            => 'sidebar-single-blog',
			'description'   =>  esc_html__( 'Add widgets here to appear in your blog.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Inventory Archive', 'idealauto' ),
			'id'            => 'sidebar-inventory',
			'description'   =>  esc_html__( 'Add widgets here to appear in your car archive.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Dealer Filter Page', 'idealauto' ),
			'id'            => 'sidebar-dealer-filter-page',
			'description'   =>  esc_html__( 'Add widgets here to appear in filter dealer page.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Shop Page (Left And Right)', 'idealauto' ),
			'id'            => 'sidebar-shop',
			'description'   =>  esc_html__( 'Add widgets here to appear in shop page.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Shop Page Banner', 'idealauto' ),
			'id'            => 'sidebar-shop-banner',
			'description'   =>  esc_html__( 'Add widgets here to appear in shop page.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Shop Page (Top)', 'idealauto' ),
			'id'            => 'sidebar-shop2',
			'description'   =>  esc_html__( 'Add widgets here to appear in shop page.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
    register_sidebar( 
      array(
			'name'          =>  esc_html__( 'Single Shop Search Popup', 'idealauto' ),
			'id'            => 'sidebar-single-shop-popup',
			'description'   =>  esc_html__( 'Add widgets here to appear in shop single.', 'idealauto' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
	  )
    );
  
}
add_action( 'widgets_init', 'jws_widgets_init' );

/**
 * Add Theme Option
 */

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width Content width.
 */
function jws_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'jws_content_width', 640 );
}

add_action( 'after_setup_theme', 'jws_content_width', 0 );


/**
 * Enqueue scripts and styles.
 */
if(!function_exists('jws_scripts')) {
  function jws_scripts() {
    
     global $jws_option;  
     $vertion = wp_get_theme()->get( 'Version' );
     wp_enqueue_style( 'jws-jwsicon', JWS_URI_PATH . '/assets/font/jws_icon/jwsicon.css', array(), $vertion, 'all' ); 
     wp_enqueue_style( 'jws-default', JWS_URI_PATH . '/assets/css/default.css', array(), $vertion , 'all' );
     wp_enqueue_style( 'select2-min', JWS_URI_PATH . '/assets/css/select2.min.css', array(), $vertion , 'all' ); 
     wp_enqueue_style( 'colorpicker', JWS_URI_PATH . '/assets/css/colorpicker.css', array(), $vertion , 'all' );
     wp_register_style( 'magnificPopup', JWS_URI_PATH.'/assets/css/magnificPopup.css', array(), $vertion, 'all' );   
     wp_register_style( 'lightgallery', JWS_URI_PATH . '/assets/css/lightgallery.css' );
     wp_enqueue_style( 'slick', JWS_URI_PATH . '/assets/css/slick.css' );
     wp_register_style( 'datetimepicker', JWS_URI_PATH . '/assets/datetimepicker/datetimepicker.css' );     
     wp_enqueue_style( 'awesome', JWS_URI_PATH . '/assets/font/awesome/awesome.css' );   
     
     /** Load our main stylesheet. It is generated with less in upload folder **/ 
     $upload_dir = wp_upload_dir();
     $style_dir = $upload_dir['baseurl'];
     $siteid = get_current_blog_id();
     $filename = 'jws-style.css';
     if (file_exists($upload_dir['basedir'] . '/'.$filename.'')) {
        wp_enqueue_style(
            'jws-style',
            $style_dir . '/'.$filename.'',
            ['elementor-frontend'],
            filemtime($upload_dir['basedir'] . '/'.$filename.'')
        );
     } else {
        wp_enqueue_style( 'jws-style', JWS_URI_PATH . '/assets/css/style.css', array(), $vertion, 'all'  );
        wp_enqueue_style( 'jws-frontend-google-fonts', '//fonts.googleapis.com/css2?family=Heebo',  array(), '' ); 
     } 

     /** Start Woocommerce **/
     wp_register_style( 'owl-carousel', JWS_URI_PATH.'/assets/css/owl.carousel.css', array(), $vertion, 'all' );
     wp_register_script( 'owl-carousel', JWS_URI_PATH. '/assets/js/lib/owl.carousel.js', [], '', true ); 
     wp_register_script( 'jws-woocommerce', JWS_URI_PATH. '/assets/js/woocommerce/woocommerce.js', [], '', true );
     
     if (class_exists('Woocommerce')) {
        if(is_product() || is_shop() || is_tax() || is_cart() || is_checkout()) {
            wp_enqueue_script( 'jws-swiper', JWS_URI_PATH. '/assets/js/lib/swiper.js', [], '', true ); 
            wp_enqueue_style( 'swiper');
            wp_enqueue_style('owl-carousel');
            wp_enqueue_script('owl-carousel');
            wp_enqueue_script( 'jws-woocommerce');
            wp_register_script( 'jws-photoswipe', JWS_URI_PATH. '/assets/js/woocommerce/jws-photoswipe-bundle.min.js',  '', true );
            wp_enqueue_script( 'jquery-ui-core' );
	       
        }
     }
    wp_enqueue_script( 'jws-cookie', JWS_URI_PATH. '/assets/js/lib/js.cookie.min.js', [], $vertion, true );
	if ( wp_script_is( 'wc-add-to-cart-variation', 'registered' ) && ! wp_script_is( 'wc-add-to-cart-variation', 'enqueued' ) ) {
		wp_enqueue_script( 'wc-add-to-cart-variation' );
	}

     wp_register_script( 'datetimepicker', get_template_directory_uri() . "/assets/datetimepicker/datetimepicker.js", [] ,$vertion, true );
     wp_register_script( 'moment-min', get_template_directory_uri() . "/assets/datetimepicker/moment.min.js", [] , $vertion, true );  
     wp_register_script( 'isotope', JWS_URI_PATH. '/assets/js/lib/isotope.js', [], $vertion, true );
     wp_register_script( 'anime', JWS_URI_PATH. '/assets/js/lib/anime.js', [], $vertion, true );
     wp_register_script( 'instafeed', JWS_URI_PATH. '/assets/js/lib/instafeed.js', [], $vertion, true );
     wp_register_script( 'lightgallery-all', JWS_URI_PATH. '/assets/js/lib/lightgallery-all.js', [],$vertion, true );
     wp_register_script( 'magnificPopup', JWS_URI_PATH. '/assets/js/lib/magnificPopup.js', [] , $vertion, true );
     wp_register_script( 'jws-canvas', JWS_URI_PATH. '/assets/js/widget-js/jws-canvas.js', [] , $vertion, true );
     wp_register_script( 'jws-mini-cart', JWS_URI_PATH. '/assets/js/widget-js/mini-cart.js', [] , $vertion, true );
 
     
     /**
     *  Use for widget
     */

     wp_enqueue_script( 'jws-elementor-widget', JWS_URI_PATH. '/assets/js/widget-js/elementor_widget.js', [], $vertion, true );
     wp_enqueue_script( 'colorpicker2', JWS_URI_PATH. '/assets/js/lib/colorpicker2.js', [], $vertion, true );
     wp_enqueue_script( 'select2-min', JWS_URI_PATH. '/assets/js/lib/select2.min.js', [], $vertion, true );
       

     /**
     *  Use for all theme
     */
     wp_enqueue_script( 'slick-min', JWS_URI_PATH. '/assets/js/lib/slick.min.js', [], $vertion, true );    
     wp_enqueue_script('jquery-ui-tooltip');
     wp_enqueue_script( 'jquery-ui-slider' ); 
     wp_enqueue_script( 'jquery-touch-punch' );
     wp_enqueue_script( 'jws-main', JWS_URI_PATH. '/assets/js/main.js' , [], $vertion, true );
     wp_enqueue_script( 'jws-optimize', JWS_URI_PATH. '/assets/js/optimize.js', [], $vertion, false ); 
     if(isset($jws_option['scroll_speed']) && $jws_option['scroll_speed']) {
        wp_enqueue_script( 'SmoothScroll', JWS_URI_PATH. '/assets/js/lib/SmoothScroll.js', [], $vertion, false ); 
     }
    
    /**
     *  Car inventory js
     */

     wp_register_script( 'locationpicker', JWS_URI_PATH. '/assets/js/lib/locationpicker.js ' , [], $vertion, true );
     wp_register_script( 'jquery-autocomplete', JWS_URI_PATH. '/assets/js/lib/jquery.autocomplete.js' , [],$vertion, true );
     wp_register_script( 'jws-car-submit', JWS_URI_PATH. '/assets/js/car_submit.js' , [], $vertion, true );
     wp_register_script( 'jws-edit-profile', JWS_URI_PATH. '/assets/js/edit_profile.js' , [], $vertion, true );
     wp_enqueue_script( 'jws-car', JWS_URI_PATH. '/assets/js/car.js' , [], $vertion, true );
     
     
     
    if(is_single() && 'cars' == get_post_type()){
        wp_enqueue_script( 'print', JWS_URI_PATH. '/assets/js/lib/print.js', array('js-cookie'), '', true ); 
        wp_enqueue_style('datetimepicker');   
        wp_enqueue_script('datetimepicker'); 
        wp_enqueue_script('moment-min'); 
        wp_enqueue_style('lightgallery'); 
        wp_enqueue_script('lightgallery-all');
    }

     
     /**
     *  Add google services
     */
    

	 $api_url     = 'https://maps.googleapis.com';
    
		
	 if ( isset( $jws_option['google_api'] ) && '' !== $jws_option['google_api'] ) {
	   
			$url      = $api_url . '/maps/api/js?key=' . $jws_option['google_api'].'&libraries=places&language=en';
            
		} else {

			$url = $api_url . '/maps/api/js';
	  }
      wp_enqueue_script( 'jws-google-maps-api', $url, [ 'jquery' ],'', true );   
     
   
     if (!is_front_page() ) {
        wp_register_script( 'jws-google-recaptcha-apis', 'https://www.google.com/recaptcha/api.js?onload=doCaptcha&render=explicit', array( 'js-cookie' ), $vertion , true );
        
     }
 
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
    	wp_enqueue_script( 'comment-reply' );
    }
    
    
    /**
     *  Add validate js
     */
     
     
    $currency_symbol = "";
	if ( function_exists( 'get_woocommerce_currency_symbol' ) ) {
    	$currency_symbol = get_woocommerce_currency_symbol( get_option( 'woocommerce_currency' ) );
	}

	$car_url = get_post_type_archive_link( 'cars' );
	
	$is_vehicle_cat = false;
	$vehicle_cat    = '';
    $is_author = '';
    $is_user = '';
    global $author; 
 
    if ( is_author() ) { 
       $car_url = get_author_posts_url($author);
       $is_author = 'yes';
    }
    
    
    if( is_user_logged_in() && $author === get_current_user_id() ) {

       $is_user = 'yes';
    
    }
    
	if ( is_tax( 'car_cat' ) ) {
		global $wp,$wp_query;
		$car_url        = home_url( $wp->request );
		$is_vehicle_cat = true;
		$vehicle_cat    = $wp_query->query_vars['car_cat'];
    }

    
    wp_localize_script(
			'jws-main',
			'jws_script',
			array(
                'is_multisite' => is_multisite(),
		        'current_blog_id' => get_current_blog_id(),
				'ajax_url'        => admin_url( 'admin-ajax.php' ),
                'theme_path' => JWS_URI_PATH,
                'instaram_tk'  => (isset($jws_option['instagram_token']) && !empty($jws_option['instagram_token'])) ? $jws_option['instagram_token'] : '',
                'metera'  =>  esc_html__('Very weak','idealauto'),
                'meterb'  =>  esc_html__('Weak','idealauto'),
                'meterc'  =>  esc_html__('Medium','idealauto'),
                'meterd'  =>  esc_html__('Strong','idealauto'),
                'nextNonce' => wp_create_nonce('myajax-next-nonce'),
                'currency_pos' => sanitize_text_field( get_option( 'woocommerce_currency_pos' ) ),
                'currency' => sanitize_text_field( $currency_symbol ),
			)
	);
    /**
     *  Car dealder use for ajax price
     */
	$decimal_places            = ( ! empty( $jws_option['cars-number-decimals'] ) && is_numeric( $jws_option['cars-number-decimals'] ) ) ? $jws_option['cars-number-decimals'] : 0;
	$decimal_separator_symbol  = ( isset( $jws_option['cars-decimal-separator'] ) && ! empty( $jws_option['cars-decimal-separator'] ) ) ? $jws_option['cars-decimal-separator'] : '.';
	$thousand_seperator_symbol = ( isset( $jws_option['cars-thousand-separator'] ) && ! empty( $jws_option['cars-thousand-separator'] ) ) ? $jws_option['cars-thousand-separator'] : ''; 
	wp_localize_script(
			'jws-main',
			'cars_price_slider_params',
			array(
				'currency_symbol'                          => jws_get_cars_currency_symbol(),
				'currency_pos'                             => jws_get_cars_currency_placement(),
				'decimal_places'                           => $decimal_places,
				'decimal_separator_symbol'                 => $decimal_separator_symbol,
				'thousand_seperator_symbol'                => $thousand_seperator_symbol,
				'min_price'                                => isset( $_GET['min_price'] ) ? sanitize_text_field( wp_unslash( $_GET['min_price'] ) ) : '',
				'max_price'                                => isset( $_GET['max_price'] ) ? sanitize_text_field( wp_unslash( $_GET['max_price'] ) ) : '',
				'cars_form_url'                            => $car_url,
                'cars_is_author'                            => $is_author,
                'cars_is_user'                            => $is_user,
                'author_id'                            => $author,
				'load_more_vehicles_nonce'                 => wp_create_nonce( 'load_more_vehicles_nonce' ),
				'pgs_cars_list_search_auto_compalte_nonce' => wp_create_nonce( 'pgs_cars_list_search_auto_compalte_nonce' ),
				'jws_cars_filter_query_nonce'        => wp_create_nonce( 'jws_cars_filter_query_nonce' ),
			)
	);
    
   wp_localize_script(
			'jws-main',
			'cars_year_range_slider_params',
			array(
				'is_year_range_active' => jws_is_year_range_active(),
				'min_year'             => isset( $_GET['min_year'] ) ? sanitize_text_field( wp_unslash( $_GET['min_year'] ) ) : '',
				'max_year'             => isset( $_GET['max_year'] ) ? sanitize_text_field( wp_unslash( $_GET['max_year'] ) ) : '',
			)
   );
   
   $lay_style        = jws_get_cars_list_layout_style(); // Get default layout stype for listing page if cookies not set.
   $cars_grid        = jws_get_cars_catlog_style(); // Get default cars_grid yes or no if cookies not set.
   $cars_orderby     = jws_get_default_sort_by(); // Get default short_by.
   $cars_order       = jws_get_default_sort_by_order();
   $vehicle_location = ( isset( $_GET['vehicle_location'] ) && ! empty( $_GET['vehicle_location'] ) ) ? sanitize_text_field( wp_unslash( $_GET['vehicle_location'] ) ) : '';
   $dFormat = get_option('date_format');
   $tFormat = 'H:i';
   $dFormat = (preg_match_all("/[d].[m].[yY]/", $dFormat)) ? 'm/d/Y' : $dFormat;
   $dateTimeFormat = $dFormat . " " . $tFormat;
   wp_localize_script(
			'jws-main',
			'jws_obj',
			array(
				'site_url'         => site_url(),
                'is_required'         => esc_html__('is required','idealauto'),
				'cars_url'         => $car_url,
				'lay_style'        => $lay_style,
				'cars_grid'        => $cars_grid,
				'default_sort_by'  => $cars_orderby,
				'default_order_by' => $cars_order,
				'is_vehicle_cat'   => $is_vehicle_cat,
				'vehicle_cat'      => $vehicle_cat,
				'vehicle_location' => $vehicle_location, // Add vehicle location param for ajax call in next page etc.
                'datetimeformat' => $dateTimeFormat, // Add vehicle location param for ajax call in next page etc.
                'datetimeformat_notime' => $dFormat, // Add vehicle location param for ajax call in next page etc.
			)
    );
    
    
    /**
     *  Woocommerce ajax
     */
    $shop_url = class_exists('Woocommerce') ? get_permalink( wc_get_page_id( 'shop' ) ) : ''; 
    wp_localize_script(
			'jws-main',
			'woo_params',
			array(
				'product_form_url'                            => $shop_url,
				'load_more_vehicles_nonce'                 => wp_create_nonce( 'load_more_vehicles_nonce' ),
				'pgs_cars_list_search_auto_compalte_nonce' => wp_create_nonce( 'pgs_cars_list_search_auto_compalte_nonce' ),
				'jws_cars_filter_query_nonce'        => wp_create_nonce( 'jws_cars_filter_query_nonce' ),
			)
	);
    
    
    
    // Captcha js script.
	$captcha_sitekey    = jws_get_goole_api_keys( 'site_key' );
	$captcha_secret_key = jws_get_goole_api_keys( 'secret_key' );
	if ( isset( $captcha_secret_key ) && ! empty( $captcha_secret_key ) && isset( $captcha_sitekey ) && ! empty( $captcha_sitekey ) ) {
		wp_localize_script(
			'jws-main',
			'goole_captcha_api_obj',
			array(
				'google_captcha_site_key' => $captcha_sitekey,
			)
		);
		if ( (is_single() && 'cars' == get_post_type()) ||  is_post_type_archive( 'cars' ) || is_page_template('page-submitcar.php') || is_author() || (class_exists('Woocommerce') && is_product())   ) {
			wp_enqueue_script( 'jws-google-recaptcha-apis' );
		}
	}

            
}
add_action( 'wp_enqueue_scripts', 'jws_scripts' );  
} 

/**
 * Enqueue scripts and styles.
 */
if(!function_exists('jws_scripts_inline')) {
  function jws_scripts_inline() {
     wp_enqueue_style( 'jws-inline-style', get_stylesheet_uri());   
	 wp_add_inline_style('jws-inline-style', jws_custom_css()); 
}
add_action( 'wp_enqueue_scripts', 'jws_scripts_inline' ,101 );  
} 

// Update CSS within in Admin
function jws_admin_style() {
    
  wp_enqueue_style('jws-admin-styles', JWS_URI_PATH.'/assets/css/admin.css');
  wp_enqueue_style( 'jws-icon', JWS_URI_PATH . '/assets/font/jws_icon/jwsicon.css', array(), wp_get_theme()->get( 'Version' ), 'all' );   
  wp_enqueue_style( 'awesome', JWS_URI_PATH . '/assets/font/awesome/awesome.css', array(), wp_get_theme()->get( 'Version' ), 'all' ); 
  wp_enqueue_script( 'jws-admin', JWS_URI_PATH. '/assets/js/admin.js', [], '', true ); 
  wp_enqueue_style( 'select2-min', JWS_URI_PATH . '/assets/css/select2.min.css', array(), wp_get_theme()->get( 'Version' )  , 'all' ); 
  wp_enqueue_script( 'select2-min', JWS_URI_PATH. '/assets/js/lib/select2.min.js', [], wp_get_theme()->get( 'Version' ) , false ); 
  	//Geocoding google
    global $jws_option; 
    $api_url     = 'https://maps.googleapis.com';
    
		
     if ( isset( $jws_option['google_api'] ) && '' !== $jws_option['google_api'] ) {
   
		$url      = $api_url . '/maps/api/js?key=' . $jws_option['google_api'].'&libraries=places&language=en';
        
	} else {

		$url = $api_url . '/maps/api/js';
     }

  wp_enqueue_script( 'jws_googleapis_js_places', $url, array( 'jquery' ), false, true ); 
  
  wp_localize_script(
	'jws-admin',
	'jws_script',
	array(
        'current_blog_id' => get_current_blog_id(),
		'ajax_url'        => admin_url( 'admin-ajax.php' ),
	)
  ); 
   	
}
add_action('admin_enqueue_scripts', 'jws_admin_style' , 3);


/**
 * Enhance the theme by hooking into WordPress.
*/
require_once JWS_ABS_PATH . '/inc/inc.php';

/* Disable the Widgets Block Editor*/
function widget_theme_support() {
remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'widget_theme_support' );

/**
 * Add Woocommerce To Theme
*/
if (class_exists('Woocommerce')) {
	require_once JWS_ABS_PATH . '/woocommerce/wc-template-function.php'; 
    require_once JWS_ABS_PATH . '/woocommerce/compare/compare.php';
    require_once JWS_ABS_PATH . '/woocommerce/wishlist/wishlist.php';
    require_once JWS_ABS_PATH . '/woocommerce/woocommerce-ajax.php';
} 
if( ! function_exists( 'jws_photoswipe_template' ) && class_exists('Woocommerce')) {
	function jws_photoswipe_template() {
		get_template_part('woocommerce/single-product/photo-swipe-template');
	}     
}

add_action('wp_loaded', 'jws_prefix_output_buffer_start');

function jws_prefix_output_buffer_start() { 
    ob_start("jws_prefix_output_callback"); 
}

function jws_prefix_output_callback($buffer) {
    return preg_replace( "%[ ]type=[\'\"]text\/(javascript|css)[\'\"]%", '', $buffer );
};