(function($) {
    "use strict";
	jQuery(document).ready(function($) {
		function do_ajax_call_dealer(form_data) {
			var form = $(this).parents('form');
			var carId = $(this).data('car_id'),
				closeText = 'close_view',
				loadingText = 'loading_view',
				btn_type = $(this).data('type'),
				$this = $(this);
			var btn = $(this);
			btn.addClass('loading'),
				$.ajax({
					url: jws_script.ajax_url,
					data: 'action=jws_ajax_load_dealer_content' + form_data,
					method: 'get',
					beforeSend: function() {
						jQuery('.dealer-list-wap').addClass('loading');
					},
					success: function(data) {
						$('.dealer-list-wap').addClass('has-content').html(data);
						jQuery('.dealer-list-wap').removeClass('loading');
						btn.addClass('content-loaded');
						btn.removeClass('loading');
					},
					complete: function() {
						initialize_map_new();
						var get_first_charecter = form_data.charAt(0);
						if(get_first_charecter == '&') {
							form_data = form_data.replace('&', '?');
						}
						window.history.pushState(null, null, form_data);
						if(form_data == '') {
							window.history.pushState(null, null, './')
						}
					},
					error: function() {},
				});
		}
		$(document).on('click', '.dealer-bar .filter-dealer', function(e) {
			e.preventDefault();
			var form_data = '';
			form_data += get_form_dealer_field();
			do_ajax_call_dealer(form_data);
		});
		$(document).on('change', '#pac-input', function(e) {
			var $value = $(this).val();
			if($value == '') {
				$('.dealer-lat').val('');
				$('.dealer-lng').val('');
			}
		});
		var input = document.getElementById('pac-input');
		var autocomplete = new google.maps.places.Autocomplete(input);
		google.maps.event.addListener(autocomplete, 'place_changed', function() {
			var place = autocomplete.getPlace();
			var lat = place.geometry.location.lat();
			var lng = place.geometry.location.lng();
			if(typeof lat != "undefined") {
				$('.dealer-lat').val(lat);
			}
			if(typeof lat != "undefined") {
				$('.dealer-lng').val(lng);
			}
		});
		$(document).on('click', '#reset-filter-dealer', function(event) {
			event.preventDefault();
			var form_data = '';
			$('.item-dealer-filters').each(function() {
				$("select[name='make_dealer']").select2('destroy').val("").select2();
				$("select[name='dealer_radius']").select2('destroy').val("").select2();
				window.history.pushState(null, null, '?');
				var tid = jQuery(this).attr('data-id');
				if(tid == 'dealer_radius') {
					var sel_val = $(this).val('');
				} else {
					var sel_val = $(this).val('');
				}
			});
			form_data = get_form_dealer_field(this);
			do_ajax_call_dealer(form_data);
		});

		function get_form_dealer_field() {
			var form_data_ajax = '';
			jQuery('.item-dealer-filters').each(function() {
				var tid = jQuery(this).attr('data-id');
				var sel_val = jQuery(this).val();
				var sel_txt = jQuery(this).attr('data-tax');
				var sel_term = jQuery(this).find('option:selected').html();
				if(sel_val != "") {
					form_data_ajax += "&" + tid + "=" + sel_val;
				}
			});
			return form_data_ajax;
		}

		function initialize_map_new() {
			var latitude = jQuery('#location_lon').val();
			var longitude = jQuery('#location_lat').val()
			var locations = $("#map-canvas").data('location');
			var geocoder;
			var map;
			var bounds = new google.maps.LatLngBounds();

			function initialize() {
				map = new google.maps.Map(document.getElementById("map-canvas"), {
					center: new google.maps.LatLng(latitude, longitude),
					zoom: 1,
					mapTypeId: google.maps.MapTypeId.ROADMAP
				});
				geocoder = new google.maps.Geocoder();
				for(var i = 0; i < locations.length; i++) {
					geocodeAddress(locations, i);
				}
			}
			initialize();

			function geocodeAddress(locations, i) {
				var title = locations[i][0];
				var address = locations[i][1];
				var url = locations[i][2];
				var images = locations[i][3];
				var url_text = locations[i][4];
				var icon_url = jws_script.theme_path + '/assets/image/maker-dealer-filter.png';
				if(title == "Start Location") {
					icon_url = jws_script.theme_path + '/assets/image/maker-start.png';
				}
				geocoder.geocode({
					'address': locations[i][1]
				}, function(results, status) {
					if(status == google.maps.GeocoderStatus.OK) {
						var marker = new google.maps.Marker({
							icon: icon_url,
							map: map,
							position: results[0].geometry.location,
							title: title,
							animation: google.maps.Animation.DROP,
							address: address,
							url: url
						})
						infoWindow(marker, map, title, address, url, url_text, images);
						bounds.extend(marker.getPosition());
						map.fitBounds(bounds);
					} else {
						//alert("geocode of " + address + " failed:" + status);
					}
				});
			}

			function infoWindow(marker, map, title, address, url, url_text, images) {
				google.maps.event.addListener(marker, 'click', function() {
					$image_class = '';
					if(images == '') {
						$image_class = " images_emtry";
					}
					var html = "";
					html += "<div class='dealer-info-map" + $image_class + "'>";
					html += images;
					html += "<div class='dealer-conent'><h3>" + title + "</h3><p>" + address + "<br>";
					if(url_text != '') {
						html += "<a href='" + url + "'>" + url_text + "</a>";
					}
					html += "</p></div";
					html += "</div";
					iw = new google.maps.InfoWindow({
						content: html,
						maxWidth: 350
					});
					iw.open(map, marker);
				});
			}
		}
		initialize_map_new();
	});
})(jQuery);