(function($) {
    "use strict";
	$(document).ready(function() {
		function initialize_map_new() {
			if(window.location.protocol != 'http:' && navigator.geolocation) {
				navigator.geolocation.getCurrentPosition(function(position) {
					var latitude = position.coords.latitude;
					var longitude = position.coords.longitude;
					var latlng = jQuery("#cordinats2").val();
                    var re;
                    var arr;
                    var map;
					if(latlng.length > 10) {
						re = /\s*,\s*/;
						arr = latlng.split(re);
						var myLatLng = {
							lat: parseFloat(arr[0]),
							lng: parseFloat(arr[1])
						};
						latitude = parseFloat(arr[0]);
						longitude = parseFloat(arr[1]);
					}
					var mapOptions = {
						center: new google.maps.LatLng(latitude, longitude),
						zoom: 17
					};
					map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);
					if(latlng.length > 10) {
						var marker2 = new google.maps.Marker({
							position: myLatLng,
							map: map,
							title: 'Hello World!'
						});
					}
					var input = (document.getElementById("pac-input"));
					var types = document.getElementById("type-selector");
					//map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
					//map.controls[google.maps.ControlPosition.TOP_LEFT].push(types);
					var autocomplete = new google.maps.places.Autocomplete(input);
					autocomplete.bindTo("bounds", map);
					var infowindow = new google.maps.InfoWindow();
					var marker = new google.maps.Marker({
						map: map,
						draggable: true,
						anchorPoint: new google.maps.Point(0, -29)
					});
					google.maps.event.addListener(autocomplete, "place_changed", function() {
						infowindow.close();
						marker.setVisible(false);
						var place = autocomplete.getPlace();
						if(!place.geometry) {
							return;
						}
						if(place.geometry.viewport) {
							map.fitBounds(place.geometry.viewport);
						} else {
							map.setCenter(place.geometry.location);
							map.setZoom(17);
						}
						marker.setIcon(({
							url: place.icon,
							size: new google.maps.Size(71, 71),
							origin: new google.maps.Point(0, 0),
							anchor: new google.maps.Point(17, 34),
							scaledSize: new google.maps.Size(35, 35)
						}));
						marker.setPosition(place.geometry.location);
						marker.setVisible(true);
						jQuery("#location_lon").val(place.geometry.location.lng());
						jQuery("#location_lat").val(place.geometry.location.lat());
						var crtt = place.geometry.location.lat() + "," + place.geometry.location.lng();
						var foradre = place.formatted_address;
						jQuery("#cordinats2").val(crtt);
						jQuery("#cordinats2").trigger("change");
						jQuery("#formatted_address").val(foradre);
						var address = "";
						if(place.address_components) {
							address = [(place.address_components[0] && place.address_components[0].short_name || ""), (place.address_components[1] && place.address_components[1].short_name || ""), (place.address_components[2] && place.address_components[2].short_name || "")].join(" ");
						}
						infowindow.setContent("<div><strong>" + place.name + "</strong><br>" + address);
						infowindow.open(map, marker);
					});
					/*************************/
					google.maps.event.addListener(marker, "drag", function() {
						jQuery.getJSON("http://maps.googleapis.com/maps/api/geocode/json?latlng=" + marker.getPosition().lat() + "," + marker.getPosition().lng() + "&sensor=true_or_false", function(data, textStatus) {
							var adress1 = data.results[0].formatted_address;
							infowindow.setContent("<div><strong>" + adress1 + "</strong><br>" + data.results[1].formatted_address);
							jQuery("#formatted_address").val(adress1);
							jQuery("#location_lon").val(marker.getPosition().lng());
							jQuery("#location_lat").val(marker.getPosition().lat());
							jQuery("#cordinats2").val(marker.getPosition().lat() + "," + marker.getPosition().lng());
						});
						infowindow.open(map, marker);
					});

					function setupClickListener(id, types) {
						var radioButton = document.getElementById(id);
						google.maps.event.addDomListener(radioButton, "click", function() {
							autocomplete.setTypes(types);
						});
					}
					setupClickListener("changetype-all", []);
					setupClickListener("changetype-address", ["address"]);
					setupClickListener("changetype-establishment", ["establishment"]);
					setupClickListener("changetype-geocode", ["geocode"]);
					/****************************/
				});
			} else {
				var latitude = jQuery('.location_lon').val();
				var longitude = jQuery('.location_lat').val()
				var latlng = jQuery("#cordinats2").val();
                var re;
                var arr;
                var map;
				if(latlng != undefined && latlng.length > 10) {
					re = /\s*,\s*/;
					arr = latlng.split(re);
					var myLatLng = {
						lat: parseFloat(arr[0]),
						lng: parseFloat(arr[1])
					};
					latitude = parseFloat(arr[0]);
					longitude = parseFloat(arr[1]);
				}
				var mapOptions = {
					center: new google.maps.LatLng(latitude, longitude),
					zoom: 17
				};
				map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);
				if(latlng != undefined && latlng.length > 10) {
					var marker2 = new google.maps.Marker({
						position: myLatLng,
						map: map,
						draggable: true,
						title: ''
					});
					google.maps.event.addListener(marker2, "drag", function() {
						jQuery.getJSON("http://maps.googleapis.com/maps/api/geocode/json?latlng=" + marker2.getPosition().lat() + "," + marker2.getPosition().lng() + "&sensor=true_or_false", function(data, textStatus) {
							var adress1 = data.results[0].formatted_address;
							infowindow.setContent("<div><strong>" + adress1 + "</strong><br>" + data.results[1].formatted_address);
							jQuery("#formatted_address").val(adress1);
							jQuery("#location_lon").val(marker2.getPosition().lng());
							jQuery("#location_lat").val(marker2.getPosition().lat());
							jQuery("#cordinats2").val(marker2.getPosition().lat() + "," + marker2.getPosition().lng());
						});
						infowindow.open(map, marker);
					});
				}
				var input = (document.getElementById("pac-input"));
				var types = document.getElementById("type-selector");
				// map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
				//map.controls[google.maps.ControlPosition.TOP_LEFT].push(types);
    
                if(typeof google.maps.places === 'undefined') {
                    return;
                }
				var autocomplete = new google.maps.places.Autocomplete(input);
				autocomplete.bindTo("bounds", map);
				var infowindow = new google.maps.InfoWindow();
				var marker = new google.maps.Marker({
					map: map,
					draggable: true,
					anchorPoint: new google.maps.Point(0, -29)
				});
				google.maps.event.addListener(autocomplete, "place_changed", function() {
					infowindow.close();
					marker.setVisible(false);
					var place = autocomplete.getPlace();
					if(!place.geometry) {
						return;
					}
					if(place.geometry.viewport) {
						map.fitBounds(place.geometry.viewport);
					} else {
						map.setCenter(place.geometry.location);
						map.setZoom(17);
					}
					marker.setIcon(({
						url: place.icon,
						size: new google.maps.Size(71, 71),
						origin: new google.maps.Point(0, 0),
						anchor: new google.maps.Point(17, 34),
						scaledSize: new google.maps.Size(35, 35)
					}));
					marker.setPosition(place.geometry.location);
					marker.setVisible(true);
					jQuery("#location_lon").val(place.geometry.location.lng());
					jQuery("#location_lat").val(place.geometry.location.lat());
					var crtt = place.geometry.location.lat() + "," + place.geometry.location.lng();
					var foradre = place.formatted_address;
					jQuery("#cordinats2").val(crtt);
					jQuery("#cordinats2").trigger("change");
					jQuery("#formatted_address").val(foradre);
					var address = "";
					if(place.address_components) {
						address = [(place.address_components[0] && place.address_components[0].short_name || ""), (place.address_components[1] && place.address_components[1].short_name || ""), (place.address_components[2] && place.address_components[2].short_name || "")].join(" ");
					}
					infowindow.setContent("<div><strong>" + place.name + "</strong><br>" + address);
					infowindow.open(map, marker);
				});
				/*************************/
				google.maps.event.addListener(marker, "drag", function() {
					jQuery.getJSON("http://maps.googleapis.com/maps/api/geocode/json?latlng=" + marker.getPosition().lat() + "," + marker.getPosition().lng() + "&sensor=true_or_false", function(data, textStatus) {
						var adress1 = data.results[0].formatted_address;
						infowindow.setContent("<div><strong>" + adress1 + "</strong><br>" + data.results[1].formatted_address);
						jQuery("#formatted_address").val(adress1);
						jQuery("#location_lon").val(marker.getPosition().lng());
						jQuery("#location_lat").val(marker.getPosition().lat());
						jQuery("#cordinats2").val(marker.getPosition().lat() + "," + marker.getPosition().lng());
					});
					infowindow.open(map, marker);
				});

				function setupClickListener(id, types) {
					var radioButton = document.getElementById(id);
					google.maps.event.addDomListener(radioButton, "click", function() {
						autocomplete.setTypes(types);
					});
				}
				//setupClickListener("changetype-all", []);
				/* setupClickListener("changetype-address", ["address"]);
					 setupClickListener("changetype-establishment", ["establishment"]);
					 setupClickListener("changetype-geocode", ["geocode"]);*/
				/****************************/
			}
		}
        
        if($('#map-canvas').length) {
          initialize_map_new();  
        }
        
		

		function form_submit() {
			/** Add Images **/
			var userFiles = [];
			if(typeof jwsUserFilesLoaded !== 'undefined') {
				userFiles = jwsUserFilesLoaded;
				jQuery('.file_attachments').val(jwsUserFilesLoaded);
			}
			var jwsFeaturedID = 0;
			var orderChanged = false;
			var jws_timeout;
			$('.jws_add_car_form input[type="file"]').on('change', function() {
				var jwsDontChangeFeatured = false;
				$('.jws-image-preview, .jws-placeholder-generated').not('.jws-placeholder-generated-php, .jws-placeholder-generated-php .jws-image-preview, .jws-placeholder-generated-php').remove();
				var files = $(this)[0].files;
				for(var key in files) {
					if(typeof(files[key]) === 'object') {
						userFiles.push(files[key]);
					}
				}
				var jwsFeaturedSet = 0;
				if(userFiles) {
					[].forEach.call(userFiles, readAndPreview);
				}

				function readAndPreview(file, index) {
					if(typeof(userFiles[0]) === 'number') {
						jwsDontChangeFeatured = true;
					}
					var currentFiles = index;
					// Make sure `file.name` matches our extensions criteria
					if(/\.(jpe?g|png)$/i.test(file.name)) {
						if(userFiles.length > 0) {
							$('.jws-add-media-car').addClass('hasImages');
						} else {
							$('.jws-add-media-car').removeClass('hasImages');
						}
						var reader = new FileReader();
						reader.addEventListener("load", function() {
							jwsFeaturedSet++;
							if(userFiles[currentFiles]) {
								var $jws_append_placeholder_start = '<div class="jws-placeholder jws-placeholder-generated"><div class="inner">';
								var $jws_append_placeholder_end = '</div></div>';
								var jwsDelete = '<i class="remove jws-icon-icon_close" data-id="' + currentFiles + '"></i>'
								if(jwsFeaturedSet == 1 && !jwsDontChangeFeatured) {
									jwsFeaturedID = currentFiles;
									$('.jws-media-car-main-input').append('<div class="jws-image-preview" data-id="' + currentFiles + '" style="background:url(' + this.result + ')"></div>');
								}
								$('.jws-placeholder-native').remove();
								$('.jws-media-car-gallery').append($jws_append_placeholder_start + '<div class="jws-image-preview" data-media = "' + file.name + '" data-id="' + currentFiles + '" style="background-image:url(' + this.result + ')">' + jwsDelete + '</div>' + $jws_append_placeholder_end);
							}
							/*Enable droppadble on new elements again*/
							$('.jws-media-car-gallery .jws-placeholder').droppable({
								drop: jwsDroppableEvent
							});
						}, false);
						reader.readAsDataURL(file);
					}
				}
				jws_resort_array();
			});
			$(document).on('click', '.drop_img_item', function() {
				$('.pdf-value').remove();
				$('#car-pdf').next().val("");
			});
			$(document).on('click', '.jws-media-car-gallery .jws-placeholder .inner .jws-image-preview .remove', function() {
				var jws_id = $(this).attr('data-id');
				var jws_length = 0;
				userFiles.pop(jws_id);
				$(this).closest('.jws-placeholder').remove();
				$(userFiles).each(function(i, e) {
					if(typeof(e) !== 'undefined') {
						jws_length++;
					}
				});
				if(jwsFeaturedID == jws_id) {
					var changeFeatured = $('.jws-media-car-gallery .jws-placeholder:nth-child(1)');
					jwsFeaturedID = changeFeatured.find('.jws-image-preview').attr('data-id');
				}
				if(jws_length == 0) {
					$('.jws-media-car-main-input .jws-image-preview').remove();
					$('.jws-add-media-car').removeClass('hasImages');
					var defaultPlaceholders = '';
					for(var i = 0; i < 4; i++) {
						defaultPlaceholders += '<div class="jws-placeholder jws-placeholder-native"><div class="inner"><i class="jws-icon-add"></i></div></div>';
					}
					$('.jws-media-car-gallery').append(defaultPlaceholders);
				}
				if(jwsFeaturedID == jws_id) {
					var changeFeatured = $('.jws-media-car-gallery .jws-placeholder:nth-child(1)');
					jwsFeaturedID = changeFeatured.find('.jws-image-preview').attr('data-id');
					$('.jws-media-car-main-input .jws-image-preview').remove();
					$(changeFeatured).find('.jws-image-preview').clone().appendTo('.jws-media-car-main-input');
				}
				jws_resort_array();
			});
			/*Droppable*/
			$(document).on("mouseenter", '.jws-media-car-gallery .jws-placeholder .inner .jws-image-preview', function(e) {
				var item = $(this);
				item.draggable({
					helper: "clone",
					revert: "invalid"
				})
			});
			$('.jws-media-car-gallery .jws-placeholder').droppable({
				drop: jwsDroppableEvent
			});

			function jwsDroppableEvent(event, ui) {
				var dragFromPreview = ui.draggable;
				var dragFrom = dragFromPreview.closest('.inner');
				var dragTo = $(this).find('.inner');
				var dragToPreview = dragTo.find('.jws-image-preview');
				if(dragFromPreview.length > 0 && dragToPreview.length > 0 && dragTo.length > 0 && dragFrom.length > 0) {
					if(dragFrom[0] != dragTo[0]) {
						var dragFromId = dragFromPreview.data('id');
						var dragToId = dragToPreview.data('id');
						dragFromPreview.clone().appendTo(dragTo);
						dragToPreview.clone().appendTo(dragFrom);
						var droppingInIndex = dragTo.closest('.jws-placeholder').index();
						var draggingIndex = dragFromPreview.closest('.jws-placeholder').index();
						/*If placed in first pos*/
						if(droppingInIndex === 0) {
							$('.jws-media-car-main-input .jws-image-preview').remove();
							dragFromPreview.clone().appendTo('.jws-media-car-main-input');
							jwsFeaturedID = dragFromPreview.data('id');
						}
						/*If moving from first place*/
						if(draggingIndex === 0) {
							$('.jws-media-car-main-input .jws-image-preview').remove();
							dragToPreview.clone().appendTo('.jws-media-car-main-input');
							jwsFeaturedID = dragToPreview.data('id');
						}
						orderChanged = true;
						dragFromPreview.remove();
						dragToPreview.remove();
						jws_resort_array();
						orderChanged = true;
					}
				}
			}

			function jws_resort_array() {
				jws_timeout = setTimeout(function() {
					var tmpArr = [];
					var value = [];
					$('.jws-placeholder.jws-placeholder-generated').each(function(i, e) {
						/*Get old id*/
						var oldId = $(this).find('.jws-image-preview').attr('data-id');
						var media = $(this).find('.jws-image-preview').attr('data-media');
						/*Set new ids to preview and to delete icon*/
						$(this).find('.jws-image-preview').attr('data-id', i);
						$(this).find('.jws-image-preview .remove').attr('data-id', i);
						value[i] = media;
						if(typeof(userFiles[oldId]) !== 'undefined') {
							tmpArr[i] = userFiles[oldId];
						}
					});
					jQuery('.file_attachments').val(value);
					jwsFeaturedID = 0;
					userFiles = tmpArr;
				}, 100);
			}
			/* Submit add / update car form*/
			jQuery(document).on('click', '#jws-submit-car', function() {
				jws_resort_array();
				jQuery(this).attr('disabled', true).addClass('form-loader');
				/* Map editor fields values with textarea*/
				jQuery('textarea.jws_editor').each(function(index, value) {
					var editor_val = tinyMCE.get(jQuery(this).attr('id')).getContent();
					jQuery(this).val(editor_val);
				});
				jQuery('#jws_car_form').submit();
			});
			jQuery(document).on('click', '.jws-dealer-note a', function() {
				$('.jws-add-car-login').slideToggle();
			});
			jQuery(document).on('submit', '#jws_car_form', function(event) {
				event.stopPropagation(); /* Stop stuff happening*/
				event.preventDefault(); /* Totally stop stuff happening*/
				var carcaptchaWidgetId = jQuery(this).find('#car_form_captcha').data('widget_id');
				/* Create a formdata object and add the files to upload*/
				var imgData = new FormData();
				var car_img_cnt = 0;
				jQuery.each(userFiles, function(key, value) {
					imgData.append('car_images[' + key + ']', value);
					car_img_cnt++;
				});
				/* Add PDF file*/
				if(jQuery('#car-pdf').length > 0) {
					var pdf_file = jQuery('#car-pdf').prop('files')[0];
					imgData.append('window_sticker_file', pdf_file);
				}
				imgData.append('action', 'jws_upload_images');
				imgData.append('file_attachments', jQuery('#file_attachments').val());
				/* Serialize the form data*/
				var formData = jQuery(event.target).serializeArray();
				formData.push({
					name: 'action',
					value: 'jws_save_car'
				});
				formData.push({
					name: 'car_img_cnt',
					value: car_img_cnt
				});
				$.ajax({
					url: jws_script.ajax_url,
					type: 'POST',
					data: formData,
					cache: false,
					dataType: 'json',
					beforeSend: function() {
						jQuery('.invalid_fields').removeClass('invalid_fields');
						jQuery('.jws-notes').slideUp();
					},
					success: function(data, textStatus, jqXHR) {
						if(data.status === true) {
							/* Success so call function to process the form*/
							imgData.append('car_id', data.car_id); /* add car id to attach attachments*/
							jws_save_car_imgs(imgData);
							var html = '<ul class="jws-dealer-note green"><li>' + data.message + '</li></ul>';
							jQuery('.jws-notes').html(html).slideDown();
							/* STOP LOADING SPINNER & ENABLE SUBMIT BUTTON*/
						} else {
						    jQuery('#jws-submit-car').removeClass('form-loader');  
							jQuery('.jws-dealer-note').remove();
							var html = '<ul class="jws-dealer-note red"><li>' + data.message + '</li></ul>';
							jQuery('.jws-notes').html(html).slideDown();
                            /* STOP LOADING SPINNER & ENABLE SUBMIT BUTTON*/
        					jQuery('.car-form-loader').remove();
        					jQuery('#jws-submit-car').removeAttr('disabled', false);
        					jQuery('#jws-submit-car').removeClass('disabled');
							/* check validation*/
							if(data.invalid_fields.length > 0) {
								jQuery(data.invalid_fields).each(function(index, val) {
									jQuery('#jws_car_form').find('#jws-' + val).addClass('invalid_fields');
								});
							}
							/* STOP LOADING SPINNER & ENABLE SUBMIT BUTTON*/
						}
					},
					error: function(jqXHR, textStatus, errorThrown) {
						/* Handle errors here*/
						console.log('ERRORS: ' + textStatus);
						/* STOP LOADING SPINNER & ENABLE SUBMIT BUTTON*/
						jQuery('#jws-submit-car').removeClass('form-loader');
					},
					complete: function() {
						/* STOP LOADING SPINNER*/
					}
				});
			});
		}
		form_submit();
		/*
			Ajax call for car attachments
		*/
		function jws_save_car_imgs(imgDataObj) {
			jQuery.ajax({
				url: jws_script.ajax_url,
				type: 'POST',
				data: imgDataObj,
				cache: false,
				contentType: false,
				processData: false,
				success: function(data, textStatus, jqXHR) {
					var response = jQuery.parseJSON(data);
					if(response.status === true) {
						jQuery('#jws-submit-car').removeClass('form-loader');
						var html = '<ul class="jws-dealer-note green"><li>' + response.status_msg + '</li></ul>';
						jQuery('.jws-notes').html(html).slideDown();
						window.location.href = response.redirect;
					} else {
						/* reset captcha*/
						if(typeof grecaptcha !== "undefined") {
							//grecaptcha.reset( carcaptchaWidgetId ); // reset captcha
						}
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					/* Handle errors here*/
					console.log('ERRORS: ' + textStatus);
					/* reset captcha*/
					if(typeof grecaptcha !== "undefined") {
						//grecaptcha.reset( carcaptchaWidgetId ); // reset captcha
					}
					/* STOP LOADING SPINNER & ENABLE SUBMIT BUTTON*/
					jQuery('.car-form-loader').remove();
					jQuery('#jws-submit-car').removeAttr('disabled', false);
					jQuery('#jws-submit-car').removeClass('disabled');
				},
			});
		}

		function condition_make_model() {
			$('.jws-make').on('change', function() {
				var plan = 'Select Model';
				$('.jws-model option:not(:first-child)').each(function() {
					if($(this).data('condition') == $('.jws-make').val()) {
						$(this).removeAttr('disabled').removeClass('se-diable');
					} else {
						$(this).attr('disabled', 'true').addClass('se-diable');
					}
				});
				$('.jws-model').select2('destroy').val("").select2();
			});
		}
		condition_make_model();

		function field_date() {
			var jwsToday = new Date();
			var dateTimeFormat = jws_obj.datetimeformat_notime;
			jQuery('input[data-name="registered"]').datetimepicker({
				format: dateTimeFormat,
				defaultDate: jwsToday,
				defaultSelect: false,
				closeOnDateSelect: false,
				timeHeightInTimePicker: 40,
				validateOnBlur: false,
				fixed: false,
			});
		}
		field_date();

		function checkbox_stamps() {
			$('.section-inner.stamps .checkbox').on('change', function() {
				var isChecked = $(this).is(":checked");
				$(this).parents('.stamps-item').find('.link-for-images').removeClass('active');
				if(isChecked) {
					$(this).val('yes');
					$(this).parents('.stamps-item').find('.link-for-images').slideDown();
				} else {
					$(this).val('no');
					$(this).parents('.stamps-item').find('.link-for-images').slideUp();
				}
			});
		}
		checkbox_stamps();

		function do_validate_field(textArray) {
			var validationStr = false;
			for(var n = 0; n < textArray.length; n++) {
				var str = textArray[n];
				jQuery('#' + str).prev().find('.field-requed').remove();
				var field_val = jQuery('#' + str).val();
				if(field_val == "") {
					validationStr = true;
					var text_requed = jQuery('#' + str).data('label');
					jQuery('#' + str).prev().append('<span class="field-requed">' + text_requed + ' ' + jws_obj.is_required + '</span>');
				}
			}
			return validationStr;
		}

		function car_submit_step() {
			var form_count = 1,
				 form_count_form, next_form, total_forms,
			     total_forms = $(".jws-form-row").length,
				 textArray = [];
			jQuery('.jws_validate').each(function(i) {
				textArray[i] = jQuery(this).attr('id');
			});
			$(".ac-step-tab a").click(function() {
				var sts = do_validate_field(textArray);
				$('html, body').animate({
					scrollTop: $("#jws_car_form").offset().top - 100
				}, 100)
				if(!sts) {
					let previous = $(".jws-form-row");
					var next = $(this).data('id');
					$('.ac-step-tab a').removeClass('active');
					$(this).addClass('active');
					previous.hide();
					$('#' + next).show();
					form_count = $(this).find('.step-item-number').text();
					setProgressBar(form_count);
				}
			});
			$(".next").not('.diable').click(function() {
				var sts = do_validate_field(textArray);
				$('html, body').animate({
					scrollTop: $("#jws_car_form").offset().top - 100
				}, 100)
				if(!sts) {
					let previous = $(this).closest(".jws-form-row").attr('id');
					let next = $('#' + this.id).closest('.jws-form-row').next('.jws-form-row').attr('id');
					$('a[data-id="' + next + '"]').addClass('active');
					$('a[data-id="' + previous + '"]').removeClass('active');
					$('#' + next).show();
					$('#' + previous).hide();
					setProgressBar(++form_count);
				}
			});
			$(".previous").not('.diable').click(function() {
				var sts = do_validate_field(textArray);
				$('html, body').animate({
					scrollTop: $("#jws_car_form").offset().top - 100
				}, 100)
				if(!sts) {
					let current = $(this).closest(".jws-form-row").attr('id');
					let previous = $('#' + this.id).closest('.jws-form-row').prev('.jws-form-row').attr('id');
					$('a[data-id="' + previous + '"]').addClass('active');
					$('a[data-id="' + current + '"]').removeClass('active');
					$('#' + previous).show();
					$('#' + current).hide();
					setProgressBar(--form_count);
				}
			});
			setProgressBar(form_count);

			function setProgressBar(curStep) {
				var percent = parseFloat(100 / total_forms) * curStep;
				percent = percent.toFixed();
				$(".ac-step-progressbar span").css("width", percent + "%")
			}
		}
		car_submit_step();

		function video_clone() {
			$('.video-link-input button').on("click", function() {
				var hasInputs = 0;
				$('.video-item').each(function() {
					hasInputs++;
				});
				console.log(hasInputs);
				var clone = $(this).parents(".video-item").clone(true).appendTo(".video-wap");
				clone.find('input').val("");
				clone.find('.number').text(hasInputs + 1);
			});
		}
		video_clone();
	});
})(jQuery);