<?php
get_header();
wp_enqueue_script( 'stick-content', JWS_URI_PATH. '/assets/js/sticky_content.js', array(), '', true );
wp_enqueue_style('lightgallery'); 
wp_enqueue_script('lightgallery-all');
wp_enqueue_style('datetimepicker');   
wp_enqueue_script('datetimepicker');
global $jws_option;
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div id="primary" class="content-area cars-archive-container">
		<main id="main" class="site-main">
            <div class="container">
                <div class="row">
                    <?php jws_get_car_catlog_sidebar_left(); ?> 
                    <div class="col-xl-9 col-lg-12 col-12">
                    <div class="cars-top-filters">
                        <div class="cars-top-filters-left">
                            <?php jws_cars_perpage(); ?>
                        </div>    
                        <div class="cars-top-filters-right">
                            <?php jws_cars_catalog_ordering(); jws_get_catlog_view(); ?>
                        </div> 
                    </div>	
                    <?php if(isset($jws_option['cars-dealer-featured']) && !empty($jws_option['cars-dealer-featured'])) : $ratings = jws_get_dealer_marks($jws_option['cars-dealer-featured']); $author_logo = get_user_meta( $jws_option['cars-dealer-featured'], 'dealer-avatar', true );   ?>
                    <div class="dealer-featured">
                        <div class="row row-eq-height">
                          <div class="dealer-images col-xl-8 col-lg-8 col-12"> 
                              <?php if(!empty($author_logo)) {
                                    $img = jws_getImageBySize(array('attach_id' => $author_logo, 'thumb_size' => '90x90', 'class' => 'dealer-logo'));
                                    echo ''.$img['thumbnail'];
                              }else{
                    			     echo '<img src="http://0.gravatar.com/avatar/?s=160&d=mm&r=g%202x" width="80" height="80" alt="car-image-default">';
                    		  } ?>
                                <div>
                                 <h4 class="dealer-name"><a href="<?php echo esc_url( get_author_posts_url( $jws_option['cars-dealer-featured'] ) ); ?>"><?php echo get_the_author_meta('display_name',$jws_option['cars-dealer-featured']); ?></a></h4>
                                 <?php if (!empty($ratings['average'])): ?>
                                    <div class="jws-star-rating">
                                        <?php dealer_review_html($ratings); ?>
                                    </div>
                                <?php endif; ?>
                                </div>
                          </div>
                          <div class="col-xl-4 col-lg-4 col-12">
                            <span class="featured-status"><?php echo esc_html__('Featured Seller','idealauto'); ?></span>
                          </div>
                          </div>
                        <div class="row cars-featured-slider" data-slick='{"slidesToShow":3 ,"slidesToScroll": 1, "infinite" : true, "responsive":[{"breakpoint": 1024,"settings":{"slidesToShow": 2}},{"breakpoint": 767,"settings":{"slidesToShow": 1}},{"breakpoint": 480,"settings":{"slidesToShow": 1}}]}'>
                        <?php 
                            $wc_attr = array(
                            'post_type'         => 'cars',
                            'posts_per_page'    => '-1',
                            'author' => $jws_option['cars-dealer-featured'],
                            'meta_query' => array(
                                array(
                                    'key'     => 'car_asset_type',
                    				'value'   => 'featured',
                    				'compare' => 'LIKE',
                                )
                            )
                            );
                            $product_query = new WP_Query($wc_attr);
                            while ($product_query->have_posts()) : $product_query->the_post();
                                   ?>
                                    <div class="col-xl-4 col-lg-6 grid car-item slick-slide">
                                        <?php 
                                            get_template_part( 'template-parts/content/cars/grid' );
                                        ?>
                                    </div> 
                                  <?php   
                                   
                            endwhile;
                         ?>
                    </div>
                    </div>  
                    <?php endif; ?>
                    <div class="all-cars-list-arch row">
            		<?php 
                		if ( have_posts() ) {
                				while ( have_posts() ) :
                					the_post();
                					get_template_part( 'template-parts/content/cars/content', 'cars' );
                                  
                				endwhile; // end of the loop.
                				?>
                			
                			<?php
                		} else {
                			?>
                	
                            	<div class="col-xl-12">
                  					  <h4 class="alert alert-warning">
                        					<?php
                        				    	esc_html_e( 'No result were found matching your selection.', 'idealauto' );
                        					?>
                                        </h4>
                                        <a href id="reset_filters"><?php echo esc_html__('Reset Filter','idealauto'); ?></a>
                    			</div>
                        
                			<?php
                	   }
                	  
                    ?>
                    </div>
                    <?php 
                        if ( have_posts() ) {
                			get_template_part( 'template-parts/content/cars/pagination' );
                	   }
                    ?>
                    </div>
                </div>
                <?php 
                if(isset($jws_option['select-content-before-footer-car-archive']) && !empty($jws_option['select-content-before-footer-car-archive'])) { ?>
                    <div class="content-before-footer">
                        <?php echo do_shortcode('[hf_template id="'.$jws_option['select-content-before-footer-car-archive'].'"]'); ?> 
                    </div> 
                <?php }
              ?></div>
        </div>
</div>


<?php

get_footer();
?>